/*
 * Decompiled with CFR 0.152.
 */
package subvoyage.content.block;

import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.struct.IntSeq;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.draw.DrawArcSmelt;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawBlurSpin;
import mindustry.world.draw.DrawBubbles;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawFlame;
import mindustry.world.draw.DrawLiquidRegion;
import mindustry.world.draw.DrawLiquidTile;
import mindustry.world.draw.DrawPistons;
import mindustry.world.draw.DrawRegion;
import mindustry.world.meta.BuildVisibility;
import subvoyage.content.SvBlocks;
import subvoyage.content.SvItems;
import subvoyage.core.draw.SvFx;
import subvoyage.core.draw.SvPal;
import subvoyage.core.draw.block.DrawBurner;
import subvoyage.core.draw.block.DrawColorWeave;
import subvoyage.core.draw.block.DrawHeatGlow;
import subvoyage.core.draw.block.DrawMixer;
import subvoyage.core.draw.block.DrawSplit;
import subvoyage.type.block.crafter.CircularCrusher;
import subvoyage.type.block.crafter.crude.CrudeSmelter;
import subvoyage.type.block.laser.blocks.LaserCrafter;

public class SvCrafting {
    public static Block ceramicBurner;
    public static Block argonCentrifuge;
    public static Block circularCrusher;
    public static Block hydrogenElectrolyzer;
    public static Block propanePyrolyzer;
    public static Block crudeCrucible;
    public static Block heliumCompressor;
    public static Block phosphidePhotosynthesizer;
    public static Block nitrideBlaster;
    public static Block quartzScutcher;
    public static Block tugRoller;
    public static Block distiller;

    public static void load() {
        ceramicBurner = new GenericCrafter("ceramic-burner"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 150, SvItems.spaclanium, 120, SvItems.finesand, 30}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 30, SvItems.spaclanium, 30});
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawDefault(), new DrawRegion("-top")}).with(new DrawBlock[]{new DrawDefault(), new DrawBurner(), new DrawRegion("-top"), new DrawHeatGlow()});
                this.squareSprite = false;
                this.size = 3;
                this.craftEffect = SvFx.burnFlash;
                this.craftTime = 48.0f;
                this.consumeLiquid(Liquids.water, 0.23333333f);
                this.consumeItem(SvItems.finesand, 2);
                this.outputItem = new ItemStack(SvItems.clay, 3);
                this.itemCapacity = 30;
            }
        };
        argonCentrifuge = new GenericCrafter("argon-centrifuge"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 200, SvItems.spaclanium, 50, SvItems.iridium, 200, SvItems.clay, 80}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 350, SvItems.spaclanium, 400, SvItems.iridium, 150, SvItems.clay, 40});
                this.hasLiquids = true;
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawDefault()}).with(new DrawBlock[]{new DrawDefault(), new DrawLiquidRegion(SvItems.argon), new DrawArcSmelt(){
                    {
                        this.flameColor = SvPal.argonFlame;
                        this.midColor = SvPal.argonMidSmelt;
                        this.flameRad = 1.0f;
                        this.circleSpace = 1.0f;
                        this.flameRadiusScl = 3.0f;
                        this.flameRadiusMag = 0.3f;
                        this.circleStroke = 1.25f;
                        this.particles = 16;
                        this.particleLife = 30.0f;
                        this.particleRad = 5.2f;
                        this.particleStroke = 0.8f;
                        this.particleLen = 2.25f;
                    }
                }});
                this.squareSprite = false;
                this.size = 3;
                this.craftEffect = Fx.none;
                this.craftTime = 33.6f;
                this.consumeItem(SvItems.corallite, 1);
                this.consumeItem(SvItems.sulfur, 1);
                this.consumeLiquid(Liquids.water, 0.4f);
                this.outputLiquid = new LiquidStack(SvItems.argon, 0.8f);
            }
        };
        circularCrusher = new CircularCrusher("circular-crusher"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 120, SvItems.spaclanium, 60, SvItems.iridium, 20}));
                this.size = 3;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 600, SvItems.spaclanium, 120, SvItems.iridium, 400});
                this.itemCapacity = 30;
                this.size = 3;
                this.craftEffect = Fx.crawlDust;
                this.craftTime = 40.0f;
                this.envDisabled |= 0x10;
                this.consumeItem(SvItems.crude, 1);
                this.consumePower(0.6f);
                this.outputItem = new ItemStack(SvItems.finesand, 3);
                this.hasItems = true;
                this.hasPower = true;
            }
        };
        hydrogenElectrolyzer = new GenericCrafter("hydrogen-electrolyzer"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.iridium, 200, SvItems.clay, 250, SvItems.chrome, 100, SvItems.phosphide, 80}));
                this.craftTime = 50.0f;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 720, SvItems.spaclanium, 720, SvItems.iridium, 340, SvItems.clay, 340});
                this.itemCapacity = 30;
                this.size = 3;
                this.hasItems = true;
                this.hasLiquids = true;
                this.hasPower = true;
                this.envDisabled |= 0x10;
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawRegion("-bottom"), new DrawDefault(), new DrawRegion("-top")}).with(new DrawBlock[]{new DrawRegion("-bottom"), new DrawMixer(), new DrawDefault(), new DrawRegion("-top")});
                this.outputLiquid = new LiquidStack(SvItems.hydrogen, 0.3f);
                this.consumeLiquid(Liquids.water, 0.4f);
                this.consumePower(0.8f);
            }
        };
        propanePyrolyzer = new GenericCrafter("propane-pyrolizer"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 280, SvItems.iridium, 200, SvItems.clay, 250, SvItems.chrome, 100}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.iridium, 300, SvItems.corallite, 700, SvItems.clay, 400});
                this.itemCapacity = 20;
                this.size = 3;
                this.craftEffect = Fx.fireSmoke;
                this.craftTime = 48.0f;
                this.envDisabled |= 0x10;
                this.consumeLiquid(SvItems.hydrogen, 0.3f);
                this.consumeItem(SvItems.crude, 1);
                this.consumePower(0.45f);
                this.drawer = DrawSplit.withLow().with(new DrawBlock[]{new DrawDefault(), new DrawHeatGlow()});
                this.outputLiquid = new LiquidStack(SvItems.propane, 0.8f);
                this.hasLiquids = true;
            }
        };
        crudeCrucible = new CrudeSmelter("crude-crucible"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 340, SvItems.iridium, 120, SvItems.clay, 250}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.corallite, 680, SvItems.iridium, 700, SvItems.clay, 650});
                this.squareSprite = false;
                this.itemCapacity = 30;
                this.size = 3;
                this.craftEffect = Fx.smokePuff;
                this.recipes = 6.recipes(SvItems.corallite, 4, 80, SvItems.spaclanium, 3, 60, SvItems.iridium, 5, 90, SvItems.chrome, 2, 120);
                this.drawer = DrawSplit.withLow().with(new DrawBlock[]{new DrawDefault(), new DrawFlame(){
                    {
                        this.lightRadius = 70.0f;
                        this.flameRadius = 6.0f;
                    }
                }});
                this.consumeItem(SvItems.crude, 2);
                this.consumeLiquid(SvItems.hydrogen, 0.2f);
                this.consumeLiquid(SvItems.propane, 0.53333336f);
                this.consumePower(1.2f);
                this.hasItems = true;
                this.hasLiquids = true;
                this.hasPower = true;
            }
        };
        heliumCompressor = new GenericCrafter("helium-compressor"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.corallite, 250, SvItems.iridium, 150, SvItems.clay, 250}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.chrome, 500, SvItems.iridium, 600, SvItems.corallite, 1200, SvItems.clay, 800});
                this.itemCapacity = 20;
                this.size = 3;
                this.craftEffect = SvFx.smokeCloud;
                this.craftTime = 90.0f;
                this.envDisabled |= 0x10;
                this.consumeLiquid(Liquids.water, 0.26666668f);
                this.consumeLiquid(SvItems.hydrogen, 0.33333334f);
                this.consumePower(0.6f);
                this.drawer = DrawSplit.withLow().with(new DrawBlock[]{new DrawDefault(), new DrawLiquidRegion(SvItems.helium)});
                this.outputLiquid = new LiquidStack(SvItems.helium, 0.8666667f);
                this.hasLiquids = true;
            }
        };
        phosphidePhotosynthesizer = new LaserCrafter("phosphide-photosynthesizer"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 300, SvItems.iridium, 250, SvItems.clay, 150, SvItems.chrome, 200}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.chrome, 600, SvItems.iridium, 400, SvItems.corallite, 600, SvItems.clay, 400});
                this.itemCapacity = 25;
                this.size = 3;
                this.craftEffect = SvFx.photosynthFlash;
                this.craftTime = 120.0f;
                this.envDisabled |= 0x10;
                this.consumeItem(SvItems.iridium, 1);
                this.consumeItem(SvItems.spaclanium, 2);
                this.consumePower(0.8f);
                this.laserRequirement = 15.0f;
                this.laserOverpowerScale = 0.8f;
                this.laserMaxEfficiency = 2.5f;
                this.maxSuppliers = 1;
                this.inputRange = (short)8;
                this.drawInputs = false;
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawDefault(), new DrawRegion("-top")}).with(new DrawBlock[]{new DrawDefault(), new DrawPistons(), new DrawRegion("-top")});
                this.outputItem = new ItemStack(SvItems.phosphide, 3);
            }

            public TextureRegion[] icons() {
                return new TextureRegion[]{this.fullIcon};
            }
        };
        nitrideBlaster = new LaserCrafter("nitride-blaster"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(), ItemStack.with((Object[])new Object[]{SvItems.iridium, 400, SvItems.clay, 300, SvItems.chrome, 300, SvItems.phosphide, 120}));
                this.itemCapacity = 25;
                this.size = 3;
                this.craftEffect = SvFx.blast;
                this.craftTime = 120.0f;
                this.envDisabled |= 0x10;
                this.consumeItem(SvItems.sulfur, 1);
                this.consumeLiquid(SvItems.propane, 0.53333336f);
                this.consumePower(0.8f);
                this.laserRequirement = 15.0f;
                this.laserOverpowerScale = 0.8f;
                this.laserMaxEfficiency = 2.5f;
                this.maxSuppliers = 1;
                this.inputRange = (short)8;
                this.drawInputs = false;
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawRegion("-bottom"), new DrawDefault()}).with(new DrawBlock[]{new DrawRegion("-bottom"), new DrawArcSmelt(){
                    {
                        this.drawCenter = true;
                        this.flameColor = SvPal.teslaCharge;
                        this.midColor = SvPal.teslaCharge.cpy().lerp(Color.white, 0.5f);
                        this.circleStroke = 0.3f;
                        this.particleStroke = 0.3f;
                    }
                }, new DrawRegion(""){
                    {
                        super(arg0);
                        this.layer = 35.0f;
                    }
                }});
                this.outputItem = new ItemStack(SvItems.nitride, 2);
            }

            public TextureRegion[] icons() {
                return new TextureRegion[]{this.fullIcon};
            }
        };
        quartzScutcher = new LaserCrafter("quartz-scutcher"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(BuildVisibility.sandboxOnly), ItemStack.with((Object[])new Object[]{SvItems.phosphide, 350, SvItems.iridium, 600, SvItems.spaclanium, 300, SvItems.chrome, 150}));
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.phosphide, 2350, SvItems.iridium, 2400, SvItems.spaclanium, 2400, SvItems.chrome, 1500});
                this.itemCapacity = 30;
                this.size = 3;
                this.craftEffect = SvFx.scutchFlash;
                this.craftTime = 100.0f;
                this.envDisabled |= 0x10;
                this.consumeItem(SvItems.spaclanium, 3);
                this.consumeLiquid(SvItems.hydrogen, 0.6333333f);
                this.consumeLiquid(SvItems.argon, 0.6333333f);
                this.consumePower(6.6666665f);
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawRegion("-bottom"), new DrawDefault()}).with(new DrawBlock[]{new DrawRegion("-bottom"), new DrawColorWeave(SvPal.quartzWeave), new DrawDefault()});
                this.outputItem = new ItemStack(SvItems.quartzFiber, 2);
                this.laserRequirement = 120.0f;
                this.laserOverpowerScale = 0.8f;
                this.laserMaxEfficiency = 2.0f;
                this.inputs = IntSeq.range((int)0, (int)3);
                this.capacity = 300.0f;
                this.maxSuppliers = 1;
                this.inputRange = (short)8;
                this.drawInputs = false;
                this.hasItems = true;
                this.hasLiquids = true;
                this.hasPower = true;
            }
        };
        distiller = new GenericCrafter("distiller"){
            {
                this.requirements(Category.crafting, SvBlocks.atl(BuildVisibility.editorOnly), ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 100, SvItems.corallite, 60}));
                this.outputLiquid = new LiquidStack(Liquids.water, 0.53333336f);
                this.craftTime = 140.0f;
                this.researchCost = ItemStack.with((Object[])new Object[]{SvItems.spaclanium, 700, SvItems.corallite, 800});
                this.itemCapacity = 30;
                this.size = 2;
                this.squareSprite = false;
                this.hasItems = true;
                this.hasLiquids = true;
                this.envDisabled |= 0x10;
                this.drawer = DrawSplit.withLow(new DrawBlock[]{new DrawRegion("-bottom"), new DrawRegion("-top"), new DrawDefault()}).with(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(SvItems.hardWater, 2.0f), new DrawBubbles(Color.valueOf((String)"7693e3")){
                    {
                        super(arg0);
                        this.sides = 10;
                        this.recurrence = 3.0f;
                        this.spread = 6.0f;
                        this.radius = 1.5f;
                        this.amount = 20;
                    }
                }, new DrawBlurSpin("-rotator", 6.0f), new DrawRegion("-top"), new DrawDefault()});
                this.consumeLiquid(SvItems.hardWater, 0.26666668f);
            }
        };
    }
}

