/*
 * Decompiled with CFR 0.152.
 */
package subvoyage;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.util.Log;
import arc.util.Reflect;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.mod.Mod;
import subvoyage.content.SvContent;
import subvoyage.content.SvUnits;
import subvoyage.content.other.SvTeam;
import subvoyage.content.world.SvTechTree;
import subvoyage.core.SvSettings;
import subvoyage.core.UpdateManager;
import subvoyage.core.anno.LoadAnnoProcessor;
import subvoyage.core.draw.SvRender;
import subvoyage.core.draw.shader.SvShaders;
import subvoyage.core.logic.SvCall;
import subvoyage.core.logic.SvLogic;
import subvoyage.core.ui.advancements.Advancement;

public class Subvoyage
extends Mod {
    public static String ID = "subvoyage";
    public static UpdateManager.VersionControl versionControl = new UpdateManager.VersionControl();
    public static String currentTag;
    public static String GITHUB_REPO;

    public Subvoyage() {
        Events.run((Object)EventType.Trigger.update, SvLogic::update);
        Events.on(EventType.ClientLoadEvent.class, e -> SvLogic.clientLoad());
        Events.on(EventType.WorldLoadEvent.class, e -> SvLogic.worldLoad());
        Events.on(EventType.ResetEvent.class, e -> SvLogic.reset());
        Events.run((Object)EventType.Trigger.newGame, SvLogic::newGame);
        Events.run((Object)EventType.Trigger.draw, SvRender::draw);
        Events.on(EventType.UnitCreateEvent.class, e -> {
            if (e.unit.team == SvTeam.melius) {
                if (e.unit.type == SvUnits.lapetus) {
                    Advancement.unit_helio.unlock();
                }
                if (e.unit.type == SvUnits.leeft) {
                    Advancement.unit_hydro.unlock();
                }
                if (e.unit.type == SvUnits.stunt) {
                    Advancement.unit_rover.unlock();
                }
            }
        });
        Events.on(EventType.FileTreeInitEvent.class, e -> Core.app.post(SvShaders::init));
        Events.on(EventType.DisposeEvent.class, e -> SvShaders.dispose());
        Events.on(EventType.ContentInitEvent.class, e -> LoadAnnoProcessor.begin(ID));
    }

    public void init() {
        super.init();
        SvSettings.load();
        Colors.put((String)"sv-accent", (Color)Color.valueOf((String)"7ede8a"));
        try {
            if (Version.isAtLeast((String)"147")) {
                Reflect.invoke((Object)Vars.logicVars, (String)"put", (Object[])new Object[]{"@melius", SvTeam.melius}, (Class[])new Class[]{String.class, Object.class});
            } else {
                Reflect.invoke((Object)Vars.logicVars, (String)"put", (Object[])new Object[]{"@melius", SvTeam.melius}, (Class[])new Class[]{String.class, Object.class});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadContent() {
        Log.info((Object)"Poof-poof, Subvoyage loads up!");
        SvCall.registerPackets();
        SvContent.load();
        SvRender.initEnv();
        SvTechTree.load();
    }

    static {
        GITHUB_REPO = "Sublemon-Team/Subvoyage";
    }
}

