/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.production;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.BuildingTetherc;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.UnitTetherBlock;
import mindustry.world.meta.BlockFlag;
import progressed.content.PMUnitTypes;
import progressed.graphics.PMDrawf;
import progressed.util.PMUtls;

public class UnitMinerDepot
extends Block {
    public UnitType unitType = PMUnitTypes.draug;
    public float buildTime = 480.0f;
    public float polyStroke = 1.8f;
    public float polyRadius = 6.75f;
    public float polyRot = 0.0f;
    public float polyStrokeScl = 1.75f;
    public float polyStrokeSclSpeed = 0.03f;
    public float polyStrokeTime = 120.0f;
    public int polySides = 4;
    public Color polyColor = Pal.accent;

    public UnitMinerDepot(String name) {
        super(name);
        this.solid = true;
        this.update = true;
        this.hasItems = true;
        this.configurable = true;
        this.clearOnDoubleTap = true;
        this.commandable = true;
        this.itemCapacity = 200;
        this.ambientSound = Sounds.respawning;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.drill});
        this.config(Item.class, (build, item) -> {
            build.targetItem = item;
            build.commandPos = null;
            build.targetSet = false;
        });
        this.configClear(build -> {
            build.targetItem = null;
            build.commandPos = null;
            build.targetSet = false;
        });
    }

    public void setBars() {
        super.setBars();
        this.addBar("units", e -> new Bar(() -> Core.bundle.format("bar.unitcap", new Object[]{Fonts.getUnicodeStr((String)this.unitType.name), e.team.data().countType(this.unitType), Units.getStringCap((Team)e.team)}), () -> Pal.power, () -> (float)e.team.data().countType(this.unitType) / (float)Units.getCap((Team)e.team)));
    }

    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return super.canPlaceOn(tile, team, rotation) && Units.canCreate((Team)team, (UnitType)this.unitType);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        if (!Units.canCreate((Team)Vars.player.team(), (UnitType)this.unitType)) {
            this.drawPlaceText(Core.bundle.get("bar.cargounitcap"), x, y, valid);
        }
    }

    public class UnitMinerDepotBuild
    extends Building
    implements UnitTetherBlock {
        public int readUnitId = -1;
        public float buildProgress;
        public float totalProgress;
        public float warmup;
        public float readyness;
        public float strokeScl;
        public Unit unit;
        public Vec2 commandPos;
        public Item targetItem;
        public ObjectMap<Item, Tile> oreTiles = new ObjectMap();
        public boolean oresFound;
        public boolean targetSet;

        public void updateTile() {
            Tile ore;
            if (this.unit != null && (this.unit.dead || !this.unit.isAdded())) {
                this.unit = null;
            }
            if (this.readUnitId != -1) {
                this.unit = (Unit)Groups.unit.getByID(this.readUnitId);
                if (this.unit != null || !Vars.net.client()) {
                    this.readUnitId = -1;
                }
            }
            this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.efficiency, (float)0.016666668f);
            this.readyness = Mathf.approachDelta((float)this.readyness, (float)(this.unit != null ? 1.0f : 0.0f), (float)0.016666668f);
            float scl = 1.0f + (1.0f - Interp.pow3Out.apply(Time.time % UnitMinerDepot.this.polyStrokeTime / UnitMinerDepot.this.polyStrokeTime)) * (UnitMinerDepot.this.polyStrokeScl - 1.0f);
            this.strokeScl = Mathf.approachDelta((float)this.strokeScl, (float)scl, (float)UnitMinerDepot.this.polyStrokeSclSpeed);
            if (!this.targetSet && this.targetItem != null && this.commandPos != null && (ore = Vars.world.tileWorld(this.commandPos.x, this.commandPos.y)) != null && PMUtls.oreDrop(ore) == this.targetItem) {
                this.oreTiles.put((Object)this.targetItem, (Object)ore);
                this.targetSet = true;
                if (this.unit != null) {
                    this.unit.mineTile = null;
                }
            }
            if (!this.oresFound) {
                this.oresFound = true;
                UnitMinerDepot.this.unitType.mineItems.each(i -> {
                    if (!this.oreTiles.containsKey(i)) {
                        this.oreTiles.put(i, (Object)Vars.indexer.findClosestOre(this.x, this.y, i));
                    }
                });
            }
            if (this.unit == null && Units.canCreate((Team)this.team, (UnitType)UnitMinerDepot.this.unitType)) {
                this.buildProgress += this.edelta() / UnitMinerDepot.this.buildTime;
                this.totalProgress += this.edelta();
                if (this.buildProgress >= 1.0f && !Vars.net.client()) {
                    this.unit = UnitMinerDepot.this.unitType.create(this.team);
                    Unit unit = this.unit;
                    if (unit instanceof BuildingTetherc) {
                        BuildingTetherc bt = (BuildingTetherc)unit;
                        bt.building((Building)this);
                    }
                    this.unit.set(this.x, this.y);
                    this.unit.rotation = 90.0f;
                    this.unit.add();
                    Call.unitTetherBlockSpawned((Tile)this.tile, (int)this.unit.id);
                }
            }
            this.dump();
        }

        public Vec2 getCommandPosition() {
            return this.commandPos;
        }

        public void onCommand(Vec2 target) {
            this.commandPos = target;
            this.targetSet = false;
        }

        public void spawned(int id) {
            Fx.spawn.at(this.x, this.y);
            this.buildProgress = 0.0f;
            if (Vars.net.client()) {
                this.readUnitId = id;
            }
        }

        public boolean shouldConsume() {
            return this.unit == null;
        }

        public void draw() {
            Draw.rect((TextureRegion)this.block.region, (float)this.x, (float)this.y);
            if (this.unit == null) {
                Draw.draw((float)35.0f, () -> Drawf.construct((Building)this, (TextureRegion)UnitMinerDepot.this.unitType.fullIcon, (float)0.0f, (float)this.buildProgress, (float)this.warmup, (float)this.totalProgress));
            } else {
                Draw.z((float)99.99f);
                Draw.color((Color)UnitMinerDepot.this.polyColor);
                Lines.stroke((float)(UnitMinerDepot.this.polyStroke * this.readyness * this.strokeScl));
                Lines.poly((float)this.x, (float)this.y, (int)UnitMinerDepot.this.polySides, (float)UnitMinerDepot.this.polyRadius, (float)UnitMinerDepot.this.polyRot);
                Draw.reset();
                Draw.z((float)30.0f);
            }
        }

        public void drawSelect() {
            super.drawSelect();
            if (this.targetItem != null) {
                Tile ore = (Tile)this.oreTiles.get((Object)this.targetItem);
                PMDrawf.targetLine(this.x, this.y, ore.worldx(), ore.worldy(), this.hitSize() / 1.4f + 1.0f, 4.0f, this.targetItem.color);
            }
            Draw.reset();
        }

        public float totalProgress() {
            return this.totalProgress;
        }

        public float progress() {
            return this.buildProgress;
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            return Math.min(UnitMinerDepot.this.itemCapacity - this.items.total(), amount);
        }

        public void buildConfiguration(Table table) {
            Seq targets = UnitMinerDepot.this.unitType.mineItems.select(i -> Vars.indexer.hasOre(i));
            ItemSelection.buildTable((Block)UnitMinerDepot.this, (Table)table, (Seq)targets, () -> this.targetItem, arg_0 -> ((UnitMinerDepotBuild)this).configure(arg_0));
        }

        public Object config() {
            return this.targetItem;
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.unit == null ? -1 : this.unit.id);
            TypeIO.writeItem((Writes)write, (Item)this.targetItem);
            TypeIO.writeVecNullable((Writes)write, (Vec2)this.commandPos);
            write.i(this.oreTiles.size);
            for (ObjectMap.Entry entry : this.oreTiles.entries()) {
                write.s((int)((Item)entry.key).id);
                write.i(entry.value == null ? -1 : ((Tile)entry.value).pos());
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.readUnitId = read.i();
            this.targetItem = TypeIO.readItem((Reads)read);
            this.commandPos = TypeIO.readVecNullable((Reads)read);
            int size = read.i();
            for (int i = 0; i < size; ++i) {
                Tile ore;
                Item item = Vars.content.item((int)read.s());
                int pos = read.i();
                Tile tile = ore = pos != -1 ? Vars.world.tile(pos) : null;
                if (item == null || ore == null) continue;
                this.oreTiles.put((Object)item, (Object)ore);
            }
        }
    }
}

