/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.production;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.production.Drill;
import progressed.graphics.PMDrawf;

public class SmartDrill
extends Drill {
    public SmartDrill(String name) {
        super(name);
        this.configurable = true;
        this.config(Item.class, (tile, item) -> {
            this.countOre(tile.tile);
            tile.dominantItem = item;
            tile.dominantItems = this.oreCount.get(item);
        });
        this.configClear(tile -> {
            tile.dominantItem = null;
        });
    }

    public float drawWorldText(String text, float x, float y, boolean valid, boolean underline) {
        if (Vars.renderer.pixelator.enabled()) {
            return 0.0f;
        }
        Color color = valid ? Pal.accent : Pal.remove;
        return PMDrawf.text(x, y + (float)(this.size * 8) / 2.0f + 3.0f, color, text);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawPotentialLinks(x, y);
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return;
        }
        this.countOre(tile);
        if (this.itemArray.any()) {
            float items = (float)this.itemArray.size - 1.0f;
            for (int i = 0; i < this.itemArray.size; ++i) {
                Item item = (Item)this.itemArray.get(i);
                int count = this.oreCount.get((Object)item, 0);
                float mul = (items - (float)i) / items;
                float tx = (float)(x * 8) + this.offset;
                float ty = (float)(y * 8) + this.offset + 8.0f * items * (items == 0.0f ? 0.0f : mul);
                float width = this.drawWorldText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / (this.drillTime + this.hardnessDrillMultiplier * (float)item.hardness) * (float)count, 2), tx, ty, valid, i == this.itemArray.size - 1);
                float dx = tx - width / 2.0f - 3.0f;
                float dy = ty + (float)(this.size * 8) / 2.0f + 5.0f;
                float s = 6.0f;
                Draw.mixcol((Color)Color.darkGray, (float)1.0f);
                Draw.rect((TextureRegion)item.fullIcon, (float)dx, (float)(dy - 1.0f), (float)s, (float)s);
                Draw.reset();
                Draw.rect((TextureRegion)item.fullIcon, (float)dx, (float)dy, (float)s, (float)s);
            }
        } else {
            Item item;
            Tile to = (Tile)tile.getLinkedTilesAs((Block)this, tempTiles).find(t -> t.drop() != null && t.drop().hardness > this.tier);
            Item item2 = item = to == null ? null : to.drop();
            if (item != null) {
                this.drawPlaceText(Core.bundle.get("bar.drilltierreq"), x, y, valid);
            }
        }
    }

    protected void countOre(Tile tile) {
        this.returnItem = null;
        this.returnCount = 0;
        this.oreCount.clear();
        this.itemArray.clear();
        for (Tile other : tile.getLinkedTilesAs((Block)this, tempTiles)) {
            if (!this.canMine(other)) continue;
            this.oreCount.increment((Object)this.getDrop(other), 0, 1);
        }
        for (Item item2 : this.oreCount.keys()) {
            this.itemArray.add((Object)item2);
        }
        this.itemArray.sort(item -> -60.0f / (this.drillTime + this.hardnessDrillMultiplier * (float)item.hardness) * (float)this.oreCount.get(item, 0));
        if (this.itemArray.size == 0) {
            return;
        }
        this.returnItem = (Item)this.itemArray.peek();
        this.returnCount = this.oreCount.get((Object)((Item)this.itemArray.peek()), 0);
    }

    public class SmartDrillBuild
    extends Drill.DrillBuild {
        public SmartDrillBuild() {
            super((Drill)SmartDrill.this);
        }

        public void placed() {
            super.placed();
            SmartDrill.this.countOre(this.tile);
            if (!SmartDrill.this.itemArray.contains(i -> i == this.dominantItem)) {
                this.configure(null);
            }
        }

        public void onProximityUpdate() {
        }

        public void updateTile() {
            if (!this.isDrilling()) {
                this.timeDrilled += this.warmup * this.delta();
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)SmartDrill.this.warmupSpeed);
                return;
            }
            if (this.timer(SmartDrill.this.timerDump, SmartDrill.this.dumpTime)) {
                this.dump(this.items.has(this.dominantItem) ? this.dominantItem : null);
            }
            this.timeDrilled += this.warmup * this.delta();
            if (this.items.total() < SmartDrill.this.itemCapacity && this.dominantItems > 0 && this.canConsume()) {
                float speed = Mathf.lerp((float)1.0f, (float)SmartDrill.this.liquidBoostIntensity, (float)this.optionalEfficiency) * this.efficiency;
                this.lastDrillSpeed = speed * (float)this.dominantItems * this.warmup / (SmartDrill.this.drillTime + SmartDrill.this.hardnessDrillMultiplier * (float)this.dominantItem.hardness);
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)speed, (float)SmartDrill.this.warmupSpeed);
                this.progress += this.delta() * (float)this.dominantItems * speed * this.warmup;
                if (Mathf.chanceDelta((double)(SmartDrill.this.updateEffectChance * this.warmup))) {
                    SmartDrill.this.updateEffect.at(this.x + Mathf.range((float)((float)SmartDrill.this.size * 2.0f)), this.y + Mathf.range((float)((float)SmartDrill.this.size * 2.0f)));
                }
            } else {
                this.lastDrillSpeed = 0.0f;
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)SmartDrill.this.warmupSpeed);
                return;
            }
            float delay = SmartDrill.this.drillTime + SmartDrill.this.hardnessDrillMultiplier * (float)this.dominantItem.hardness;
            if (this.dominantItems > 0 && this.progress >= delay && this.items.total() < SmartDrill.this.itemCapacity) {
                this.offload(this.dominantItem);
                this.progress %= delay;
                SmartDrill.this.drillEffect.at(this.x + Mathf.range((float)SmartDrill.this.drillEffectRnd), this.y + Mathf.range((float)SmartDrill.this.drillEffectRnd), this.dominantItem.color);
            }
        }

        public boolean isDrilling() {
            return this.dominantItem != null;
        }

        public boolean shouldConsume() {
            return this.enabled && this.isDrilling() && this.items.get(this.dominantItem) < SmartDrill.this.itemCapacity;
        }

        public void buildConfiguration(Table table) {
            SmartDrill.this.countOre(this.tile);
            ItemSelection.buildTable((Block)SmartDrill.this, (Table)table, (Seq)SmartDrill.this.itemArray, () -> this.dominantItem, arg_0 -> ((SmartDrillBuild)this).configure(arg_0));
        }

        public void drawConfigure() {
            super.drawConfigure();
            SmartDrill.this.countOre(this.tile);
            float items = (float)((SmartDrill)SmartDrill.this).itemArray.size - 1.0f;
            for (int i = 0; i < ((SmartDrill)SmartDrill.this).itemArray.size; ++i) {
                Item item = (Item)SmartDrill.this.itemArray.get(i);
                int count = SmartDrill.this.oreCount.get((Object)item, 0);
                float mul = (items - (float)i) / items;
                float ty = this.y + 8.0f * items * (items == 0.0f ? 0.0f : mul);
                float width = SmartDrill.this.drawWorldText(Core.bundle.formatFloat("bar.drillspeed", 60.0f / (SmartDrill.this.drillTime + SmartDrill.this.hardnessDrillMultiplier * (float)item.hardness) * (float)count, 2), this.x, ty, true, i == ((SmartDrill)SmartDrill.this).itemArray.size - 1);
                float dx = this.x - width / 2.0f - 3.0f;
                float dy = ty + (float)(SmartDrill.this.size * 8) / 2.0f + 5.0f;
                float s = 6.0f;
                Draw.mixcol((Color)Color.darkGray, (float)1.0f);
                Draw.rect((TextureRegion)item.fullIcon, (float)dx, (float)(dy - 1.0f), (float)s, (float)s);
                Draw.reset();
                Draw.rect((TextureRegion)item.fullIcon, (float)dx, (float)dy, (float)s, (float)s);
            }
        }

        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                this.deselect();
                this.configure(null);
                return false;
            }
            return true;
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.dominantItem != null);
            if (this.dominantItem != null) {
                write.i((int)this.dominantItem.id);
                write.i(this.dominantItems);
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 2) {
                boolean hasDominant;
                boolean bl = hasDominant = revision == 2 || revision >= 3 && read.bool();
                if (hasDominant) {
                    this.dominantItem = Vars.content.item(read.i());
                    this.dominantItems = read.i();
                }
            }
        }

        public byte version() {
            return 3;
        }
    }
}

