/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.payloads;

import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import progressed.world.blocks.payloads.Missile;

public class Recipe {
    public float craftTime;
    public boolean requiresUnlock = true;
    public boolean blockBuild = true;
    public boolean centerBuild;
    public ItemStack[] itemRequirements;
    public LiquidStack liquidRequirements;
    public float powerUse;
    public Block inputBlock;
    public Block outputBlock;

    public Recipe(Block block) {
        this.outputBlock = block;
        this.itemRequirements = block.requirements;
        if (block instanceof Missile) {
            Missile m = (Missile)block;
            this.craftTime = m.constructTime;
            this.powerUse = m.powerUse;
            this.inputBlock = m.prev;
        }
    }

    public Recipe(Block block, float powerUse, float craftTime) {
        this(block);
        this.craftTime = craftTime;
        this.powerUse = powerUse;
    }

    public Recipe(Block outputBlock, Block inputBlock, float powerUse, float craftTime) {
        this(outputBlock, powerUse, craftTime);
        this.inputBlock = inputBlock;
    }

    public Liquid getLiquidInput() {
        return this.liquidRequirements != null ? this.liquidRequirements.liquid : null;
    }

    public boolean hasLiquidInput(Liquid liquid) {
        return this.liquidRequirements != null && this.liquidRequirements.liquid == liquid;
    }

    public boolean hasInputBlock() {
        return this.inputBlock != null;
    }

    public boolean showReqList() {
        return this.itemRequirements.length > 0 || this.liquidRequirements != null;
    }

    public boolean unlocked() {
        return !this.requiresUnlock || this.outputBlock.unlockedNow();
    }
}

