/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.payloads;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.ui.ReqImage;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItemDynamic;
import mindustry.world.meta.Stat;
import progressed.graphics.PMDrawf;
import progressed.world.blocks.consumers.ConsumeLiquidDynamic;
import progressed.world.blocks.payloads.Recipe;
import progressed.world.meta.PMStat;
import progressed.world.meta.PMStatValues;

public class PayloadCrafter
extends PayloadBlock {
    private float scrollPos;
    public Seq<Recipe> recipes = new Seq();
    public boolean hasTop = true;

    public PayloadCrafter(String name) {
        super(name);
        this.update = true;
        this.rotate = true;
        this.logicConfigurable = true;
        this.configurable = true;
        this.config(Block.class, (tile, block) -> {
            if (tile.recipe != block) {
                tile.progress = 0.0f;
            }
            if (this.canProduce((Block)block)) {
                tile.recipe = block;
            }
        });
        this.configClear(tile -> {
            tile.recipe = null;
            tile.progress = 0.0f;
        });
    }

    public void recipes(Block ... blocks) {
        for (Block b : blocks) {
            this.recipes.add((Object)new Recipe(b));
        }
    }

    public void recipes(Recipe ... newRecipes) {
        for (Recipe r : newRecipes) {
            this.recipes.add((Object)r);
        }
    }

    public void setRecipeProductionStats() {
        for (Recipe r : this.recipes) {
            if (r.outputBlock == null) continue;
            r.outputBlock.stats.add(PMStat.producer, s -> {
                s.row();
                s.table(Styles.grayPanel, t -> {
                    t.left().defaults().top().left();
                    if (Vars.state.rules.bannedBlocks.contains((Object)this)) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f);
                        return;
                    }
                    t.image(this.fullIcon).size(96.0f);
                    t.table(n -> {
                        n.defaults().left();
                        n.add((CharSequence)this.localizedName);
                        n.row();
                        PMStatValues.infoButton(n, (UnlockableContent)this, 32.0f).padTop(4.0f);
                    }).padLeft(8.0f);
                }).left().top().growX().margin(10.0f).padTop(5.0f).padBottom(5.0f);
            });
            if (!r.hasInputBlock()) continue;
            r.inputBlock.stats.add(PMStat.produce, s -> {
                s.row();
                s.table(Styles.grayPanel, t -> {
                    t.left().defaults().top().left();
                    if (Vars.state.rules.bannedBlocks.contains((Object)r.outputBlock)) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f);
                        return;
                    }
                    if (!r.outputBlock.unlockedNow()) {
                        t.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f);
                        t.add((CharSequence)"@pm-missing-research").center().left();
                        return;
                    }
                    t.image(r.outputBlock.fullIcon).size(96.0f);
                    t.table(n -> {
                        n.defaults().left();
                        n.add((CharSequence)r.outputBlock.localizedName);
                        n.row();
                        PMStatValues.infoButton(n, (UnlockableContent)this, 32.0f).padTop(4.0f);
                    }).padLeft(8.0f);
                }).left().top().growX().margin(10.0f).padTop(5.0f).padBottom(5.0f);
            });
        }
    }

    public void init() {
        if (this.recipes.contains(r -> r.powerUse > 0.0f)) {
            this.consumePowerDynamic(b -> ((PayloadCrafterBuild)((Object)b)).powerUse());
        }
        if (this.recipes.contains(r -> r.itemRequirements != null)) {
            this.consume((Consume)new ConsumeItemDynamic(e -> e.hasRecipe() && e.recipe().itemRequirements != null ? e.recipe().itemRequirements : ItemStack.empty));
        }
        if (this.recipes.contains(r -> r.liquidRequirements != null)) {
            this.consume(new ConsumeLiquidDynamic(e -> e.hasRecipe() ? e.recipe().liquidRequirements : null));
        }
        if (this.recipes.contains(r -> r.inputBlock != null)) {
            this.acceptsPayload = true;
        }
        if (this.recipes.contains(r -> r.outputBlock != null)) {
            this.outputsPayload = true;
        }
        super.init();
    }

    public void load() {
        super.load();
        this.inRegion = Core.atlas.find(this.name + "-in", Core.atlas.find("factory-in-" + this.size + this.regionSuffix, "prog-mats-factory-in-" + this.size + this.regionSuffix));
        this.outRegion = Core.atlas.find(this.name + "-out", Core.atlas.find("factory-out-" + this.size + this.regionSuffix, "prog-mats-factory-out-" + this.size + this.regionSuffix));
        if (!this.hasTop) {
            this.topRegion = Core.atlas.find("clear");
        }
    }

    public TextureRegion[] icons() {
        if (this.recipes.contains(Recipe::hasInputBlock)) {
            return new TextureRegion[]{this.region, this.inRegion, this.outRegion, this.topRegion};
        }
        return new TextureRegion[]{this.region, this.outRegion, this.topRegion};
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.powerUse);
        this.stats.remove(Stat.itemCapacity);
        this.stats.remove(Stat.liquidCapacity);
        this.stats.add(PMStat.recipes, PMStatValues.payloadProducts(this.recipes));
    }

    public void setBars() {
        super.setBars();
        if (this.hasLiquids) {
            this.removeBar("liquid");
            this.addBar("liquid", entity -> {
                Liquid l = entity.hasRecipe() ? entity.recipe().getLiquidInput() : null;
                return new Bar(() -> l != null ? l.localizedName : Core.bundle.get("bar.liquid"), () -> l != null ? l.barColor() : Color.white, () -> entity.liquids == null || l == null ? 0.0f : entity.liquids.get(l) / this.liquidCapacity);
            });
        }
        this.addBar("progress", entity -> new Bar("bar.progress", Pal.ammo, () -> entity.recipe() == null ? 0.0f : entity.progress / entity.recipe().craftTime));
    }

    public void drawPlanRegion(BuildPlan req, Eachable<BuildPlan> list) {
        Draw.rect((TextureRegion)this.region, (float)req.drawx(), (float)req.drawy());
        if (this.recipes.contains(r -> r.inputBlock != null)) {
            Draw.rect((TextureRegion)this.inRegion, (float)req.drawx(), (float)req.drawy(), (float)(req.rotation * 90));
        }
        Draw.rect((TextureRegion)this.outRegion, (float)req.drawx(), (float)req.drawy(), (float)(req.rotation * 90));
        Draw.rect((TextureRegion)this.topRegion, (float)req.drawx(), (float)req.drawy());
    }

    public boolean canProduce(Block b) {
        if (this.recipes.contains(r -> r.outputBlock == b)) {
            return ((Recipe)this.recipes.find(r -> r.outputBlock == b)).unlocked();
        }
        return false;
    }

    public class PayloadCrafterBuild
    extends PayloadBlock.PayloadBlockBuild<BuildPayload> {
        public float progress;
        public float time;
        public float heat;
        @Nullable
        public Block recipe;
        public boolean produce;

        public PayloadCrafterBuild() {
            super((PayloadBlock)PayloadCrafter.this);
        }

        @Nullable
        public Recipe recipe() {
            return (Recipe)PayloadCrafter.this.recipes.find(r -> r.outputBlock == this.recipe);
        }

        public boolean hasRecipe() {
            return this.recipe() != null;
        }

        public Object senseObject(LAccess sensor) {
            if (sensor == LAccess.config) {
                return this.recipe;
            }
            if (sensor == LAccess.progress) {
                return Float.valueOf(this.progress);
            }
            return super.senseObject(sensor);
        }

        public void updateTile() {
            super.updateTile();
            Recipe recipe = this.recipe();
            boolean bl = recipe != null && this.canConsume() && (recipe.inputBlock != null ? this.payload != null && this.hasArrived() && ((BuildPayload)this.payload).block() == recipe.inputBlock : this.payload == null) ? true : (this.produce = false);
            if (this.payload != null) {
                if (recipe != null) {
                    if (((BuildPayload)this.payload).block() != recipe.inputBlock) {
                        this.moveOutPayload();
                    }
                } else if (!PayloadCrafter.this.recipes.contains(r -> r.inputBlock == ((BuildPayload)this.payload).block())) {
                    this.moveOutPayload();
                }
            }
            if (recipe != null && this.payload != null && ((BuildPayload)this.payload).block() == recipe.inputBlock) {
                this.moveInPayload(false);
            }
            if (this.produce && recipe != null) {
                this.progress += this.edelta();
                if (this.progress >= recipe.craftTime) {
                    this.craft(recipe);
                }
            } else if (recipe == null || !this.canConsume()) {
                this.progress = 0.0f;
            }
            this.heat = Mathf.lerpDelta((float)this.heat, (float)Mathf.num((boolean)this.produce), (float)0.15f);
            this.time += this.heat * this.delta();
        }

        public void craft(Recipe recipe) {
            this.consume();
            this.payload = new BuildPayload(recipe.outputBlock, this.team);
            this.payVector.setZero();
            this.progress %= 1.0f;
        }

        public float powerUse() {
            return this.hasRecipe() ? this.recipe().powerUse : 0.0f;
        }

        public void draw() {
            Draw.rect((TextureRegion)PayloadCrafter.this.region, (float)this.x, (float)this.y);
            if (this.curInput()) {
                for (int i = 0; i < 4; ++i) {
                    if (!this.blends(i) || i == this.rotation) continue;
                    Draw.rect((TextureRegion)PayloadCrafter.this.inRegion, (float)this.x, (float)this.y, (float)((float)i * 90.0f - 180.0f));
                }
            }
            Draw.rect((TextureRegion)PayloadCrafter.this.outRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            if (this.recipe != null) {
                Recipe r = this.recipe();
                Draw.draw((float)40.0f, () -> {
                    if (r.blockBuild) {
                        for (TextureRegion region : this.recipe.getGeneratedIcons()) {
                            if (r.centerBuild) {
                                PMDrawf.blockBuildCenter(this.x, this.y, region, this.recipe.rotate ? this.rotdeg() : 0.0f, this.progress / r.craftTime);
                                continue;
                            }
                            PMDrawf.blockBuild(this.x, this.y, region, this.recipe.rotate ? this.rotdeg() : 0.0f, this.progress / r.craftTime);
                        }
                    } else {
                        Drawf.construct((Building)this, (TextureRegion)this.recipe.fullIcon, (float)0.0f, (float)(this.progress / r.craftTime), (float)this.heat, (float)this.time);
                    }
                });
                if (r.blockBuild) {
                    Draw.z((float)40.01f);
                    Draw.color((Color)Pal.accent, (float)this.heat);
                    Lines.lineAngleCenter((float)(this.x + Mathf.sin((float)this.time, (float)10.0f, (float)(4.0f * (float)this.recipe.size + 1.0f))), (float)this.y, (float)90.0f, (float)((float)(this.recipe.size * 8) + 1.0f));
                    Draw.reset();
                }
            }
            Draw.z((float)41.0f);
            Draw.rect((TextureRegion)PayloadCrafter.this.topRegion, (float)this.x, (float)this.y);
            this.drawPayload();
        }

        public boolean curInput() {
            return this.hasRecipe() && this.recipe().inputBlock != null;
        }

        public boolean acceptItem(Building source, Item item) {
            return this.items != null && this.items.get(item) < this.getMaximumAccepted(item);
        }

        public int getMaximumAccepted(Item item) {
            if (this.recipe() == null) {
                return 0;
            }
            for (ItemStack stack : this.recipe().itemRequirements) {
                if (stack.item != item) continue;
                return stack.amount * 2;
            }
            return 0;
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return this.liquids != null && this.hasRecipe() && this.recipe().hasLiquidInput(liquid);
        }

        public void buildConfiguration(Table table) {
            ButtonGroup group = new ButtonGroup();
            group.setMinCheckCount(0);
            Table cont = new Table();
            cont.defaults().size(40.0f);
            int i = 0;
            for (Block b : Vars.content.blocks()) {
                if (!PayloadCrafter.this.recipes.contains(r -> r.outputBlock == b)) continue;
                Cell cell = cont.button(Tex.clear, Styles.clearTogglei, 24.0f, () -> {}).group(group);
                ImageButton button = (ImageButton)cell.get();
                Recipe r2 = (Recipe)PayloadCrafter.this.recipes.find(rec -> rec.outputBlock == b);
                button.update(() -> button.setChecked(this.recipe == b));
                if (r2.unlocked()) {
                    button.getStyle().imageUp = new TextureRegionDrawable(b.uiIcon);
                    cell.tooltip(b.localizedName);
                } else {
                    button.getStyle().imageUp = Icon.lock;
                    cell.tooltip("@pm-missing-research");
                }
                button.changed(() -> this.configure(button.isChecked() ? b : null));
                if (i++ % 4 != 3) continue;
                cont.row();
            }
            if (i % 4 != 0) {
                int remaining = 4 - i % 4;
                for (int j = 0; j < remaining; ++j) {
                    cont.image(Styles.black6);
                }
            }
            ScrollPane pane = new ScrollPane((Element)cont, Styles.smallPane);
            pane.setScrollingDisabled(true, false);
            pane.setScrollYForce(PayloadCrafter.this.scrollPos);
            pane.update(() -> PayloadCrafter.this.scrollPos = pane.getScrollY());
            pane.setOverscroll(false, false);
            table.add((Element)pane).maxHeight(Scl.scl((float)200.0f));
        }

        public Object config() {
            return this.recipe;
        }

        public boolean acceptPayload(Building source, Payload payload) {
            BuildPayload p;
            Recipe r = this.recipe();
            return this.payload == null && r != null && payload instanceof BuildPayload && (p = (BuildPayload)payload).block() == r.inputBlock;
        }

        public void display(Table table) {
            super.display(table);
            Image prev = new Image();
            TextureRegionDrawable prevReg = new TextureRegionDrawable();
            table.row();
            table.table(p -> p.update(() -> {
                p.clear();
                if (this.hasRecipe() && this.recipe().hasInputBlock()) {
                    p.label(() -> Core.bundle.get("pm-requires")).color(Color.lightGray).padRight(2.0f);
                    prev.setDrawable((Drawable)prevReg.set(this.recipe().inputBlock.uiIcon));
                    ReqImage r = new ReqImage((Element)prev, () -> this.payload != null && this.hasArrived() && ((BuildPayload)this.payload).block() == this.recipe().inputBlock);
                    r.setSize(32.0f);
                    p.add((Element)r).size(32.0f).padBottom(-4.0f).padRight(2.0f);
                    p.label(() -> this.recipe().inputBlock.localizedName).color(Color.lightGray);
                }
            })).left();
            TextureRegionDrawable reg = new TextureRegionDrawable();
            table.row();
            ((Table)table.table(t -> {
                t.left();
                t.image().update(i -> {
                    i.setDrawable((Drawable)(this.recipe == null ? Icon.cancel : reg.set(this.recipe.uiIcon)));
                    i.setScaling(Scaling.fit);
                    i.setColor(this.recipe == null ? Color.lightGray : Color.white);
                }).size(32.0f).padBottom(-4.0f).padRight(2.0f);
            }).left().get()).label(() -> this.recipe == null ? "@none" : this.recipe.localizedName).color(Color.lightGray);
        }

        public boolean shouldAmbientSound() {
            return super.shouldAmbientSound() && this.produce;
        }

        public void write(Writes write) {
            super.write(write);
            write.s(this.recipe == null ? -1 : (int)this.recipe.id);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.recipe = Vars.content.block((int)read.s());
            }
        }

        public byte version() {
            return 1;
        }
    }
}

