/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.payloads;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BuildVisibility;
import progressed.graphics.Outliner;
import progressed.util.PMMathf;
import progressed.world.meta.PMStat;
import progressed.world.meta.PMStatValues;

public class Missile
extends Block {
    public BulletType explosionBullet;
    public int explosions = 1;
    public float explosionArea = 0.0f;
    public float maxDelay;
    public Block prev;
    public float powerUse;
    public float constructTime = -1.0f;
    public boolean displayCampaign = true;
    public float elevation = -1.0f;
    public boolean outlined;
    public Block user;
    public BulletType bullet;
    public TextureRegion topRegion;
    public TextureRegion outlineRegion;

    public Missile(String name) {
        super(name);
        this.buildVisibility = BuildVisibility.sandboxOnly;
        this.category = Category.units;
        this.health = 50;
        this.researchCostMultiplier = 5.0f;
        this.solid = true;
        this.update = true;
        this.hasShadow = false;
        this.rebuildable = false;
        this.drawDisabled = false;
        this.squareSprite = false;
    }

    public void init() {
        if (this.constructTime < 0.0f) {
            this.constructTime = this.buildTime;
        }
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 3.0f;
        }
        if (this.explosionArea < 0.0f) {
            this.explosionArea = this.size * 8;
        }
        super.init();
    }

    public void load() {
        super.load();
        this.outlineRegion = Core.atlas.find(this.name + "-outline");
        this.topRegion = Core.atlas.find(this.name + "-top", this.region);
    }

    public void setStats() {
        super.setStats();
        if (this.user != null && this.bullet != null) {
            this.stats.add(PMStat.used, PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{this.user, this.bullet})));
        }
    }

    public void buildCost(Object ... items) {
        this.requirements = ItemStack.with((Object[])items);
        Arrays.sort(this.requirements, Structs.comparingInt(i -> i.item.id));
    }

    public void createIcons(MultiPacker packer) {
        if (this.outlined) {
            Outliner.outlineRegion(packer, this.region, this.outlineColor, this.name + "-outline");
            this.outlineRegion = Core.atlas.find(this.name + "-outline");
        }
        super.createIcons(packer);
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{this.outlined ? this.outlineRegion : this.region, this.topRegion};
    }

    public boolean canBeBuilt() {
        return false;
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor() || Vars.state.rules.infiniteResources;
    }

    public class MissileBuild
    extends Building {
        boolean exploded = false;

        public void draw() {
            TextureRegion reg = Missile.this.outlined ? Missile.this.outlineRegion : Missile.this.region;
            Draw.z((float)28.5f);
            Drawf.shadow((TextureRegion)reg, (float)(this.x - Missile.this.elevation), (float)(this.y - Missile.this.elevation));
            Draw.z((float)30.0f);
            Draw.rect((TextureRegion)reg, (float)this.x, (float)this.y);
        }

        public void drawCracks() {
            if (Missile.this.explosionBullet != null) {
                float f = Mathf.clamp((float)this.healthf());
                Tmp.c1.set(Color.red).lerp(Color.white, f + Mathf.absin((float)Time.time, (float)Math.max(f * 5.0f, 1.0f), (float)(1.0f - f)));
                Draw.color((Color)Tmp.c1);
                Draw.rect((TextureRegion)Missile.this.topRegion, (float)this.x, (float)this.y);
            }
        }

        public void afterDestroyed() {
            if (this.exploded) {
                return;
            }
            super.afterDestroyed();
            this.explode();
            this.exploded = true;
        }

        public void explode() {
            if (Missile.this.explosionBullet != null) {
                for (int i = 0; i < Missile.this.explosions; ++i) {
                    Time.run((float)Mathf.random((float)Missile.this.maxDelay), () -> {
                        PMMathf.randomCirclePoint(Tmp.v1, Missile.this.explosionArea);
                        if (Missile.this.explosionBullet.spawnUnit != null) {
                            Unit spawned = Missile.this.explosionBullet.spawnUnit.create(Team.derelict);
                            spawned.set(this.x + Tmp.v1.x, this.y + Tmp.v1.y);
                            spawned.add();
                            spawned.kill();
                            return;
                        }
                        Bullet b = Missile.this.explosionBullet.create((Entityc)this, Team.derelict, this.x + Tmp.v1.x, this.y + Tmp.v1.y, 0.0f, 0.0f, 0.0f);
                        b.remove();
                    });
                }
            }
        }
    }
}

