/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.testing;

import arc.struct.ObjectMap;
import mindustry.content.Bullets;
import mindustry.entities.bullet.BulletType;
import mindustry.logic.LAccess;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.Stat;
import progressed.content.blocks.PMBlocks;
import progressed.world.meta.PMStatValues;

public class FreeTurret
extends Turret {
    public BulletType shootType = Bullets.placeholder;

    public FreeTurret(String name) {
        super(name);
        this.requirements(Category.turret, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
        this.size = 2;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public void limitRange(float margin) {
        this.limitRange(this.shootType, margin);
    }

    public class FreeTurretBuild
    extends Turret.TurretBuild {
        public FreeTurretBuild() {
            super((Turret)FreeTurret.this);
        }

        public void updateTile() {
            super.updateTile();
            this.unit.ammo(1.0f);
        }

        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case ammo: 
                case ammoCapacity: {
                    d = 1.0;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        public BulletType useAmmo() {
            return FreeTurret.this.shootType;
        }

        public boolean hasAmmo() {
            return true;
        }

        public BulletType peekAmmo() {
            return FreeTurret.this.shootType;
        }
    }
}

