/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.testing;

import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.Entityc;
import progressed.entities.bullet.pseudo3d.ArcBoltBulletType;
import progressed.entities.bullet.pseudo3d.ArcBulletType;
import progressed.graphics.draw3d.Draw3D;
import progressed.util.Math3D;
import progressed.world.blocks.defence.turret.testing.FreeTurret;

public class ArcBulletTestTurret
extends FreeTurret {
    public float shotZ = 1440.0f;
    public float shotTilt = 45.0f;
    public boolean drawAimDebug = false;
    public boolean swing = false;
    public float swingScl = 2.0f;

    public ArcBulletTestTurret(String name) {
        super(name);
        this.shootType = new ArcBoltBulletType(25.0f, 400.0f){
            {
                this.homingPower = 3.0f;
                this.homingRange = 160.0f;
            }
        };
        this.reload = 10.0f;
        this.range = 360.0f;
        this.shootY = 0.0f;
        this.shootCone = 360.0f;
        this.inaccuracy = 30.0f;
        this.velocityRnd = 0.3f;
        this.shoot = new ShootSpread(5, 0.0f);
    }

    public class ArcBulletTestTurretBuild
    extends FreeTurret.FreeTurretBuild {
        public float realTilt;

        public ArcBulletTestTurretBuild() {
            super(ArcBulletTestTurret.this);
            this.realTilt = ArcBulletTestTurret.this.shotTilt;
        }

        @Override
        public void updateTile() {
            this.realTilt = ArcBulletTestTurret.this.swing ? Time.time * ArcBulletTestTurret.this.swingScl : ArcBulletTestTurret.this.shotTilt;
            super.updateTile();
        }

        public void draw() {
            super.draw();
            this.drawAimDebug();
        }

        public void drawAimDebug() {
            if (!ArcBulletTestTurret.this.drawAimDebug) {
                return;
            }
            Draw.z((float)147.0f);
            Draw3D.drawAimDebug(this.x, this.y, ArcBulletTestTurret.this.shotZ, ArcBulletTestTurret.this.shootType.speed * 8.0f, this.rotation, this.realTilt, ArcBulletTestTurret.this.inaccuracy);
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            --this.queuedBullets;
            if (this.dead || !ArcBulletTestTurret.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            float xSpread = Mathf.range((float)ArcBulletTestTurret.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(ArcBulletTestTurret.this.shootX + xOffset + xSpread), (float)(ArcBulletTestTurret.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(ArcBulletTestTurret.this.shootX + xOffset + xSpread), (float)(ArcBulletTestTurret.this.shootY + yOffset));
            float shootAngle = this.rotation + angleOffset;
            float velScl = 1.0f + Mathf.range((float)(ArcBulletTestTurret.this.velocityRnd / 2.0f));
            ArcBulletType aType = (ArcBulletType)type;
            Vec2 inacc = Math3D.inaccuracy(ArcBulletTestTurret.this.inaccuracy);
            this.handleBullet(aType.create3D((Entityc)this, this.team, this.x, this.y, ArcBulletTestTurret.this.shotZ, shootAngle + inacc.x, ArcBulletTestTurret.this.shotTilt + inacc.y, aType.gravity, velScl, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
            (ArcBulletTestTurret.this.shootEffect == null ? type.shootEffect : ArcBulletTestTurret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (ArcBulletTestTurret.this.smokeEffect == null ? type.smokeEffect : ArcBulletTestTurret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            ArcBulletTestTurret.this.shootSound.at(bulletX, bulletY, Mathf.random((float)ArcBulletTestTurret.this.soundPitchMin, (float)ArcBulletTestTurret.this.soundPitchMax));
            ArcBulletTestTurret.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)ArcBulletTestTurret.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)ArcBulletTestTurret.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (ArcBulletTestTurret.this.shake > 0.0f) {
                Effect.shake((float)ArcBulletTestTurret.this.shake, (float)ArcBulletTestTurret.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            if (ArcBulletTestTurret.this.recoils > 0) {
                this.curRecoils[this.barrelCounter % ArcBulletTestTurret.this.recoils] = 1.0f;
            }
            this.heat = 1.0f;
            ++this.totalShots;
            if (!ArcBulletTestTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }
    }
}

