/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular.modules;

import arc.audio.Sound;
import arc.func.Func;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.types.MissileAI;
import mindustry.content.StatusEffects;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.content.blocks.PMModules;
import progressed.graphics.PMDrawf;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.module.ModuleModule;

public class TractorConeModule
extends BaseTurret {
    public final int timerTarget;
    public float retargetTime;
    public float tractorCone;
    public float shootLength;
    public float force;
    public float scaledForce;
    public boolean ignoreMass;
    public float damage;
    public boolean targetAir;
    public boolean targetGround;
    public float tractorScl;
    public float tractorSpacing;
    public float tractorStroke;
    public Color tractorColor;
    public StatusEffect status;
    public float statusDuration;
    public Sound shootSound;
    public float shootSoundVolume;
    public ModuleModule.ModuleSize moduleSize;
    OrderedMap<String, Func<Building, Bar>> moduleBarMap;

    public TractorConeModule(String name) {
        super(name);
        this.timerTarget = this.timers++;
        this.retargetTime = 5.0f;
        this.tractorCone = 10.0f;
        this.shootLength = Float.NEGATIVE_INFINITY;
        this.force = 0.3f;
        this.scaledForce = 0.0f;
        this.ignoreMass = false;
        this.damage = 0.0f;
        this.targetAir = true;
        this.targetGround = false;
        this.tractorScl = 1.0f;
        this.tractorSpacing = 40.0f;
        this.tractorStroke = 2.0f;
        this.tractorColor = Pal.lancerLaser.cpy();
        this.status = StatusEffects.none;
        this.statusDuration = 300.0f;
        this.shootSound = Sounds.tractorbeam;
        this.shootSoundVolume = 0.9f;
        this.moduleSize = ModuleModule.ModuleSize.small;
        this.moduleBarMap = new OrderedMap();
        this.coolantMultiplier = 1.0f;
        this.update = false;
        this.destructible = true;
        this.rebuildable = false;
        this.breakable = false;
        this.group = BlockGroup.turrets;
        this.connectedPower = false;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.targetsAir, this.targetAir);
        this.stats.add(Stat.targetsGround, this.targetGround);
        if (this.damage > 0.0f) {
            this.stats.add(Stat.damage, this.damage * 60.0f, StatUnit.perSecond);
        }
    }

    public void init() {
        if (this.shootLength == Float.NEGATIVE_INFINITY) {
            this.shootLength = (float)(this.size * 8) / 2.0f;
        }
        this.updateClipRadius(this.range + this.shootLength + 8.0f);
        PMModules.setClip(this.clipSize);
        this.fogRadius = -1;
        super.init();
    }

    public void setBars() {
        super.setBars();
        this.moduleBarMap.putAll((ObjectMap)this.barMap);
        this.moduleBarMap.remove((Object)"health");
        this.removeBar("power");
        this.removeBar("heat");
    }

    public <T extends Building> void addModuleBar(String name, Func<T, Bar> sup) {
        this.moduleBarMap.put((Object)name, sup);
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor() || Vars.state.rules.infiniteResources;
    }

    public class TractorConeModuleBuild
    extends BaseTurret.BaseTurretBuild
    implements TurretModule {
        public ModuleModule module;
        public Unit target;
        public float strength;
        public float totalProgress;
        public boolean any;

        public TractorConeModuleBuild() {
            super((BaseTurret)TractorConeModule.this);
        }

        public Building create(Block block, Team team) {
            super.create(block, team);
            this.module = new ModuleModule((TurretModule)this.self(), TractorConeModule.this.hasPower);
            return (Building)this.self();
        }

        public void updateTile() {
            if (!this.isDeployed()) {
                return;
            }
            float eff = this.efficiency * TractorConeModule.this.coolantMultiplier;
            float edelta = eff * this.delta();
            if (this.timer(TractorConeModule.this.timerTarget, TractorConeModule.this.retargetTime)) {
                this.target = Units.closestEnemy((Team)this.team, (float)this.x, (float)this.y, (float)TractorConeModule.this.range, u -> u.checkTarget(TractorConeModule.this.targetAir, TractorConeModule.this.targetGround) && !(u.controller() instanceof MissileAI));
            }
            if (this.target != null && TractorConeModule.this.coolant != null) {
                float maxUsed = TractorConeModule.this.coolant.amount;
                Liquid liquid = this.liquids.current();
                float used = Math.min(Math.min(this.liquids.get(liquid), maxUsed * Time.delta), Math.max(0.0f, 1.0f / TractorConeModule.this.coolantMultiplier / liquid.heatCapacity));
                this.liquids.remove(liquid, used);
                if (Mathf.chance((double)(0.06 * (double)used))) {
                    TractorConeModule.this.coolEffect.at(this.x + Mathf.range((float)((float)(TractorConeModule.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(TractorConeModule.this.size * 8) / 2.0f)));
                }
                TractorConeModule.this.coolantMultiplier = 1.0f + used * liquid.heatCapacity * TractorConeModule.this.coolantMultiplier;
            }
            this.any = false;
            if (this.target != null && this.target.within((Position)this, TractorConeModule.this.range + this.target.hitSize / 2.0f) && this.target.team() != this.team && this.target.checkTarget(TractorConeModule.this.targetAir, TractorConeModule.this.targetGround) && this.efficiency > 0.02f) {
                if (!Vars.headless) {
                    Vars.control.sound.loop(TractorConeModule.this.shootSound, (Position)this, TractorConeModule.this.shootSoundVolume);
                }
                float dest = this.angleTo((Position)this.target);
                this.rotation = Angles.moveToward((float)this.rotation, (float)dest, (float)(TractorConeModule.this.rotateSpeed * edelta));
                this.strength = Mathf.lerpDelta((float)this.strength, (float)1.0f, (float)0.1f);
                Units.nearbyEnemies((Team)this.team, (float)this.x, (float)this.y, (float)TractorConeModule.this.range, u -> {
                    if (!(u.controller() instanceof MissileAI) && u.checkTarget(TractorConeModule.this.targetAir, TractorConeModule.this.targetGround) && Angles.within((float)this.rotation, (float)this.angleTo((Position)u), (float)TractorConeModule.this.tractorCone)) {
                        if (TractorConeModule.this.damage > 0.0f) {
                            u.damageContinuous(TractorConeModule.this.damage * eff);
                        }
                        if (TractorConeModule.this.status != StatusEffects.none) {
                            u.apply(TractorConeModule.this.status, TractorConeModule.this.statusDuration);
                        }
                        this.any = true;
                        if (TractorConeModule.this.ignoreMass) {
                            Tmp.v1.set((Position)this).sub((Position)u).limit((TractorConeModule.this.force + (1.0f - u.dst((Position)this) / TractorConeModule.this.range) * TractorConeModule.this.scaledForce) * edelta);
                            u.vel.add(Tmp.v1);
                            if (u.isRemote()) {
                                u.move(Tmp.v1);
                            }
                        } else {
                            u.impulseNet(Tmp.v1.set((Position)this).sub((Position)u).limit((TractorConeModule.this.force + (1.0f - u.dst((Position)this) / TractorConeModule.this.range) * TractorConeModule.this.scaledForce) * edelta));
                        }
                    }
                });
            } else {
                this.strength = Mathf.lerpDelta((float)this.strength, (float)0.0f, (float)0.1f);
            }
            this.totalProgress += this.strength * edelta;
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && this.target != null;
        }

        public float estimateDps() {
            if (!this.any || TractorConeModule.this.damage <= 0.0f) {
                return 0.0f;
            }
            return TractorConeModule.this.damage * 60.0f * this.efficiency * TractorConeModule.this.coolantMultiplier;
        }

        public void draw() {
            Drawf.shadow((TextureRegion)TractorConeModule.this.region, (float)(this.x - (float)TractorConeModule.this.size / 2.0f), (float)(this.y - (float)TractorConeModule.this.size / 2.0f), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)TractorConeModule.this.region, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
            if (this.strength > 0.001f) {
                Draw.z((float)99.0f);
                float cx = this.x + Angles.trnsx((float)this.rotation, (float)TractorConeModule.this.shootLength);
                float cy = this.y + Angles.trnsy((float)this.rotation, (float)TractorConeModule.this.shootLength);
                PMDrawf.tractorCone(cx, cy, this.totalProgress * TractorConeModule.this.tractorScl, TractorConeModule.this.tractorSpacing, TractorConeModule.this.tractorStroke, () -> {
                    Draw.color((Color)Tmp.c1.set(TractorConeModule.this.tractorColor).mulA(this.strength));
                    PMDrawf.arcFill(cx, cy, TractorConeModule.this.range, TractorConeModule.this.tractorCone / 360.0f, this.rotation - TractorConeModule.this.tractorCone / 2.0f);
                });
            }
        }

        public void drawSelect() {
            if (!this.isModule()) {
                return;
            }
            super.drawSelect();
        }

        @Override
        public ModuleModule module() {
            return this.module;
        }

        @Override
        public ModuleModule.ModuleSize size() {
            return TractorConeModule.this.moduleSize;
        }

        @Override
        public Building build() {
            return (Building)this.self();
        }

        @Override
        public Iterable<Func<Building, Bar>> listModuleBars() {
            return TractorConeModule.this.moduleBarMap.values();
        }

        public void pickedUp() {
            this.module.progress = 0.0f;
            this.rotation = 90.0f;
            this.any = false;
            this.strength = 0.0f;
        }

        @Override
        public boolean isActive() {
            return TurretModule.super.isActive() && this.strength > 0.001f;
        }

        public boolean isValid() {
            return super.isValid() || this.parent() != null && this.parent().isValid();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return super.acceptLiquid(source, liquid) && (this.liquids.current() == null || this.liquids.currentAmount() < TractorConeModule.this.liquidCapacity);
        }

        public void write(Writes write) {
            super.write(write);
            this.module.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            (this.module == null ? new ModuleModule((TurretModule)this.self(), TractorConeModule.this.hasPower) : this.module).read(read);
        }
    }
}

