/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular.modules;

import arc.Core;
import arc.func.Func;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.content.blocks.PMModules;
import progressed.content.effects.ModuleFx;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.module.ModuleModule;

public class BoostModule
extends Block {
    public ModuleModule.ModuleSize moduleSize = ModuleModule.ModuleSize.small;
    public float healPercent = 0.016666668f;
    public float speedBoost = 1.25f;
    public float regenEffectChance = 0.003f;
    public float overdriveEffectChance = 0.001f;
    public Effect regenEffect = Fx.regenParticle;
    public Effect overdriveEffect = ModuleFx.overdriveParticle;
    OrderedMap<String, Func<Building, Bar>> moduleBarMap = new OrderedMap();
    protected TextureRegion mendTop;
    protected TextureRegion overdriveTop;

    public BoostModule(String name) {
        super(name);
        this.solid = true;
        this.destructible = true;
        this.rebuildable = false;
        this.breakable = false;
        this.group = BlockGroup.turrets;
        this.connectedPower = false;
        this.outlineIcon = true;
        this.suppressable = true;
        this.canOverdrive = false;
    }

    public void init() {
        super.init();
        PMModules.setClip(this.clipSize);
    }

    public void load() {
        super.load();
        this.mendTop = Core.atlas.find(this.name + "-mend");
        this.overdriveTop = Core.atlas.find(this.name + "-overdrive");
    }

    public void setStats() {
        super.setStats();
        if (this.healPercent > 0.0f) {
            this.stats.add(Stat.repairTime, (float)((int)(1.0f / (this.healPercent / 100.0f) / 60.0f)), StatUnit.seconds);
        }
        if (this.speedBoost > 0.0f) {
            this.stats.add(Stat.speedIncrease, "+" + (int)(this.speedBoost * 100.0f - 100.0f) + "%", new Object[0]);
        }
    }

    public void setBars() {
        super.setBars();
        this.moduleBarMap.putAll((ObjectMap)this.barMap);
        this.moduleBarMap.remove((Object)"health");
        this.removeBar("power");
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor() || Vars.state.rules.infiniteResources;
    }

    public class BoostModuleBuild
    extends Building
    implements TurretModule {
        public ModuleModule module;
        public float mendHeat;
        public float overdriveHeat;

        public Building create(Block block, Team team) {
            super.create(block, team);
            this.module = new ModuleModule((TurretModule)this.self(), BoostModule.this.hasPower);
            return (Building)this.self();
        }

        public void updateTile() {
            if (!this.isDeployed()) {
                return;
            }
            if (this.efficiency > 0.0f) {
                if (BoostModule.this.healPercent > 0.0f) {
                    boolean canHeal = !this.checkSuppression() && this.parent().damaged();
                    this.mendHeat = Mathf.lerpDelta((float)this.mendHeat, (float)(this.efficiency > 0.0f && canHeal ? 1.0f : 0.0f), (float)0.08f);
                    if (canHeal) {
                        this.parent().healFract(BoostModule.this.healPercent * this.edelta());
                        this.parent().recentlyHealed();
                        if (Mathf.chanceDelta((double)(BoostModule.this.regenEffectChance * (float)this.parent().block.size * (float)this.parent().block.size))) {
                            this.parentEffect(BoostModule.this.regenEffect);
                        }
                    }
                }
                if (BoostModule.this.speedBoost > 0.0f) {
                    boolean canOverdrive = this.parent().modules.contains(m -> m.block().canOverdrive && !(m instanceof BoostModuleBuild) && m.isActive());
                    this.overdriveHeat = Mathf.lerpDelta((float)this.overdriveHeat, (float)(this.efficiency > 0.0f && canOverdrive ? 1.0f : 0.0f), (float)0.08f);
                    if (canOverdrive) {
                        this.parent().applyBoost(1.0f + BoostModule.this.speedBoost * this.efficiency, 2.0f * Time.delta);
                        if (Mathf.chanceDelta((double)(BoostModule.this.overdriveEffectChance * (float)this.parent().block.size * (float)this.parent().block.size))) {
                            this.parentEffect(BoostModule.this.overdriveEffect);
                        }
                    }
                }
            }
        }

        @Override
        public void moduleDraw() {
            TurretModule.super.moduleDraw();
            if (this.isDeployed()) {
                Draw.alpha((float)(this.mendHeat * Mathf.absin((float)Time.time, (float)7.957747f, (float)1.0f) * 0.5f));
                Draw.rect((TextureRegion)BoostModule.this.mendTop, (float)this.x, (float)this.y);
                Draw.alpha((float)(this.overdriveHeat * Mathf.absin((float)Time.time, (float)7.957747f, (float)1.0f) * 0.5f));
                Draw.rect((TextureRegion)BoostModule.this.overdriveTop, (float)this.x, (float)this.y);
            }
        }

        public void parentEffect(Effect effect) {
            effect.at(this.parent().x + Mathf.range((float)((float)(this.parent().block.size * 8) / 2.0f - 1.0f)), this.parent().y + Mathf.range((float)((float)(this.parent().block.size * 8) / 2.0f - 1.0f)));
        }

        @Override
        public boolean acceptModule(TurretModule module) {
            return !(module instanceof BoostModuleBuild);
        }

        public void pickedUp() {
            this.module.progress = 0.0f;
            this.overdriveHeat = 0.0f;
            this.mendHeat = 0.0f;
        }

        @Override
        public ModuleModule module() {
            return this.module;
        }

        @Override
        public Building build() {
            return (Building)this.self();
        }

        @Override
        public ModuleModule.ModuleSize size() {
            return BoostModule.this.moduleSize;
        }

        @Override
        public boolean isActive() {
            return TurretModule.super.isActive() && (this.mendHeat > 0.01f || this.overdriveHeat > 0.01f);
        }

        @Override
        public Iterable<Func<Building, Bar>> listModuleBars() {
            return BoostModule.this.moduleBarMap.values();
        }

        public boolean isValid() {
            return super.isValid() || this.parent() != null && this.parent().isValid();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return super.acceptLiquid(source, liquid) && (this.liquids.current() == null || this.liquids.currentAmount() < BoostModule.this.liquidCapacity);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.mendHeat);
            write.f(this.overdriveHeat);
            this.module.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.mendHeat = read.f();
            this.overdriveHeat = read.f();
            (this.module == null ? new ModuleModule((TurretModule)this.self(), BoostModule.this.hasPower) : this.module).read(read);
        }
    }
}

