/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular.modules;

import arc.func.Func;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.ContinuousLiquidTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import progressed.content.blocks.PMModules;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.draw.DrawTurretModule;
import progressed.world.meta.PMStatValues;
import progressed.world.module.ModuleModule;

public class BeamModule
extends ContinuousLiquidTurret {
    public ModuleModule.ModuleSize moduleSize = ModuleModule.ModuleSize.small;
    OrderedMap<String, Func<Building, Bar>> moduleBarMap = new OrderedMap();

    public BeamModule(String name) {
        super(name);
        this.update = false;
        this.destructible = true;
        this.rebuildable = false;
        this.breakable = false;
        this.group = BlockGroup.turrets;
        this.connectedPower = false;
        this.shootCone = 1.0f;
        this.drawer = new DrawTurretModule();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        this.drawOverlay((float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation);
    }

    public void init() {
        super.init();
        PMModules.setClip(this.clipSize);
        this.fogRadius = -1;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public void setBars() {
        super.setBars();
        this.moduleBarMap.putAll((ObjectMap)this.barMap);
        this.moduleBarMap.remove((Object)"health");
        this.removeBar("power");
        this.removeBar("heat");
    }

    public <T extends Building> void addModuleBar(String name, Func<T, Bar> sup) {
        this.moduleBarMap.put((Object)name, sup);
    }

    public boolean canBreak(Tile tile) {
        return Vars.state.isEditor() || Vars.state.rules.infiniteResources;
    }

    public class BeamModuleBuild
    extends ContinuousLiquidTurret.ContinuousLiquidTurretBuild
    implements TurretModule {
        public ModuleModule module;

        public BeamModuleBuild() {
            super((ContinuousLiquidTurret)BeamModule.this);
        }

        public Building create(Block block, Team team) {
            super.create(block, team);
            this.module = new ModuleModule((TurretModule)this.self(), BeamModule.this.hasPower);
            return (Building)this.self();
        }

        public Unit unit() {
            if (this.parent() != null && this.canControl()) {
                this.unit = (BlockUnitc)this.parent().unit();
                return (Unit)this.unit;
            }
            return super.unit();
        }

        public boolean canControl() {
            return super.canControl() && this.isDeployed();
        }

        public void updateTile() {
            if (!this.isDeployed()) {
                return;
            }
            super.updateTile();
        }

        public void drawSelect() {
            if (!this.isModule()) {
                return;
            }
            super.drawSelect();
        }

        public boolean isShooting() {
            return this.isControlled() ? this.unit.isShooting() : (this.logicControlled() ? this.logicShooting : this.target != null && this.wasShooting);
        }

        protected void updateCooling() {
            if (!this.bullets.any()) {
                super.updateCooling();
            }
        }

        protected void updateReload() {
            if (!this.bullets.any()) {
                super.updateReload();
            }
        }

        protected void updateShooting() {
            if (!this.bullets.any()) {
                super.updateShooting();
            }
        }

        protected void updateBullet(Turret.BulletEntry entry) {
            float resultLength;
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(BeamModule.this.shootX + entry.x), (float)(BeamModule.this.shootY + entry.y));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(BeamModule.this.shootX + entry.x), (float)(BeamModule.this.shootY + entry.y));
            float angle = this.rotation + entry.rotation;
            entry.bullet.rotation(angle);
            entry.bullet.set(bulletX, bulletY);
            float shootLength = Math.min(this.dst((Position)this.targetPos), BeamModule.this.range);
            float curLength = this.dst(entry.bullet.aimX, entry.bullet.aimY);
            this.lastLength = resultLength = Mathf.approachDelta((float)curLength, (float)shootLength, (float)BeamModule.this.aimChangeSpeed);
            Tmp.v1.trns(this.rotation, this.lastLength).add(this.x, this.y);
            entry.bullet.aimX = Tmp.v1.x;
            entry.bullet.aimY = Tmp.v1.y;
            if (this.isShooting() && this.hasAmmo()) {
                entry.bullet.time = Mathf.approachDelta((float)entry.bullet.time, (float)(entry.bullet.lifetime * entry.bullet.type.optimalLifeFract), (float)1.0f);
                entry.bullet.keepAlive = true;
            }
        }

        protected void turnToTarget(float targetRot) {
            if (this.bullets.any()) {
                return;
            }
            this.rotation = Angles.moveToward((float)this.rotation, (float)targetRot, (float)(BeamModule.this.rotateSpeed * this.delta() * (float)Mathf.num((boolean)this.hasAmmo())));
        }

        @Override
        public void moduleRemoved() {
            TurretModule.super.moduleRemoved();
            this.unit = (BlockUnitc)UnitTypes.block.create(this.team);
        }

        @Override
        public ModuleModule module() {
            return this.module;
        }

        @Override
        public ModuleModule.ModuleSize size() {
            return BeamModule.this.moduleSize;
        }

        @Override
        public Building build() {
            return (Building)this.self();
        }

        @Override
        public Iterable<Func<Building, Bar>> listModuleBars() {
            return BeamModule.this.moduleBarMap.values();
        }

        public void pickedUp() {
            this.module.progress = 0.0f;
            this.rotation = 90.0f;
        }

        public boolean isValid() {
            return super.isValid() || this.parent() != null && this.parent().isValid();
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return super.acceptLiquid(source, liquid) && (this.liquids.current() == null || this.liquids.currentAmount() < BeamModule.this.liquidCapacity);
        }

        public void write(Writes write) {
            super.write(write);
            this.module.write(write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            (this.module == null ? new ModuleModule((TurretModule)this.self(), BeamModule.this.hasPower) : this.module).read(read);
        }
    }
}

