/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload.modular;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.UnitTypes;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Teamc;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ControlBlock;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import progressed.ProgMats;
import progressed.world.blocks.defence.turret.payload.modular.TurretModule;
import progressed.world.meta.PMStat;
import progressed.world.meta.PMStatValues;
import progressed.world.module.ModuleModule;

public class ModularTurret
extends PayloadBlock {
    public ModuleGroup[] moduleGroups;
    public Vec2[] smallMountPos;
    public Vec2[] mediumMountPos;
    public Vec2[] largeMountPos;
    public Color mountColor = Pal.accent;
    public TextureRegion[] mountBases = new TextureRegion[3];
    protected static ModuleModule.ModuleSize selSize;
    protected static final Table moduleDisplayTable;

    public ModularTurret(String name) {
        super(name);
        this.acceptsPayload = true;
        this.outputsPayload = false;
        this.hasLiquids = true;
        this.hasPower = true;
        this.outputsLiquid = false;
        this.rotate = false;
        this.configurable = true;
        this.solid = true;
        this.suppressable = true;
        this.priority = 1.0f;
        this.group = BlockGroup.turrets;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret});
        this.config(Integer.class, (build, swap) -> {
            ((TurretModule)build.modules.get((int)Point2.x((int)swap.intValue()))).module().mountNumber = Point2.y((int)swap);
        });
        this.config(Boolean.class, (build, accordingToAllKnownLawsOfAviationThereIsNoWayThatABeeShouldBeAbleToFlyItsWingsAreTooSmallToGetItsFatLittleBodyOffTheGroundTheBeeOfCourseFliesAnywaysBecauseBeesDontCareWhatHumansThinkIsImpossible) -> {
            build.sort();
            build.updatePos();
        });
    }

    public void init() {
        super.init();
        if (this.moduleGroups == null) {
            return;
        }
        int sLen = 0;
        int mLen = 0;
        int lLen = 0;
        block10: for (ModuleGroup group : this.moduleGroups) {
            switch (group.size) {
                case small: {
                    sLen += group.amount();
                    continue block10;
                }
                case medium: {
                    mLen += group.amount();
                    continue block10;
                }
                case large: {
                    lLen += group.amount();
                }
            }
        }
        int sCount = 0;
        int mCount = 0;
        int lCount = 0;
        block11: for (ModuleGroup group : this.moduleGroups) {
            switch (group.size) {
                case small: {
                    int i;
                    if (this.smallMountPos == null) {
                        this.smallMountPos = new Vec2[sLen];
                    }
                    for (i = 0; i < group.amount(); ++i) {
                        this.smallMountPos[sCount] = group.pos(i);
                        ++sCount;
                    }
                    continue block11;
                }
                case medium: {
                    int i;
                    if (this.mediumMountPos == null) {
                        this.mediumMountPos = new Vec2[mLen];
                    }
                    for (i = 0; i < group.amount(); ++i) {
                        this.mediumMountPos[mCount] = group.pos(i);
                        ++mCount;
                    }
                    continue block11;
                }
                case large: {
                    int i;
                    if (this.largeMountPos == null) {
                        this.largeMountPos = new Vec2[lLen];
                    }
                    for (i = 0; i < group.amount(); ++i) {
                        this.largeMountPos[lCount] = group.pos(i);
                        ++lCount;
                    }
                    continue block11;
                }
            }
        }
    }

    public void load() {
        super.load();
        if (!this.inRegion.found() && this.minfo.mod != null) {
            this.inRegion = Core.atlas.find(this.minfo.mod.name + "-factory-in-" + this.size + this.regionSuffix);
        }
        for (int i = 0; i < 3; ++i) {
            this.mountBases[i] = Core.atlas.find(this.name + "-mount" + (i + 1), "prog-mats-mount" + (i + 1));
        }
    }

    public void setClip(float clip) {
        float dst = 0.0f;
        if (this.smallMountPos != null) {
            for (Vec2 pos : this.smallMountPos) {
                dst = Math.max(dst, Math.max(pos.x, pos.y));
            }
        }
        if (this.mediumMountPos != null) {
            for (Vec2 pos : this.mediumMountPos) {
                dst = Math.max(dst, Math.max(pos.x, pos.y));
            }
        }
        if (this.largeMountPos != null) {
            for (Vec2 pos : this.largeMountPos) {
                dst = Math.max(dst, Math.max(pos.x, pos.y));
            }
        }
        this.clipSize = Math.max(this.clipSize, clip + dst * 2.0f);
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.inRegion, this.topRegion};
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.powerUse);
        this.stats.remove(Stat.liquidCapacity);
        this.stats.add(PMStat.mounts, PMStatValues.moduleCounts(this.moduleGroups));
    }

    public void setBars() {
        super.setBars();
        this.removeBar("liquid");
        this.removeBar("power");
    }

    public boolean canBreak(Tile tile) {
        ModularTurretBuild b = (ModularTurretBuild)tile.build;
        return b.modules.isEmpty() || Vars.state.rules.infiniteResources || Vars.state.isEditor();
    }

    static {
        moduleDisplayTable = new Table();
    }

    public static class ModuleGroup {
        public ModuleModule.ModuleSize size;
        public ModuleGroupType groupType;
        public float offsetX;
        public float offsetY;

        public ModuleGroup(ModuleModule.ModuleSize size, ModuleGroupType groupType, float offsetX, float offsetY) {
            this.size = size;
            this.groupType = groupType;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        public ModuleGroup(ModuleModule.ModuleSize size) {
            this(size, ModuleGroupType.single, 0.0f, 0.0f);
        }

        public Vec2 pos(int pos) {
            float f;
            float f2;
            switch (this.groupType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case single: {
                    f2 = this.offsetX;
                    break;
                }
                case quad: {
                    f2 = -this.offsetX;
                    break;
                }
                case circle: {
                    if (pos % 2 == 0) {
                        f2 = -this.offsetX;
                        break;
                    }
                    f2 = 0.0f;
                    break;
                }
                case oct: {
                    f2 = pos % 2 == 0 ? -this.offsetX : -this.offsetY;
                }
            }
            float x = f2;
            switch (this.groupType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case single: 
                case quad: {
                    f = this.offsetY;
                    break;
                }
                case circle: {
                    if (pos % 2 == 0) {
                        f = this.offsetX;
                        break;
                    }
                    f = this.offsetY;
                    break;
                }
                case oct: {
                    f = pos % 2 == 0 ? this.offsetY : this.offsetX;
                }
            }
            float y = f;
            Vec2 output = new Vec2(x, y);
            switch (this.groupType) {
                case quad: {
                    output.rotate((float)pos * -90.0f);
                    break;
                }
                case circle: 
                case oct: {
                    output.rotate((float)Mathf.floor((float)((float)pos / 2.0f)) * -90.0f);
                }
            }
            return output;
        }

        public int amount() {
            int n;
            switch (this.groupType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case single: {
                    n = 1;
                    break;
                }
                case quad: {
                    n = 4;
                    break;
                }
                case circle: 
                case oct: {
                    n = 8;
                }
            }
            return n;
        }

        public static enum ModuleGroupType {
            single,
            quad,
            circle,
            oct;

        }
    }

    public class ModularTurretBuild
    extends PayloadBlock.PayloadBlockBuild<BuildPayload>
    implements ControlBlock {
        public Seq<TurretModule> modules;
        public BlockUnitc unit;
        protected int selNum;

        public ModularTurretBuild() {
            super((PayloadBlock)ModularTurret.this);
            this.modules = new Seq();
            this.unit = (BlockUnitc)UnitTypes.block.create(this.team);
        }

        public Unit unit() {
            this.unit.tile((Building)this);
            this.unit.team(this.team);
            return (Unit)this.unit;
        }

        public void control(LAccess type, double p1, double p2, double p3, double p4) {
            this.modules.each(m -> m.build().control(type, p1, p2, p3, p4));
            super.control(type, p1, p2, p3, p4);
        }

        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
            this.modules.each(m -> m.build().control(type, p1, p2, p3, p4));
            super.control(type, p1, p2, p3, p4);
        }

        public void updateTile() {
            if (this.moveInPayload()) {
                Building building = ((BuildPayload)this.payload).build;
                if (building instanceof TurretModule) {
                    TurretModule module = (TurretModule)building;
                    this.addModule(module);
                }
                this.payload = null;
            }
            this.modules.each(TurretModule::moduleUpdate);
            this.unit.tile((Building)this);
            this.unit.team(this.team);
            this.unit.ammo(1.0f);
        }

        public void onConfigureClosed() {
            this.unHighlight();
        }

        public void remove() {
            super.remove();
            this.modules.each(m -> m.module().moduleRemoved());
        }

        public void draw() {
            Draw.rect((TextureRegion)ModularTurret.this.region, (float)this.x, (float)this.y);
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i)) continue;
                Draw.rect((TextureRegion)ModularTurret.this.inRegion, (float)this.x, (float)this.y, (float)((float)i * 90.0f - 180.0f));
            }
            this.drawPayload();
            Draw.z((float)35.1f);
            Draw.rect((TextureRegion)ModularTurret.this.topRegion, (float)this.x, (float)this.y);
            for (ModuleModule.ModuleSize s : ModuleModule.ModuleSize.values()) {
                if (!this.acceptModule(s)) continue;
                float mX = this.x + this.nextMountX(s);
                float mY = this.y + this.nextMountY(s);
                Draw.color((Color)ModularTurret.this.mountColor, (float)Mathf.absin((float)9.549296f, (float)1.0f));
                Draw.rect((TextureRegion)ModularTurret.this.mountBases[s.ordinal()], (float)mX, (float)mY);
                Draw.color();
            }
            if (this.isPayload()) {
                this.updatePos();
            }
            this.modules.each(TurretModule::moduleDraw);
        }

        public void applyBoost(float intensity, float duration) {
            super.applyBoost(intensity, duration);
            this.modules.each(m -> m.build().applyBoost(intensity, duration));
        }

        public void applyHealSuppression(float amount) {
            super.applyHealSuppression(amount);
            this.modules.each(m -> m.build().applyHealSuppression(amount));
        }

        public void applySlowdown(float intensity, float duration) {
            super.applySlowdown(intensity, duration);
            this.modules.each(m -> m.build().applySlowdown(intensity, duration));
        }

        public void unHighlight() {
            this.modules.each(m -> {
                m.module().highlight = false;
            });
        }

        public void highlightModule() {
            this.unHighlight();
            if (this.modules.any() && this.selNum >= 0) {
                ((TurretModule)this.modules.get((int)this.selNum)).module().highlight = true;
            }
        }

        public void updatePos() {
            this.modules.each(m -> m.module().updatePos(this));
        }

        public TurretModule addModule(TurretModule module) {
            return this.addModule(module, this.nextMount(module.size()));
        }

        public TurretModule addModule(TurretModule module, short pos) {
            module.module().moduleAdded(this, pos);
            module.module().updatePos(this);
            this.modules.add((Object)module);
            this.sort();
            boolean has = this.modules.contains(m -> m.checkSize(module.size()));
            this.rebuild(false, !has, has);
            if (ProgMats.swapDialog.isShown()) {
                ProgMats.swapDialog.rebuild();
            }
            return module;
        }

        public void removeMount(TurretModule module) {
            module.module().moduleRemoved();
            this.modules.remove((Object)module);
        }

        public short nextMount(ModuleModule.ModuleSize size) {
            short mount = 0;
            for (TurretModule m : this.modules) {
                if (!m.checkSize(size) || m.module().mountNumber != mount) continue;
                mount = (short)(m.module().mountNumber + 1);
            }
            return mount;
        }

        public Vec2[] getMountPos(ModuleModule.ModuleSize size) {
            Vec2[] vec2Array;
            switch (size) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case small: {
                    vec2Array = ModularTurret.this.smallMountPos;
                    break;
                }
                case medium: {
                    vec2Array = ModularTurret.this.mediumMountPos;
                    break;
                }
                case large: {
                    vec2Array = ModularTurret.this.largeMountPos;
                }
            }
            return vec2Array;
        }

        public int getMountCapacity(ModuleModule.ModuleSize size) {
            return this.getMountPos(size).length;
        }

        public int getMaxMounts(ModuleModule.ModuleSize size) {
            return this.getMountPos(size).length;
        }

        public float nextMountX(ModuleModule.ModuleSize size) {
            return this.nextMountX(size, this.nextMount(size));
        }

        public float nextMountX(ModuleModule.ModuleSize size, int pos) {
            return this.getMountPos((ModuleModule.ModuleSize)size)[pos].x;
        }

        public float nextMountY(ModuleModule.ModuleSize size) {
            return this.nextMountY(size, this.nextMount(size));
        }

        public float nextMountY(ModuleModule.ModuleSize size, int pos) {
            return this.getMountPos((ModuleModule.ModuleSize)size)[pos].y;
        }

        public void sort() {
            this.modules.sort(m -> m.size().ordinal() * 100 + m.module().mountNumber);
        }

        public void buildConfiguration(Table table) {
            this.resetSelection();
            this.rebuild(true, false, false);
            table.table(t -> t.add((Element)moduleDisplayTable)).top().expandY();
        }

        public void rebuild(boolean highlight, boolean dropMenu, boolean slideDisplay) {
            if (highlight) {
                this.highlightModule();
            }
            moduleDisplayTable.clearChildren();
            moduleDisplayTable.top();
            moduleDisplayTable.table(t -> {
                t.top();
                for (ModuleModule.ModuleSize mSize : ModuleModule.ModuleSize.values()) {
                    t.button(mSize.title(), Styles.flatTogglet, () -> {
                        if (selSize != mSize) {
                            selSize = mSize;
                            this.selNum = this.modules.indexOf(m -> m.checkSize(mSize));
                            this.rebuild(true, true, false);
                        }
                    }).update(b -> b.setChecked(selSize == mSize)).size(80.0f, 40.0f);
                }
                t.button((Drawable)Icon.settings, Styles.cleari, () -> ProgMats.swapDialog.show(this)).size(80.0f, 40.0f);
            }).top();
            if (!this.modules.contains(m -> m.checkSize(selSize))) {
                return;
            }
            moduleDisplayTable.row();
            moduleDisplayTable.table(Styles.black6, t -> {
                t.top().left();
                if (dropMenu) {
                    t.setTransform(true);
                    t.actions(new Action[]{Actions.scaleTo((float)1.0f, (float)0.0f), Actions.scaleTo((float)1.0f, (float)1.0f, (float)0.15f, (Interp)Interp.pow3Out)});
                    t.update(() -> t.setOrigin(2));
                }
                t.table(m -> {
                    m.left().top();
                    int[] rowCount = new int[]{0};
                    this.modules.each(module -> module.checkSize(selSize), module -> {
                        ImageButton button = (ImageButton)m.button(Tex.whiteui, Styles.clearTogglei, 32.0f, () -> {
                            int index = this.modules.indexOf(module);
                            if (this.selNum != index) {
                                this.selNum = index;
                                this.rebuild(true, false, true);
                            }
                        }).update(b -> b.setChecked(this.selNum == this.modules.indexOf(module))).size(40.0f).get();
                        button.getStyle().imageUp = new TextureRegionDrawable(module.icon());
                        int n = rowCount[0];
                        rowCount[0] = n + 1;
                        if (n % 8 == 7) {
                            m.row();
                        }
                    });
                    if (rowCount[0] % 8 != 0) {
                        int remaining = 8 - rowCount[0] % 8;
                        for (int j = 0; j < remaining; ++j) {
                            m.image(Styles.none);
                        }
                    }
                }).left().top().growY();
                t.row();
                if (this.selNum >= 0) {
                    TurretModule module = (TurretModule)this.modules.get(this.selNum);
                    t.table(d -> {
                        if (slideDisplay) {
                            d.setTransform(true);
                            d.actions(new Action[]{Actions.scaleTo((float)1.0f, (float)0.0f), Actions.scaleTo((float)1.0f, (float)1.0f, (float)0.15f, (Interp)Interp.pow3Out)});
                            d.update(() -> d.setOrigin(2));
                        }
                        d.top().left();
                        module.module().moduleDisplay((Table)d);
                    }).top().left().grow();
                }
            }).top().grow();
        }

        public void resetSelection() {
            this.selNum = 0;
            selSize = this.modules.any() ? ((TurretModule)this.modules.first()).size() : ModuleModule.ModuleSize.small;
        }

        public void setSelection(ModuleModule.ModuleSize size) {
            selSize = size;
            this.selNum = this.modules.indexOf(m -> m.checkSize(size));
            if (this.selNum == -1) {
                this.resetSelection();
            }
        }

        public boolean acceptModule(ModuleModule.ModuleSize size) {
            boolean bl;
            switch (size) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case small: {
                    if (ModularTurret.this.smallMountPos != null && this.modules.count(TurretModule::isSmall) + 1 <= ModularTurret.this.smallMountPos.length) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case medium: {
                    if (ModularTurret.this.mediumMountPos != null && this.modules.count(TurretModule::isMedium) + 1 <= ModularTurret.this.mediumMountPos.length) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case large: {
                    bl = ModularTurret.this.largeMountPos != null && this.modules.count(TurretModule::isLarge) + 1 <= ModularTurret.this.largeMountPos.length;
                }
            }
            return bl;
        }

        public boolean acceptItem(Building source, Item item) {
            return this.modules.contains(m -> m.build().acceptItem((Building)this, item));
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            TurretModule mount = (TurretModule)this.modules.find(m -> m.build().acceptStack(item, amount, (Teamc)this) > 0);
            if (mount == null) {
                return 0;
            }
            return mount.build().acceptStack(item, amount, (Teamc)this);
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return this.modules.contains(m -> m.build().acceptLiquid((Building)this, liquid));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean acceptPayload(Building source, Payload payload) {
            if (!super.acceptPayload(source, payload)) return false;
            if (!(payload instanceof BuildPayload)) return false;
            BuildPayload p = (BuildPayload)payload;
            Building building = p.build;
            if (!(building instanceof TurretModule)) return false;
            TurretModule module = (TurretModule)building;
            if (!this.acceptModule(module.size())) return false;
            if (this.modules.contains(m -> !m.acceptModule(module))) return false;
            return true;
        }

        public void handleItem(Building source, Item item) {
            TurretModule mount = (TurretModule)this.modules.find(m -> m.build().acceptItem((Building)this, item));
            mount.build().handleItem((Building)this, item);
        }

        public int removeStack(Item item, int amount) {
            return 0;
        }

        public void handleStack(Item item, int amount, Teamc source) {
            TurretModule mount = (TurretModule)this.modules.find(m -> m.build().acceptStack(item, amount, (Teamc)this) > 0);
            if (mount != null) {
                mount.build().handleStack(item, amount, (Teamc)this);
            }
        }

        public void handleLiquid(Building source, Liquid liquid, float amount) {
            TurretModule mount = (TurretModule)this.modules.find(m -> m.build().acceptLiquid((Building)this, liquid));
            mount.build().handleLiquid((Building)this, liquid, amount);
        }

        public void dropped() {
            this.modules.each(m -> m.module().updatePos(this));
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.modules.size);
            this.modules.each(m -> {
                write.s((int)m.block().id);
                write.b((int)m.build().version());
                m.build().writeAll(write);
            });
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                int amount = read.i();
                for (int i = 0; i < amount; ++i) {
                    Block module = Vars.content.block((int)read.s());
                    TurretModule moduleBuild = (TurretModule)module.newBuilding().create(module, Team.derelict);
                    byte version = read.b();
                    moduleBuild.build().readAll(read, version);
                    moduleBuild.build().tile = Vars.emptyTile;
                    moduleBuild.module().parent = this;
                    this.addModule(moduleBuild, moduleBuild.module().mountNumber);
                }
            }
        }

        public byte version() {
            return 1;
        }
    }
}

