/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload;

import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.world.blocks.defense.turrets.PayloadAmmoTurret;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.meta.Stat;
import progressed.world.blocks.payloads.Missile;
import progressed.world.draw.DrawPayloadTurret;
import progressed.world.meta.PMStatValues;

public class SinglePayloadAmmoTurret
extends PayloadAmmoTurret {
    public float payloadSpeed = 0.7f;
    public float minLoadWarmup = 1.0f;

    public SinglePayloadAmmoTurret(String name) {
        super(name);
        this.maxAmmo = 1;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.outlinedIcon = 3;
        this.drawer = new DrawPayloadTurret(true);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(this.ammoTypes, true));
    }

    public void setWarmupTime(float seconds) {
        this.minLoadWarmup = 0.0f;
        this.minWarmup = 1.0f;
        this.linearWarmup = true;
        this.shootWarmupSpeed = 1.0f / (seconds * 60.0f);
    }

    public void setUsers() {
        for (ObjectMap.Entry entry : this.ammoTypes.copy().entries()) {
            Object object = entry.key;
            if (!(object instanceof Missile)) continue;
            Missile m = (Missile)((Object)object);
            m.user = this;
            m.bullet = (BulletType)entry.value;
        }
    }

    public class SinglePayloadAmmoTurretBuild
    extends PayloadAmmoTurret.PayloadTurretBuild {
        public Payload payload;
        public float payLen;
        public Vec2 payVector;

        public SinglePayloadAmmoTurretBuild() {
            super((PayloadAmmoTurret)SinglePayloadAmmoTurret.this);
            this.payVector = new Vec2();
        }

        public void updateTile() {
            if (this.moveInPayload()) {
                this.payloads.add(this.payload.content());
                this.payload = null;
            }
            super.updateTile();
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return this.payload == null && this.shootWarmup <= SinglePayloadAmmoTurret.this.minLoadWarmup && super.acceptPayload(source, payload);
        }

        public void handlePayload(Building source, Payload payload) {
            this.payload = payload;
            this.payVector.set((Position)source).sub((Position)this).clamp((float)(-SinglePayloadAmmoTurret.this.size * 8) / 2.0f, (float)(-SinglePayloadAmmoTurret.this.size * 8) / 2.0f, (float)(SinglePayloadAmmoTurret.this.size * 8) / 2.0f, (float)(SinglePayloadAmmoTurret.this.size * 8) / 2.0f);
            this.payLen = this.payVector.len();
        }

        public void updatePayload() {
            if (this.payload != null) {
                this.payload.set(this.x + this.payVector.x, this.y + this.payVector.y, this.payload.rotation());
            }
        }

        public boolean moveInPayload() {
            if (this.payload == null) {
                return false;
            }
            this.updatePayload();
            this.payVector.approach(Vec2.ZERO, SinglePayloadAmmoTurret.this.payloadSpeed * this.delta());
            return this.hasArrived();
        }

        public boolean hasArrived() {
            return this.payVector.isZero(0.01f);
        }

        public float payloadf() {
            return this.payVector.len() / this.payLen;
        }

        protected void shoot(BulletType type) {
            super.shoot(type);
            if (SinglePayloadAmmoTurret.this.minLoadWarmup < 0.999f) {
                this.shootWarmup -= SinglePayloadAmmoTurret.this.shootWarmupSpeed * Time.delta;
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.payVector.x);
            write.f(this.payVector.y);
            write.f(this.payLen);
            Payload.write((Payload)this.payload, (Writes)write);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 2) {
                this.payVector.set(read.f(), read.f());
                this.payLen = read.f();
                this.payload = Payload.read((Reads)read);
            }
        }

        public byte version() {
            return 2;
        }
    }
}

