/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret.payload;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Posc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import progressed.entities.bullet.pseudo3d.ArcMissileBulletType;
import progressed.util.Math3D;
import progressed.util.PMMathf;
import progressed.util.PMUtls;
import progressed.world.blocks.defence.turret.payload.SinglePayloadAmmoTurret;
import progressed.world.draw.DrawPayloadTurret;

public class ArcMissileTurret
extends SinglePayloadAmmoTurret {
    public float accelRnd = 0.0f;

    public ArcMissileTurret(String name) {
        super(name);
        this.outlineIcon = false;
        this.outlinedIcon = 1;
        this.rotateSpeed = 3600.0f;
        this.drawer = new DrawPayloadTurret(false);
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.shootRange);
        this.stats.add(Stat.shootRange, "@-@ @", new Object[]{StatValues.fixValue((float)(this.minRange / 8.0f)), StatValues.fixValue((float)(this.range / 8.0f)), StatUnit.blocks.localized()});
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.minRange, (Color)Pal.accentBack);
    }

    public void init() {
        for (UnlockableContent c : this.ammoTypes.keys()) {
            Object object = this.ammoTypes.get((Object)c);
            if (!(object instanceof ArcMissileBulletType)) {
                PMUtls.uhOhSpeghettiOh("Arc missile turret " + this.name + " has a non-arc missle bullet!");
                continue;
            }
            ArcMissileBulletType aType = (ArcMissileBulletType)((Object)object);
            aType.initDrawSize(this.range);
        }
        super.init();
    }

    public class ArcMissileTurretBuild
    extends SinglePayloadAmmoTurret.SinglePayloadAmmoTurretBuild {
        public ArcMissileTurretBuild() {
            super(ArcMissileTurret.this);
        }

        public void targetPosition(Posc pos) {
            if (!this.hasAmmo() || pos == null) {
                return;
            }
            ArcMissileBulletType bullet = (ArcMissileBulletType)this.peekAmmo();
            if (ArcMissileTurret.this.predictTarget && pos instanceof Hitboxc) {
                Hitboxc h = (Hitboxc)pos;
                this.targetPos.set(Math3D.intercept((Position)this, (Position)h, bullet.accel, bullet.speed));
            } else {
                this.targetPos.set((Position)pos);
            }
            if (!bullet.scaleLife) {
                this.targetPos.sub((Position)this).setLength(this.range()).add((Position)this);
            }
            if (this.targetPos.isZero()) {
                this.targetPos.set((Position)pos);
            }
        }

        protected void findTarget() {
            float range = this.range();
            if (ArcMissileTurret.this.targetAir && !ArcMissileTurret.this.targetGround) {
                this.target = Units.bestEnemy((Team)this.team, (float)this.x, (float)this.y, (float)range, e -> !e.dead() && !e.isGrounded() && ArcMissileTurret.this.unitFilter.get(e) && this.dst((Position)e) >= ArcMissileTurret.this.minRange, (Units.Sortf)ArcMissileTurret.this.unitSort);
            } else {
                this.target = Units.bestTarget((Team)this.team, (float)this.x, (float)this.y, (float)range, e -> !(e.dead() || !ArcMissileTurret.this.unitFilter.get(e) || !e.isGrounded() && !ArcMissileTurret.this.targetAir || e.isGrounded() && !ArcMissileTurret.this.targetGround || !(this.dst((Position)e) >= ArcMissileTurret.this.minRange)), b -> ArcMissileTurret.this.targetGround && ArcMissileTurret.this.buildingFilter.get(b) && this.dst((Position)b) >= ArcMissileTurret.this.minRange, (Units.Sortf)ArcMissileTurret.this.unitSort);
                if (this.target == null && this.canHeal()) {
                    this.target = Units.findAllyTile((Team)this.team, (float)this.x, (float)this.y, (float)range, b -> b.damaged() && b != this);
                }
            }
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)ArcMissileTurret.this.minRange, (Color)Pal.accentBack);
        }

        protected void turnToTarget(float targetRot) {
            this.rotation = targetRot;
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            --this.queuedBullets;
            if (this.dead || !ArcMissileTurret.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            float xSpread = Mathf.range((float)ArcMissileTurret.this.xRand);
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)(ArcMissileTurret.this.shootX + xOffset + xSpread), (float)(ArcMissileTurret.this.shootY + yOffset));
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)(ArcMissileTurret.this.shootX + xOffset + xSpread), (float)(ArcMissileTurret.this.shootY + yOffset));
            float shootAngle = this.rotation + angleOffset + Mathf.range((float)(ArcMissileTurret.this.inaccuracy + type.inaccuracy));
            float accScl = 1.0f + Mathf.range((float)(ArcMissileTurret.this.accelRnd / 2.0f));
            float velScl = 1.0f + Mathf.range((float)(ArcMissileTurret.this.velocityRnd / 2.0f));
            if (!type.scaleLife) {
                this.targetPos.sub((Position)this).setLength(this.range()).add((Position)this);
            }
            float dst = Math.max(Math.min(Mathf.dst((float)bulletX, (float)bulletY, (float)this.targetPos.x, (float)this.targetPos.y), this.range()), ArcMissileTurret.this.minRange);
            ArcMissileBulletType m = (ArcMissileBulletType)type;
            float time = PMMathf.quadPos(m.accel / 2.0f, m.speed, -dst);
            float zVel = -0.5f * -m.gravity * time;
            this.handleBullet(m.create3DVel((Entityc)this, this.team, bulletX, bulletY, 0.0f, shootAngle, zVel, m.accel * accScl, m.speed * velScl, this.targetPos.x, this.targetPos.y), xOffset, yOffset, shootAngle - this.rotation);
            (ArcMissileTurret.this.shootEffect == null ? type.shootEffect : ArcMissileTurret.this.shootEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            (ArcMissileTurret.this.smokeEffect == null ? type.smokeEffect : ArcMissileTurret.this.smokeEffect).at(bulletX, bulletY, this.rotation + angleOffset, type.hitColor);
            ArcMissileTurret.this.shootSound.at(bulletX, bulletY, Mathf.random((float)ArcMissileTurret.this.soundPitchMin, (float)ArcMissileTurret.this.soundPitchMax));
            ArcMissileTurret.this.ammoUseEffect.at(this.x - Angles.trnsx((float)this.rotation, (float)ArcMissileTurret.this.ammoEjectBack), this.y - Angles.trnsy((float)this.rotation, (float)ArcMissileTurret.this.ammoEjectBack), this.rotation * (float)Mathf.sign((float)xOffset));
            if (ArcMissileTurret.this.shake > 0.0f) {
                Effect.shake((float)ArcMissileTurret.this.shake, (float)ArcMissileTurret.this.shake, (Position)this);
            }
            this.curRecoil = 1.0f;
            if (ArcMissileTurret.this.recoils > 0) {
                this.curRecoils[this.barrelCounter % ArcMissileTurret.this.recoils] = 1.0f;
            }
            this.heat = 1.0f;
            ++this.totalShots;
            if (!ArcMissileTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }
    }
}

