/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.Core;
import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.EnumSet;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Healthc;
import mindustry.gen.Sounds;
import mindustry.gen.Statusc;
import mindustry.graphics.Drawf;
import mindustry.graphics.MultiPacker;
import mindustry.graphics.Pal;
import mindustry.logic.Ranged;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.world.Block;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;
import progressed.content.effects.LightningFx;
import progressed.entities.LightningEffect;
import progressed.entities.PMDamage;
import progressed.graphics.Outliner;
import progressed.util.PMUtls;
import progressed.world.meta.PMStatValues;

public class TeslaTurret
extends Block {
    private final Seq<Healthc> targets = new Seq();
    public final int timerCheck = this.timers++;
    public int checkInterval = 20;
    public Seq<TeslaRing> rings = new Seq();
    public boolean hasSpinners;
    public Color lightningColor = Pal.surge;
    public float reload;
    public float coolantMultiplier = 5.0f;
    public ConsumeLiquidBase coolant;
    public int maxTargets;
    public float range;
    public float damage;
    public float placeOverlapMargin = 56.0f;
    public StatusEffect status;
    public float statusDuration = 600.0f;
    public float spinUp = 0.01f;
    public float spinDown = 0.0125f;
    public float sectionRad = 0.14f;
    public float blinkScl = 20.0f;
    public int sections = 5;
    public Sound shootSound = Sounds.spark;
    public LightningEffect lightningEffect = LightningFx.teslaLightning;
    public Effect shootEffect = Fx.sparkShoot;
    public Effect hitEffect = Fx.hitLaserBlast;
    public Effect coolEffect = Fx.fuelburn;
    public Color heatColor = Pal.turretHeat;
    public float shake;
    public float elevation = -1.0f;
    public float cooldown = 0.04f;
    public float rotateSpeed = 0.5f;
    public TextureRegion[] ringRegions;
    public TextureRegion[] heatRegions;
    public TextureRegion[] outlineRegions;
    public TextureRegion baseRegion;
    public TextureRegion bottomRegion;
    public TextureRegion topRegion;

    public TeslaTurret(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.outlineIcon = true;
        this.priority = 1.0f;
        this.group = BlockGroup.turrets;
        this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret});
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.shootRange, this.range / 8.0f, StatUnit.blocks);
        this.stats.add(Stat.reload, 60.0f / this.reload, StatUnit.perSecond);
        this.stats.add(Stat.ammo, PMStatValues.teslaZapping(this.damage, this.maxTargets, this.status));
        if (this.coolant != null) {
            this.stats.add(Stat.booster, StatValues.boosters((float)this.reload, (float)this.coolant.amount, (float)this.coolantMultiplier, (boolean)true, l -> l.coolant && this.consumesLiquid((Liquid)l)));
        }
    }

    public void load() {
        super.load();
        this.ringRegions = new TextureRegion[this.rings.size];
        this.heatRegions = new TextureRegion[this.rings.size];
        this.outlineRegions = new TextureRegion[this.rings.size];
        for (int i = 0; i < this.ringRegions.length; ++i) {
            if (((TeslaRing)this.rings.get((int)i)).hasSprite) {
                this.ringRegions[i] = Core.atlas.find(this.name + "-ring-" + i);
                this.outlineRegions[i] = Core.atlas.find(this.name + "-outline-" + i);
            }
            this.heatRegions[i] = Core.atlas.find(this.name + "-heat-" + i);
        }
        if (this.hasSpinners) {
            this.bottomRegion = Core.atlas.find(this.name + "-bottom");
        }
        this.topRegion = Core.atlas.find(this.name + "-top");
        this.baseRegion = Core.atlas.find(this.name + "-base", "block-" + this.size);
    }

    public void createIcons(MultiPacker packer) {
        if (this.hasSpinners) {
            Outliner.outlineRegion(packer, this.bottomRegion, this.outlineColor, this.name + "-bottom");
        }
        Outliner.outlineRegions(packer, this.ringRegions, this.outlineColor, this.name + "-outline");
        super.createIcons(packer);
    }

    public void init() {
        if (this.rings.size <= 0) {
            PMUtls.uhOhSpeghettiOh(this.name + " does not have any rings!");
        }
        if (this.maxTargets <= 0) {
            this.maxTargets = 1;
        }
        if (this.elevation < 0.0f) {
            this.elevation = (float)this.size / 2.0f;
        }
        this.clipSize = Math.max(this.clipSize, (this.range + 3.0f) * 2.0f);
        if (this.coolant != null) {
            this.coolant.update = false;
            this.coolant.booster = true;
            this.coolant.optional = true;
        }
        this.placeOverlapRange = Math.max(this.placeOverlapRange, this.range + this.placeOverlapMargin);
        this.fogRadius = Math.max(Mathf.round((float)(this.range / 8.0f)), this.fogRadius);
        super.init();
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        Drawf.dashCircle((float)((float)(x * 8) + this.offset), (float)((float)(y * 8) + this.offset), (float)this.range, (Color)Pal.placing);
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{this.baseRegion, this.region};
    }

    public static class TeslaRing {
        public boolean drawUnder;
        public boolean hasSprite;
        public float rotationMul;
        public float radius;
        public float xOffset;
        public float yOffset;

        public TeslaRing(float radius) {
            this.radius = radius;
        }
    }

    public class TeslaTurretBuild
    extends Building
    implements Ranged {
        protected float[] heats;
        protected float rotation;
        protected float speedScl;
        protected float curStroke;
        protected float reloadCounter;
        protected boolean nearby;

        public TeslaTurretBuild() {
            this.heats = new float[TeslaTurret.this.rings.size];
            this.rotation = 90.0f;
        }

        public void drawSelect() {
            Drawf.dashCircle((float)this.x, (float)this.y, (float)TeslaTurret.this.range, (Color)this.team.color);
        }

        public void draw() {
            TeslaRing ring;
            int i;
            Draw.rect((TextureRegion)TeslaTurret.this.baseRegion, (float)this.x, (float)this.y);
            Draw.z((float)50.0f);
            for (int i2 = 0; i2 < TeslaTurret.this.rings.size; ++i2) {
                TeslaRing ring2 = (TeslaRing)TeslaTurret.this.rings.get(i2);
                if (!ring2.hasSprite) continue;
                Drawf.shadow((TextureRegion)TeslaTurret.this.ringRegions[i2], (float)(this.x - TeslaTurret.this.elevation), (float)(this.y - TeslaTurret.this.elevation), (float)(this.rotation * ring2.rotationMul - 90.0f));
            }
            TextureRegion r = TeslaTurret.this.hasSpinners ? TeslaTurret.this.bottomRegion : TeslaTurret.this.region;
            Drawf.shadow((TextureRegion)r, (float)(this.x - TeslaTurret.this.elevation), (float)(this.y - TeslaTurret.this.elevation));
            Draw.rect((TextureRegion)r, (float)this.x, (float)this.y);
            for (i = 0; i < TeslaTurret.this.rings.size; ++i) {
                ring = (TeslaRing)TeslaTurret.this.rings.get(i);
                if (!ring.hasSprite) continue;
                Draw.rect((TextureRegion)TeslaTurret.this.outlineRegions[i], (float)this.x, (float)this.y, (float)(this.rotation * ring.rotationMul - 90.0f));
            }
            for (i = 0; i < TeslaTurret.this.rings.size; ++i) {
                ring = (TeslaRing)TeslaTurret.this.rings.get(i);
                if (!ring.drawUnder) continue;
                if (ring.hasSprite) {
                    if (ring.rotationMul != 0.0f) {
                        Drawf.spinSprite((TextureRegion)TeslaTurret.this.ringRegions[i], (float)this.x, (float)this.y, (float)(this.rotation * ring.rotationMul - 90.0f));
                    } else {
                        Draw.rect((TextureRegion)TeslaTurret.this.ringRegions[i], (float)this.x, (float)this.y);
                    }
                }
                if (!(this.heats[i] > 1.0E-5f)) continue;
                Draw.color((Color)TeslaTurret.this.heatColor, (float)this.heats[i]);
                Draw.blend((Blending)Blending.additive);
                Draw.rect((TextureRegion)TeslaTurret.this.heatRegions[i], (float)this.x, (float)this.y, (float)(this.rotation * ring.rotationMul - 90.0f));
                Draw.blend();
                Draw.color();
            }
            Draw.rect((TextureRegion)(TeslaTurret.this.topRegion.found() ? TeslaTurret.this.topRegion : TeslaTurret.this.region), (float)this.x, (float)this.y);
            for (i = 0; i < TeslaTurret.this.rings.size; ++i) {
                ring = (TeslaRing)TeslaTurret.this.rings.get(i);
                if (ring.drawUnder) continue;
                if (ring.hasSprite) {
                    if (ring.rotationMul != 0.0f) {
                        Drawf.spinSprite((TextureRegion)TeslaTurret.this.ringRegions[i], (float)this.x, (float)this.y, (float)(this.rotation * ring.rotationMul - 90.0f));
                    } else {
                        Draw.rect((TextureRegion)TeslaTurret.this.ringRegions[i], (float)this.x, (float)this.y);
                    }
                }
                if (!(this.heats[i] > 1.0E-5f)) continue;
                Draw.color((Color)TeslaTurret.this.heatColor, (float)this.heats[i]);
                Draw.blend((Blending)Blending.additive);
                Draw.rect((TextureRegion)TeslaTurret.this.heatRegions[i], (float)this.x, (float)this.y, (float)(this.rotation * ring.rotationMul - 90.0f));
                Draw.blend();
                Draw.color();
            }
            if (Core.settings.getBool("pm-tesla-range") && this.curStroke > 0.001f) {
                Draw.z((float)99.999f);
                Lines.stroke((float)((0.7f + Mathf.absin((float)TeslaTurret.this.blinkScl, (float)0.7f)) * this.curStroke), (Color)TeslaTurret.this.lightningColor);
                for (i = 0; i < TeslaTurret.this.sections; ++i) {
                    float rot = (float)i * 360.0f / (float)TeslaTurret.this.sections + Time.time * TeslaTurret.this.rotateSpeed;
                    Lines.arc((float)this.x, (float)this.y, (float)TeslaTurret.this.range, (float)TeslaTurret.this.sectionRad, (float)rot);
                }
            }
        }

        public void drawLight() {
            Drawf.light((float)this.x, (float)this.y, (float)(TeslaTurret.this.range * 1.5f), (Color)TeslaTurret.this.lightningColor, (float)(this.curStroke * 0.8f));
            super.drawLight();
        }

        public void updateTile() {
            for (int i = 0; i < this.heats.length; ++i) {
                this.heats[i] = Mathf.lerpDelta((float)this.heats[i], (float)0.0f, (float)TeslaTurret.this.cooldown);
            }
            if (!this.nearby || !this.canConsume()) {
                this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)0.0f, (float)TeslaTurret.this.spinDown);
            }
            if (this.nearby && this.canConsume()) {
                Liquid liquid = this.liquids.current();
                this.speedScl = Mathf.lerpDelta((float)this.speedScl, (float)1.0f, (float)(TeslaTurret.this.spinUp * liquid.heatCapacity * TeslaTurret.this.coolantMultiplier * this.edelta()));
            }
            this.rotation -= this.speedScl * this.edelta();
            this.curStroke = Mathf.lerpDelta((float)this.curStroke, (float)(this.nearby ? 1.0f : 0.0f), (float)0.09f);
            if (this.canConsume()) {
                if (this.timer(TeslaTurret.this.timerCheck, TeslaTurret.this.checkInterval)) {
                    this.nearby = PMDamage.checkForTargets(this.team, this.x, this.y, TeslaTurret.this.range);
                }
            } else {
                this.nearby = false;
            }
            if (this.nearby) {
                float f;
                this.updateCooling();
                this.reloadCounter += this.edelta();
                if (f >= TeslaTurret.this.reload) {
                    TeslaTurret.this.targets.clear();
                    PMDamage.allNearbyEnemies(this.team, this.x, this.y, TeslaTurret.this.range, (Cons<Healthc>)((Cons)arg_0 -> ((Seq)TeslaTurret.this.targets).add(arg_0)));
                    if (((TeslaTurret)TeslaTurret.this).targets.size > 0) {
                        TeslaTurret.this.targets.shuffle();
                        int max = Math.min(TeslaTurret.this.maxTargets, ((TeslaTurret)TeslaTurret.this).targets.size);
                        for (int i = 0; i < max; ++i) {
                            Healthc other = (Healthc)TeslaTurret.this.targets.get(i);
                            Building absorber = Damage.findAbsorber((Team)this.team, (float)this.x, (float)this.y, (float)other.getX(), (float)other.getY());
                            if (absorber != null) {
                                other = absorber;
                            }
                            if (other instanceof Building) {
                                Building b = (Building)other;
                                b.damage(this.team, TeslaTurret.this.damage);
                            } else {
                                other.damage(TeslaTurret.this.damage);
                            }
                            if (other instanceof Statusc) {
                                Statusc s = (Statusc)other;
                                s.apply(TeslaTurret.this.status, TeslaTurret.this.statusDuration);
                            }
                            TeslaRing ring = (TeslaRing)TeslaTurret.this.rings.random();
                            this.heats[TeslaTurret.this.rings.indexOf((Object)ring)] = 1.0f;
                            Tmp.v1.trns(this.rotation * ring.rotationMul, ring.xOffset, ring.yOffset);
                            Tmp.v2.setToRandomDirection().setLength(ring.radius);
                            float shootX = this.x + Tmp.v1.x + Tmp.v2.x;
                            float shootY = this.y + Tmp.v1.y + Tmp.v2.y;
                            float shootAngle = Angles.angle((float)shootX, (float)shootY, (float)other.x(), (float)other.y());
                            TeslaTurret.this.shootSound.at(shootX, shootY, Mathf.random((float)0.9f, (float)1.1f));
                            TeslaTurret.this.shootEffect.at(shootX, shootY, shootAngle, TeslaTurret.this.lightningColor);
                            TeslaTurret.this.hitEffect.at(other.x(), other.y(), TeslaTurret.this.lightningColor);
                            TeslaTurret.this.lightningEffect.at(shootX, shootY, other.x(), other.y(), TeslaTurret.this.lightningColor);
                        }
                        Effect.shake((float)TeslaTurret.this.shake, (float)TeslaTurret.this.shake, (Position)this);
                        this.reloadCounter %= TeslaTurret.this.reload;
                    }
                }
            }
        }

        protected void updateCooling() {
            if (this.reloadCounter < TeslaTurret.this.reload && TeslaTurret.this.coolant != null && TeslaTurret.this.coolant.efficiency((Building)this) > 0.0f && this.efficiency > 0.0f) {
                float f;
                ConsumeLiquidBase consumeLiquidBase = TeslaTurret.this.coolant;
                if (consumeLiquidBase instanceof ConsumeLiquidFilter) {
                    ConsumeLiquidFilter filter = (ConsumeLiquidFilter)consumeLiquidBase;
                    f = filter.getConsumed((Building)this).heatCapacity;
                } else {
                    f = 1.0f;
                }
                float capacity = f;
                TeslaTurret.this.coolant.update((Building)this);
                this.reloadCounter += TeslaTurret.this.coolant.amount * this.edelta() * capacity * TeslaTurret.this.coolantMultiplier;
                if (Mathf.chance((double)(0.06 * (double)TeslaTurret.this.coolant.amount))) {
                    TeslaTurret.this.coolEffect.at(this.x + Mathf.range((float)((float)(TeslaTurret.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(TeslaTurret.this.size * 8) / 2.0f)));
                }
            }
        }

        public float range() {
            return TeslaTurret.this.range;
        }

        public boolean shouldConsume() {
            return super.shouldConsume() && this.nearby;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.reloadCounter);
            write.bool(this.nearby);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 2) {
                this.reloadCounter = read.f();
                this.nearby = read.bool();
            }
        }

        public byte version() {
            return 2;
        }
    }
}

