/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.Core;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Bullets;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.LAccess;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import progressed.entities.bullet.unit.SignalFlareBulletType;
import progressed.gen.entities.SignalFlareUnitc;
import progressed.util.PMUtls;
import progressed.world.meta.PMStatValues;

public class SignalFlareTurret
extends ItemTurret {
    public int flareLimit = 1;

    public SignalFlareTurret(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(this.ammoTypes));
    }

    public void setBars() {
        super.setBars();
        this.addBar("pm-reload", entity -> new Bar(() -> Core.bundle.format("bar.pm-reload", new Object[]{PMUtls.stringsFixed(Mathf.clamp((float)(entity.reloadCounter / this.reload)) * 100.0f)}), () -> entity.team.color, () -> Mathf.clamp((float)(entity.reloadCounter / this.reload))));
        this.addBar("pm-flare-limit", entity -> new Bar(() -> Core.bundle.format("bar.pm-flare-limit", new Object[]{entity.flares.size, this.flareLimit}), () -> entity.team.color, entity::countf));
    }

    public class SignalFlareTurretBuild
    extends ItemTurret.ItemTurretBuild {
        protected IntSeq readUnits;
        public float tX;
        public float tY;
        public int count;
        public int amount;
        public Seq<SignalFlareUnitc> flares;
        public boolean targetFound;
        public Bullet bullet;

        public SignalFlareTurretBuild() {
            super((ItemTurret)SignalFlareTurret.this);
            this.readUnits = new IntSeq();
            this.flares = new Seq();
        }

        public boolean canControl() {
            return false;
        }

        public void control(LAccess type, Object p1, double p2, double p3, double p4) {
        }

        public void control(LAccess type, double p1, double p2, double p3, double p4) {
        }

        public void updateTile() {
            if (!this.readUnits.isEmpty()) {
                this.flares.clear();
                this.readUnits.each(i -> {
                    Unit unit = (Unit)Groups.unit.getByID(i);
                    if (unit instanceof SignalFlareUnitc) {
                        SignalFlareUnitc f = (SignalFlareUnitc)unit;
                        this.flares.add((Object)f);
                    }
                });
                this.readUnits.clear();
            }
            this.wasShooting = false;
            this.curRecoil = Math.max(this.curRecoil - Time.delta / SignalFlareTurret.this.recoilTime, 0.0f);
            this.heat = Math.max(this.heat - Time.delta / SignalFlareTurret.this.cooldownTime, 0.0f);
            this.unit.health(this.health);
            this.unit.rotation(this.rotation);
            this.unit.team(this.team);
            this.unit.set(this.x, this.y);
            if (this.logicControlTime > 0.0f) {
                this.logicControlTime -= Time.delta;
            }
            if (this.bullet != null && !this.bullet.isAdded()) {
                this.bullet = null;
            }
            if (this.flaresMaxed()) {
                return;
            }
            if (this.hasAmmo()) {
                if (this.timer(SignalFlareTurret.this.timerTarget, SignalFlareTurret.this.targetInterval)) {
                    this.findTarget();
                }
                if (this.count > 0) {
                    float targetRot = this.angleTo((Position)this.targetPos);
                    if (this.shouldTurn()) {
                        this.turnToTarget(targetRot);
                    }
                    if (Angles.angleDist((float)this.rotation, (float)targetRot) < SignalFlareTurret.this.shootCone) {
                        this.wasShooting = true;
                        this.updateShooting();
                    }
                }
            }
            if (SignalFlareTurret.this.coolant != null) {
                this.updateCooling();
            }
        }

        protected void updateShooting() {
            if (this.bullet != null) {
                return;
            }
            if (this.reloadCounter >= SignalFlareTurret.this.reload && !this.charging()) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reloadCounter = 0.0f;
                this.targetFound = false;
            } else {
                this.reloadCounter += this.delta() * this.peekAmmo().reloadMultiplier * this.baseReloadSpeed();
            }
        }

        protected void updateCooling() {
            if (this.bullet != null) {
                return;
            }
            super.updateCooling();
        }

        protected void findTarget() {
            this.tX = 0.0f;
            this.tY = 0.0f;
            this.count = 0;
            Groups.bullet.intersect(this.x - SignalFlareTurret.this.range, this.y - SignalFlareTurret.this.range, SignalFlareTurret.this.range * 2.0f, SignalFlareTurret.this.range * 2.0f, b -> {
                if (b.team != this.team && this.within((Position)b, SignalFlareTurret.this.range) && !this.checkType(b.type) && b.type().speed > 0.01f) {
                    this.tX += b.x;
                    this.tY += b.y;
                    ++this.count;
                }
            });
            if (this.count > 0 && !this.targetFound) {
                this.targetPos.set(this.tX / (float)this.count, this.tY / (float)this.count);
                this.targetFound = true;
            } else {
                this.targetFound = false;
            }
        }

        protected boolean checkType(BulletType b) {
            return b instanceof SignalFlareBulletType || b == Bullets.fireball;
        }

        protected void handleBullet(Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            if (bullet != null) {
                this.bullet = bullet;
            }
        }

        public BlockStatus status() {
            return this.flaresMaxed() ? BlockStatus.noOutput : super.status();
        }

        public boolean flaresMaxed() {
            return this.flares.size >= SignalFlareTurret.this.flareLimit || this.bullet != null;
        }

        public float countf() {
            return (float)this.flares.size / (float)SignalFlareTurret.this.flareLimit;
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            BulletType type = (BulletType)SignalFlareTurret.this.ammoTypes.get((Object)item);
            int a = this.getAmount(item);
            if (type == null || a >= SignalFlareTurret.this.ammoPerShot) {
                return 0;
            }
            return Math.min((int)((float)(SignalFlareTurret.this.ammoPerShot - a) / ((BulletType)SignalFlareTurret.this.ammoTypes.get((Object)item)).ammoMultiplier), amount);
        }

        public boolean acceptItem(Building source, Item item) {
            return (this.totalAmmo == 0 || this.getAmount(item) < SignalFlareTurret.this.ammoPerShot) && super.acceptItem(source, item);
        }

        public int getAmount(Item item) {
            BulletType type = (BulletType)SignalFlareTurret.this.ammoTypes.get((Object)item);
            this.amount = 0;
            this.ammo.each(a -> {
                if (a.type() == type) {
                    this.amount = a.amount;
                }
            });
            return this.amount;
        }

        public void write(Writes write) {
            super.write(write);
            write.b(this.flares.size);
            for (SignalFlareUnitc f : this.flares) {
                write.i(f.id());
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 4) {
                read.i();
            }
            if (revision >= 5) {
                int count = read.b();
                this.readUnits.clear();
                for (int i = 0; i < count; ++i) {
                    this.readUnits.add(read.i());
                }
            }
        }

        public byte version() {
            return 5;
        }
    }
}

