/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.util.PMUtls;

public class MinigunTurret
extends ItemTurret {
    public float windupSpeed = 0.00625f;
    public float windDownSpeed = 0.0125f;
    public float minFiringSpeed = 3.0f;
    public float logicSpeedScl = 0.25f;
    public float maxSpeed = 30.0f;
    public float barX;
    public float barY;
    public float barStroke;
    public float barLength;
    public float barWidth = 1.5f;
    public float barHeight = 0.75f;

    public MinigunTurret(String name) {
        super(name);
        this.drawer = new DrawTurret(){
            TextureRegion barrel;
            TextureRegion barrelOutline;

            public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
                super.getRegionsToOutline(block, out);
                out.add((Object)this.barrel);
            }

            public void load(Block block) {
                super.load(block);
                this.barrel = Core.atlas.find(block.name + "-barrel");
                this.barrelOutline = Core.atlas.find(block.name + "-barrel-outline");
            }

            public void drawTurret(Turret block, Turret.TurretBuild build) {
                int i;
                if (!(build instanceof MinigunTurretBuild)) {
                    return;
                }
                MinigunTurretBuild m = (MinigunTurretBuild)build;
                Vec2 v = Tmp.v1;
                Draw.z((float)49.99f);
                Draw.rect((TextureRegion)this.outline, (float)(build.x + m.recoilOffset.x), (float)(build.y + m.recoilOffset.y), (float)build.drawrot());
                for (i = 0; i < 4; ++i) {
                    Draw.z((float)49.99f);
                    v.trns(m.rotation - 90.0f, MinigunTurret.this.barWidth * Mathf.cosDeg((float)(m.spin - (float)(90 * i))), MinigunTurret.this.barHeight * Mathf.sinDeg((float)(m.spin - (float)(90 * i)))).add(m.recoilOffset);
                    Draw.rect((TextureRegion)this.barrelOutline, (float)(m.x + v.x), (float)(m.y + v.y), (float)m.drawrot());
                    Draw.z((float)(49.995f - Mathf.sinDeg((float)(m.spin - (float)(90 * i))) / 1000.0f));
                    Draw.rect((TextureRegion)this.barrel, (float)(m.x + v.x), (float)(m.y + v.y), (float)m.drawrot());
                    if (!(m.heats[i] > 0.001f)) continue;
                    Drawf.additive((TextureRegion)this.heat, (Color)MinigunTurret.this.heatColor.write(Tmp.c1).a(m.heats[i]), (float)(m.x + v.x), (float)(m.y + v.y), (float)m.drawrot(), (float)Draw.z());
                }
                Draw.z((float)50.0f);
                super.drawTurret(block, build);
                if (m.speedf() > 1.0E-4f) {
                    Draw.color((Color)m.barColor());
                    Lines.stroke((float)MinigunTurret.this.barStroke);
                    for (i = 0; i < 2; ++i) {
                        v.trns(m.drawrot(), MinigunTurret.this.barX * (float)Mathf.signs[i], MinigunTurret.this.barY).add(m.recoilOffset);
                        Lines.lineAngle((float)(m.x + v.x), (float)(m.y + v.y), (float)m.rotation, (float)(MinigunTurret.this.barLength * Mathf.clamp((float)m.speedf())), (boolean)false);
                    }
                }
            }

            public void drawHeat(Turret block, Turret.TurretBuild build) {
            }
        };
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.reload);
        float minValue = this.minFiringSpeed / 90.0f * 60.0f * (float)this.shoot.shots;
        float maxValue = this.maxSpeed / 90.0f * 60.0f * (float)this.shoot.shots;
        this.stats.add(Stat.reload, PMUtls.stringsFixed(minValue) + " - " + PMUtls.stringsFixed(maxValue) + StatUnit.perSecond.localized(), new Object[0]);
    }

    public void setBars() {
        super.setBars();
        this.addBar("pm-minigun-speed", entity -> new Bar(() -> Core.bundle.format("bar.pm-minigun-speed", new Object[]{PMUtls.stringsFixed(entity.speedf() * 100.0f)}), entity::barColor, entity::speedf));
    }

    public class MinigunTurretBuild
    extends ItemTurret.ItemTurretBuild {
        protected float[] heats;
        protected float spinSpeed;
        protected float spin;

        public MinigunTurretBuild() {
            super((ItemTurret)MinigunTurret.this);
            this.heats = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        }

        public Color barColor() {
            return this.spinSpeed > MinigunTurret.this.minFiringSpeed ? this.team.color : this.team.palette[2];
        }

        public void updateTile() {
            boolean notShooting;
            boolean bl = notShooting = !this.hasAmmo() || !this.isShooting() || !this.isActive();
            if (notShooting) {
                this.spinSpeed = Mathf.approachDelta((float)this.spinSpeed, (float)0.0f, (float)MinigunTurret.this.windDownSpeed);
            }
            if (this.spinSpeed > this.getMaxSpeed()) {
                this.spinSpeed = Mathf.approachDelta((float)this.spinSpeed, (float)this.getMaxSpeed(), (float)MinigunTurret.this.windDownSpeed);
            }
            for (int i = 0; i < 4; ++i) {
                this.heats[i] = Math.max(this.heats[i] - Time.delta / MinigunTurret.this.cooldownTime, 0.0f);
            }
            super.updateTile();
        }

        protected void updateShooting() {
            if (!this.hasAmmo()) {
                return;
            }
            this.spinSpeed = Mathf.approachDelta((float)this.spinSpeed, (float)this.getMaxSpeed(), (float)(MinigunTurret.this.windupSpeed * this.peekAmmo().reloadMultiplier * this.timeScale));
            if (this.reloadCounter >= 90.0f && this.spinSpeed > MinigunTurret.this.minFiringSpeed) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reloadCounter = this.spin % 90.0f;
                this.heats[Mathf.floor((float)(this.spin - 90.0f)) % 360 / 90] = 1.0f;
            }
        }

        protected void updateReload() {
            boolean shooting = this.hasAmmo() && this.isShooting() && this.isActive();
            float multiplier = this.hasAmmo() ? this.peekAmmo().reloadMultiplier : 1.0f;
            float add = this.spinSpeed * multiplier * Time.delta;
            if (shooting && MinigunTurret.this.coolant != null && MinigunTurret.this.coolant.efficiency((Building)this) > 0.0f && this.efficiency > 0.0f) {
                float f;
                ConsumeLiquidBase consumeLiquidBase = MinigunTurret.this.coolant;
                if (consumeLiquidBase instanceof ConsumeLiquidFilter) {
                    ConsumeLiquidFilter filter = (ConsumeLiquidFilter)consumeLiquidBase;
                    f = filter.getConsumed((Building)this).heatCapacity;
                } else {
                    f = 1.0f;
                }
                float capacity = f;
                MinigunTurret.this.coolant.update((Building)this);
                add += MinigunTurret.this.coolant.amount * this.edelta() * capacity * MinigunTurret.this.coolantMultiplier;
                if (Mathf.chance((double)(0.06 * (double)MinigunTurret.this.coolant.amount))) {
                    MinigunTurret.this.coolEffect.at(this.x + Mathf.range((float)((float)(MinigunTurret.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(MinigunTurret.this.size * 8) / 2.0f)));
                }
            }
            this.spin += add;
            this.reloadCounter += add;
        }

        protected float getMaxSpeed() {
            return MinigunTurret.this.maxSpeed * (!this.isControlled() && this.logicControlled() && this.logicShooting ? MinigunTurret.this.logicSpeedScl : 1.0f);
        }

        protected float speedf() {
            return this.spinSpeed / MinigunTurret.this.maxSpeed;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.spinSpeed);
            write.f(this.spin % 360.0f);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 2) {
                this.spinSpeed = read.f();
                if (revision >= 3) {
                    this.spin = read.f();
                }
            }
        }

        public byte version() {
            return 3;
        }
    }
}

