/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.Stat;
import progressed.content.effects.LightningFx;
import progressed.content.effects.OtherFx;
import progressed.entities.LightningEffect;
import progressed.entities.bullet.PillarFieldBulletType;
import progressed.graphics.PMPal;
import progressed.world.meta.PMStatValues;

public class GeomancyTurret
extends PowerTurret {
    public float armX = 4.0f;
    public float armY;
    public int crackEffects = 2;
    public Color crackColor = PMPal.darkBrown;
    public LightningEffect crackEffect = LightningFx.groundCrack;
    public Effect slamEffect = OtherFx.concretionSlam;

    public GeomancyTurret(String name) {
        super(name);
        this.accurateDelay = true;
        this.drawer = new DrawTurret(){
            public final TextureRegion[] armRegions = new TextureRegion[2];
            public final TextureRegion[] armOutlines = new TextureRegion[2];
            public final TextureRegion[] armHeatRegions = new TextureRegion[2];

            public void load(Block block) {
                super.load(block);
                for (int arm : Mathf.zeroOne) {
                    this.armRegions[arm] = Core.atlas.find(block.name + "-arm-" + arm);
                    this.armOutlines[arm] = Core.atlas.find(block.name + "-arm-" + arm + "-outline");
                    this.armHeatRegions[arm] = Core.atlas.find(block.name + "-arm-heat-" + arm);
                }
            }

            public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
                super.getRegionsToOutline(block, out);
                out.add((Object)GeomancyTurret.this.region);
                out.add((Object[])this.armRegions);
            }

            public void draw(Building build) {
                GeomancyTurret turret = (GeomancyTurret)build.block;
                GeomancyTurretBuild tb = (GeomancyTurretBuild)build;
                Draw.rect((TextureRegion)this.base, (float)build.x, (float)build.y);
                Draw.color();
                Draw.z((float)49.98f);
                Drawf.shadow((TextureRegion)GeomancyTurret.this.region, (float)(build.x - turret.elevation), (float)(build.y - turret.elevation), (float)tb.drawrot());
                for (int arm : Mathf.zeroOne) {
                    Tmp.v1.trns(tb.drawrot(), GeomancyTurret.this.armX * (float)Mathf.signs[arm], GeomancyTurret.this.armY - this.armRecoil(tb, arm));
                    Drawf.shadow((TextureRegion)this.armRegions[arm], (float)(build.x + Tmp.v1.x - turret.elevation), (float)(build.y + Tmp.v1.y - turret.elevation), (float)tb.drawrot());
                }
                Draw.z((float)50.0f);
                tb.recoilOffset.setZero();
                this.drawTurret((Turret)turret, (Turret.TurretBuild)tb);
                this.drawHeat((Turret)turret, (Turret.TurretBuild)tb);
                this.drawArms(tb);
            }

            public void drawArms(GeomancyTurretBuild build) {
                for (int arm : Mathf.zeroOne) {
                    Tmp.v1.trns(build.drawrot(), GeomancyTurret.this.armX * (float)Mathf.signs[arm], GeomancyTurret.this.armY - this.armRecoil(build, arm));
                    Draw.z((float)49.99f);
                    Draw.rect((TextureRegion)this.outline, (float)build.x, (float)build.y, (float)build.drawrot());
                    Draw.rect((TextureRegion)this.armOutlines[arm], (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)build.drawrot());
                    Draw.z((float)50.0f);
                    Draw.rect((TextureRegion)this.armRegions[arm], (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)build.drawrot());
                    if (build.armHeat[arm] <= 1.0E-5f || !this.armHeatRegions[arm].found()) continue;
                    Drawf.additive((TextureRegion)this.armHeatRegions[arm], (Color)GeomancyTurret.this.heatColor.write(Tmp.c1).a(build.armHeat[arm]), (float)(build.x + Tmp.v1.x), (float)(build.y + Tmp.v1.y), (float)build.drawrot(), (float)50.1f);
                }
            }

            public float armRecoil(GeomancyTurretBuild b, int side) {
                return Mathf.pow((float)b.armRecoil[side], (float)GeomancyTurret.this.recoilPow) * GeomancyTurret.this.recoil;
            }
        };
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(ObjectMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public class GeomancyTurretBuild
    extends PowerTurret.PowerTurretBuild {
        public Vec2 strikePos;
        public boolean charging;
        public float[] armRecoil;
        public float[] armHeat;

        public GeomancyTurretBuild() {
            super((PowerTurret)GeomancyTurret.this);
            this.strikePos = new Vec2();
            this.armRecoil = new float[2];
            this.armHeat = new float[2];
        }

        public void updateTile() {
            for (int i = 0; i < 2; ++i) {
                this.armRecoil[i] = Math.max(this.armRecoil[i] - Time.delta / GeomancyTurret.this.recoilTime, 0.0f);
                this.armHeat[i] = Math.max(this.armHeat[i] - Time.delta / GeomancyTurret.this.cooldownTime, 0.0f);
            }
            super.updateTile();
        }

        protected void updateShooting() {
            if (!this.charging()) {
                super.updateShooting();
            }
        }

        protected void updateCooling() {
            if (!this.charging()) {
                super.updateCooling();
            }
        }

        public boolean shouldTurn() {
            return true;
        }

        protected void shoot(BulletType type) {
            this.strikePos.set(this.targetPos).sub(this.x, this.y).limit(GeomancyTurret.this.range).add(this.x, this.y);
            GeomancyTurret.this.shoot.shoot(this.totalShots, (xOffset, yOffset, angle, delay, mover) -> {
                Tile t;
                float dst;
                float mdst;
                ++this.queuedBullets;
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> this.bullet(type, this.strikePos.x, this.strikePos.y, angle, mover));
                } else {
                    this.bullet(type, this.strikePos.x, this.strikePos.y, angle, mover);
                }
                ++this.totalShots;
                Tmp.v1.trns(this.rotation - 90.0f, GeomancyTurret.this.armX * (float)Mathf.signs[this.totalShots % 2], GeomancyTurret.this.shootY).add(this.x, this.y);
                if (GeomancyTurret.this.shoot.firstShotDelay > 0.0f && (mdst = (dst = Tmp.v1.dst(this.strikePos)) - ((PillarFieldBulletType)type).radius) > 0.0f) {
                    Tmp.v2.set(Tmp.v1).lerp(this.strikePos, mdst / dst);
                    for (int i = 0; i < GeomancyTurret.this.crackEffects; ++i) {
                        GeomancyTurret.this.crackEffect.at(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y, GeomancyTurret.this.crackColor);
                    }
                }
                if ((t = Vars.world.tileWorld(Tmp.v1.x, Tmp.v1.y)) != null && t.floor() != null) {
                    GeomancyTurret.this.slamEffect.at(Tmp.v1.x, Tmp.v1.y, this.rotation, t.floor().mapColor);
                }
                this.heat = 1.0f;
                this.armHeat[this.totalShots % 2] = 1.0f;
                this.armRecoil[this.totalShots % 2] = 1.0f;
            });
        }

        protected void bullet(BulletType type, float xOffset, float yOffset, float angleOffset, Mover mover) {
            --this.queuedBullets;
            if (this.dead || !GeomancyTurret.this.consumeAmmoOnce && !this.hasAmmo()) {
                return;
            }
            this.handleBullet(type.create((Entityc)this, this.team, xOffset, yOffset, 0.0f), 0.0f, 0.0f, angleOffset);
        }

        public boolean charging() {
            return this.charging;
        }
    }
}

