/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence.turret;

import arc.Core;
import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.OrderedMap;
import arc.util.Time;
import mindustry.entities.bullet.BulletType;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.meta.Stat;
import progressed.util.PMUtls;
import progressed.world.meta.PMStatValues;

public class BlackHoleTurret
extends PowerTurret {
    public BlackHoleTurret(String name) {
        super(name);
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.ammo);
        this.stats.add(Stat.ammo, PMStatValues.ammo(OrderedMap.of((Object[])new Object[]{this, this.shootType})));
    }

    public void setBars() {
        super.setBars();
        this.addBar("pm-reload", entity -> new Bar(() -> Core.bundle.format("bar.pm-reload", new Object[]{PMUtls.stringsFixed(Mathf.clamp((float)(entity.reloadCounter / this.reload)) * 100.0f)}), () -> entity.team.color, () -> Mathf.clamp((float)(entity.reloadCounter / this.reload))));
        this.addBar("pm-charge", entity -> new Bar(() -> Core.bundle.format("bar.pm-charge", new Object[]{PMUtls.stringsFixed(Mathf.clamp((float)entity.charge) * 100.0f)}), () -> Color.navy, () -> entity.charge));
    }

    public class BlackHoleTurretBuild
    extends PowerTurret.PowerTurretBuild {
        public BlackHoleTurretBuild() {
            super((PowerTurret)BlackHoleTurret.this);
        }

        protected void updateReload() {
            if (this.charging()) {
                return;
            }
            super.updateReload();
        }

        protected void updateCooling() {
            if (this.charging()) {
                return;
            }
            super.updateCooling();
        }

        protected void shoot(BulletType type) {
            float bulletX = this.x + Angles.trnsx((float)(this.rotation - 90.0f), (float)BlackHoleTurret.this.shootX, (float)BlackHoleTurret.this.shootY);
            float bulletY = this.y + Angles.trnsy((float)(this.rotation - 90.0f), (float)BlackHoleTurret.this.shootX, (float)BlackHoleTurret.this.shootY);
            if (BlackHoleTurret.this.shoot.firstShotDelay > 0.0f) {
                BlackHoleTurret.this.chargeSound.at(bulletX, bulletY, Mathf.random((float)BlackHoleTurret.this.soundPitchMin, (float)BlackHoleTurret.this.soundPitchMax));
                type.chargeEffect.at(bulletX, bulletY, this.rotation, this.team.color, (Object)this.self());
            }
            BlackHoleTurret.this.shoot.shoot(this.totalShots, (xOffset, yOffset, angle, delay, mover) -> {
                ++this.queuedBullets;
                if (delay > 0.0f) {
                    Time.run((float)delay, () -> this.bullet(type, xOffset, yOffset, angle, mover));
                } else {
                    this.bullet(type, xOffset, yOffset, angle, mover);
                }
                ++this.totalShots;
            }, () -> ++this.barrelCounter);
            if (BlackHoleTurret.this.consumeAmmoOnce) {
                this.useAmmo();
            }
        }
    }
}

