/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.defence;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Intersector;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.ForceProjector;
import progressed.content.effects.Pseudo3DFx;
import progressed.entities.bullet.pseudo3d.ArcBulletType;
import progressed.graphics.draw3d.Perspective;
import progressed.util.PMMathf;
import progressed.util.PMUtls;

public class ShieldProjector
extends ForceProjector {
    public float chargeTime = 900.0f;
    public float shieldCharge = 300.0f;
    public float phaseShieldCharge = 300.0f;
    public float height = 40.0f;
    public float phaseHeightBoost = 40.0f;
    public Effect chargeEffect = Pseudo3DFx.shieldRecharge;
    public Effect breakEffect = Pseudo3DFx.shieldBreak;
    public Effect shrinkEffect = Pseudo3DFx.shieldShrink;

    public ShieldProjector(String name) {
        super(name);
    }

    public void setBars() {
        super.setBars();
        this.removeBar("shield");
        this.addBar("shield", entity -> new Bar(() -> Core.bundle.get("stat.shieldhealth"), () -> entity.team.color, () -> entity.broken ? 0.0f : entity.shieldf()).blink(Color.white));
        this.addBar("charge", entity -> new Bar(() -> Core.bundle.format("bar.pm-charge", new Object[]{PMUtls.stringsFixed(entity.charge / this.chargeTime * 100.0f)}), () -> entity.team.color, () -> entity.charge / this.chargeTime));
    }

    public void init() {
        this.clipSize = Math.max(this.clipSize, PMMathf.cornerDst(this.radius + this.phaseRadiusBoost + 3.0f) * 2.0f);
        super.init();
    }

    protected TextureRegion[] icons() {
        TextureRegion[] textureRegionArray;
        if (this.teamRegion.found()) {
            TextureRegion[] textureRegionArray2 = new TextureRegion[2];
            textureRegionArray2[0] = this.region;
            textureRegionArray = textureRegionArray2;
            textureRegionArray2[1] = this.teamRegions[Team.sharded.id];
        } else {
            TextureRegion[] textureRegionArray3 = new TextureRegion[1];
            textureRegionArray = textureRegionArray3;
            textureRegionArray3[0] = this.region;
        }
        return textureRegionArray;
    }

    public static float[] getShieldCorners(float x, float y, float radius, int sides, float shieldRotation) {
        float[] corners = new float[sides * 2];
        float space = 360.0f / (float)sides;
        for (int i = 0; i < sides; ++i) {
            float a = space * (float)i + shieldRotation;
            corners[i * 2] = x + Angles.trnsx((float)a, (float)radius);
            corners[i * 2 + 1] = y + Angles.trnsy((float)a, (float)radius);
        }
        return corners;
    }

    public static void drawCorners(float[] corners, float height, int sides, CornersDraw draw) {
        for (int i = 0; i < sides; ++i) {
            float x1 = corners[i * 2];
            float y1 = corners[i * 2 + 1];
            int next = (i + 1) % sides;
            float x2 = corners[next * 2];
            float y2 = corners[next * 2 + 1];
            Vec2 pos = Perspective.drawPos(x2, y2, height);
            float x3 = pos.x;
            float y3 = pos.y;
            pos = Perspective.drawPos(x1, y1, height);
            float x4 = pos.x;
            float y4 = pos.y;
            draw.draw(x1, y1, x2, y2, x3, y3, x4, y4);
        }
    }

    public static interface CornersDraw {
        public void draw(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);
    }

    public class ShieldBuild
    extends ForceProjector.ForceBuild {
        public float charge;

        public ShieldBuild() {
            super((ForceProjector)ShieldProjector.this);
        }

        public void onRemoved() {
            float radius = this.realRadius();
            if (!this.broken && radius > 1.0f) {
                ShieldProjector.this.shrinkEffect.at(this.x, this.y, this.realRadius(), this.team.color, (Object)new Pseudo3DFx.ShieldSizeData(ShieldProjector.this.sides, ShieldProjector.this.shieldRotation, this.realHeight()));
            }
        }

        public void updateTile() {
            boolean phaseValid = ShieldProjector.this.itemConsumer != null && ShieldProjector.this.itemConsumer.efficiency((Building)this) > 0.0f;
            this.phaseHeat = Mathf.lerpDelta((float)this.phaseHeat, (float)Mathf.num((boolean)phaseValid), (float)0.1f);
            if (phaseValid && !this.broken && this.timer(ShieldProjector.this.timerUse, ShieldProjector.this.phaseUseTime) && this.efficiency > 0.0f) {
                this.consume();
            }
            this.radscl = Mathf.lerpDelta((float)this.radscl, (float)(this.broken ? 0.0f : this.warmup), (float)0.05f);
            if (Mathf.chanceDelta((double)(this.buildup / ShieldProjector.this.shieldHealth * 0.1f))) {
                Fx.reactorsmoke.at(this.x + Mathf.range((float)4.0f), this.y + Mathf.range((float)4.0f));
            }
            this.warmup = Mathf.lerpDelta((float)this.warmup, (float)this.efficiency, (float)0.1f);
            if (this.buildup > 0.0f) {
                float scale;
                float f = scale = !this.broken ? ShieldProjector.this.cooldownNormal : ShieldProjector.this.cooldownBrokenBase;
                if (ShieldProjector.this.coolantConsumer != null && ShieldProjector.this.coolantConsumer.efficiency((Building)this) > 0.0f) {
                    ShieldProjector.this.coolantConsumer.update((Building)this);
                    scale *= ShieldProjector.this.cooldownLiquid * (1.0f + (this.liquids.current().heatCapacity - 0.4f) * 0.9f);
                }
                if (!this.broken) {
                    this.charge += this.edelta() * scale;
                    if (this.charge >= ShieldProjector.this.chargeTime) {
                        ShieldProjector.this.chargeEffect.at(this.x, this.y, 0.0f, this.team.color, (Object)this.self());
                        this.buildup -= this.realCharge() * this.delta();
                        this.charge %= ShieldProjector.this.chargeTime;
                    }
                } else {
                    this.buildup -= this.delta() * scale;
                }
                float f2 = this.buildup = this.buildup < 0.0f ? 0.0f : this.buildup;
            }
            if (this.broken && this.buildup <= 0.0f) {
                this.broken = false;
            }
            if (this.buildup >= ShieldProjector.this.shieldHealth + ShieldProjector.this.phaseShieldBoost * this.phaseHeat && !this.broken) {
                this.broken = true;
                this.buildup = ShieldProjector.this.shieldHealth;
                ShieldProjector.this.breakEffect.at(this.x, this.y, this.realRadius(), this.team.color, (Object)new Pseudo3DFx.ShieldSizeData(ShieldProjector.this.sides, ShieldProjector.this.shieldRotation, this.realHeight()));
                if (this.team != Vars.state.rules.defaultTeam) {
                    Events.fire((Enum)EventType.Trigger.forceProjectorBreak);
                }
            }
            if (this.hit > 0.0f) {
                this.hit -= 0.2f * Time.delta;
            }
            this.deflectBullets();
        }

        public void deflectBullets() {
            float realRadius = this.realRadius();
            float realHeight = this.realHeight();
            if (realRadius > 0.0f && !this.broken) {
                Groups.bullet.intersect(this.x - realRadius, this.y - realRadius, realRadius * 2.0f, realRadius * 2.0f, b -> {
                    if (b.team != this.team && Intersector.isInRegularPolygon((int)ShieldProjector.this.sides, (float)this.x, (float)this.y, (float)this.realRadius(), (float)ShieldProjector.this.shieldRotation, (float)b.x, (float)b.y)) {
                        BulletType patt6222$temp = b.type;
                        if (patt6222$temp instanceof ArcBulletType) {
                            ArcBulletType a = (ArcBulletType)patt6222$temp;
                            ArcBulletType.ArcBulletData data = (ArcBulletType.ArcBulletData)b.data;
                            if (a.zAbsorbable && data.z <= realHeight) {
                                b.absorb();
                                a.absorbEffect.at(b.x, b.y, data.z, a.absorbEffectColor);
                                this.hit = 1.0f;
                                this.buildup += b.damage;
                            }
                        } else if (b.type.absorbable) {
                            b.absorb();
                            ShieldProjector.this.absorbEffect.at((Position)b);
                            this.hit = 1.0f;
                            this.buildup += b.damage;
                        }
                    }
                });
            }
        }

        public float realHeight() {
            return (ShieldProjector.this.height + this.phaseHeat * ShieldProjector.this.phaseHeightBoost) * this.radscl;
        }

        public float realCharge() {
            return ShieldProjector.this.shieldCharge + this.phaseHeat * ShieldProjector.this.phaseShieldCharge;
        }

        public void drawShield() {
            float radius;
            if (!this.broken && (radius = this.realRadius()) > 0.001f) {
                Draw.color((Color)this.team.color, (Color)Color.white, (float)Mathf.clamp((float)this.hit));
                float[] corners = this.getShieldCorners(radius);
                if (Vars.renderer.animateShields) {
                    Draw.z((float)(125.0f + 0.001f * this.hit));
                } else {
                    Draw.z((float)125.0f);
                    Lines.stroke((float)1.5f);
                    Draw.alpha((float)(0.09f + Mathf.clamp((float)(0.08f * this.hit))));
                }
                Fill.polyBegin();
                this.drawCorners(corners, (x1, y1, x2, y2, x3, y3, x4, y4) -> {
                    Fill.quad((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3, (float)x4, (float)y4);
                    Fill.polyPoint((float)x4, (float)y4);
                });
                Fill.polyEnd();
                if (Vars.renderer.animateShields) {
                    Draw.z((float)126.01f);
                } else {
                    Draw.z((float)125.001f);
                }
                Draw.alpha((float)1.0f);
                this.drawCorners(corners, (x1, y1, x2, y2, x3, y3, x4, y4) -> {
                    Lines.line((float)x1, (float)y1, (float)x2, (float)y2);
                    Lines.line((float)x1, (float)y1, (float)x4, (float)y4);
                    Lines.line((float)x2, (float)y2, (float)x3, (float)y3);
                    Lines.line((float)x4, (float)y4, (float)x3, (float)y3);
                });
                Draw.color();
            }
            Draw.reset();
        }

        public float[] getShieldCorners(float radius) {
            return ShieldProjector.getShieldCorners(this.x, this.y, radius, ShieldProjector.this.sides, ShieldProjector.this.shieldRotation);
        }

        public float[] getShieldCorners() {
            return this.getShieldCorners(this.realRadius());
        }

        public void drawCorners(float[] corners, float height, CornersDraw draw) {
            ShieldProjector.drawCorners(corners, height, ShieldProjector.this.sides, draw);
        }

        public void drawCorners(float[] corners, CornersDraw draw) {
            this.drawCorners(corners, this.realHeight(), draw);
        }

        public float shieldf() {
            return 1.0f - this.buildup / (ShieldProjector.this.shieldHealth + ShieldProjector.this.phaseShieldBoost * this.phaseHeat);
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.charge);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.charge = read.f();
            }
        }

        public byte version() {
            return 1;
        }
    }
}

