/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.crafting;

import arc.Core;
import arc.math.Mathf;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.ui.Bar;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.meta.Attribute;
import progressed.util.PMUtls;
import progressed.world.meta.PMStat;
import progressed.world.meta.PMStatValues;

public class FuelCrafter
extends GenericCrafter {
    public Attribute attribute = Attribute.heat;
    public Item fuelItem;
    public int fuelPerItem = 10;
    public int fuelPerCraft = -1;
    public int fuelCapacity = 30;
    public float fuelUseReduction = 1.5f;

    public FuelCrafter(String name) {
        super(name);
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
        int amount = Math.max(this.fuelPerCraft - Mathf.round((float)(this.sumAttribute(this.attribute, x, y) * this.fuelUseReduction)), 0);
        this.drawPlaceText(Core.bundle.format("bar.pm-fuel-use", new Object[]{amount > 0 ? Integer.valueOf(amount) : Core.bundle.get("bar.pm-fuel-unneeded")}), x, y, valid);
    }

    public void init() {
        if (this.fuelItem == null) {
            PMUtls.uhOhSpeghettiOh(this.name + " doesn't have a fuel item!");
        }
        if (this.fuelPerCraft < 0) {
            this.fuelPerCraft = this.fuelPerItem;
        }
        super.init();
    }

    public void setBars() {
        super.setBars();
        this.addBar("pm-fuel", entity -> new Bar(() -> Core.bundle.format("bar.pm-fuel", new Object[]{entity.fuelNeeded() > 0 ? Integer.valueOf(entity.fuel) : Core.bundle.get("bar.pm-fuel-unneeded"), entity.fuelNeeded() > 0 ? "/" + entity.fuelNeeded() : ""}), () -> this.fuelItem.color, () -> entity.fuelNeeded() > 0 ? (float)entity.fuel / (float)this.fuelCapacity : 1.0f));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(PMStat.fuel, PMStatValues.fuel(this));
    }

    public class FuelCrafterBuild
    extends GenericCrafter.GenericCrafterBuild {
        public int fuel;
        public float attrsum;

        public FuelCrafterBuild() {
            super((GenericCrafter)FuelCrafter.this);
        }

        public boolean shouldConsume() {
            return this.fuel >= this.fuelNeeded() && super.shouldConsume();
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.attrsum = FuelCrafter.this.sumAttribute(FuelCrafter.this.attribute, this.tile.x, this.tile.y);
        }

        public void consume() {
            this.fuel -= this.fuelNeeded();
            super.consume();
        }

        public int fuelNeeded() {
            return Math.max(FuelCrafter.this.fuelPerCraft - Mathf.round((float)(this.attrsum * FuelCrafter.this.fuelUseReduction)), 0);
        }

        public boolean acceptItem(Building source, Item item) {
            return super.acceptItem(source, item) || item == FuelCrafter.this.fuelItem && this.fuel + FuelCrafter.this.fuelPerItem <= FuelCrafter.this.fuelCapacity && (float)this.fuelNeeded() > 0.0f;
        }

        public void handleItem(Building source, Item item) {
            if (item == FuelCrafter.this.fuelItem && this.fuel + FuelCrafter.this.fuelPerItem <= FuelCrafter.this.fuelCapacity && (float)this.fuelNeeded() > 0.0f) {
                this.fuel += FuelCrafter.this.fuelPerItem;
                return;
            }
            super.handleItem(source, item);
        }

        public void write(Writes write) {
            super.write(write);
            write.i(this.fuel);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.fuel = read.i();
        }
    }
}

