/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.crafting;

import arc.Core;
import arc.func.Cons;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.consumers.ConsumeItems;

public class AccelerationCrafter
extends GenericCrafter {
    public float accelerationSpeed = 0.03f;
    public float decelerationSpeed = 0.05f;
    public Interp interp = Interp.smoother;
    public Cons<AcceleratingCrafterBuild> onCraft = tile -> {};

    public AccelerationCrafter(String name) {
        super(name);
    }

    public void setBars() {
        super.setBars();
        this.addBar("craft-speed", entity -> new Bar(() -> Core.bundle.format("bar.pm-craft-speed", new Object[]{Mathf.round((float)(entity.getDisplaySpeed() * 100.0f))}), () -> Pal.surge, entity::getDisplaySpeed));
    }

    public class AcceleratingCrafterBuild
    extends GenericCrafter.GenericCrafterBuild {
        public float speed;
        public float totalActivity;

        public AcceleratingCrafterBuild() {
            super((GenericCrafter)AccelerationCrafter.this);
        }

        public void updateTile() {
            float s = this.getSpeed();
            if (this.hasItems()) {
                this.progress += this.getProgressIncrease(AccelerationCrafter.this.craftTime) * s;
                this.totalProgress += this.delta() * s;
            }
            this.totalActivity += this.delta() * s;
            if (Mathf.chanceDelta((double)(AccelerationCrafter.this.updateEffectChance * s))) {
                AccelerationCrafter.this.updateEffect.at(this.x + Mathf.range((float)((float)AccelerationCrafter.this.size * 4.0f)), this.y + (float)Mathf.range((int)(AccelerationCrafter.this.size * 4)));
            }
            if (this.canConsume()) {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)1.0f, (float)AccelerationCrafter.this.warmupSpeed);
                float e = this.efficiency;
                this.speed = this.speed <= e ? Mathf.approachDelta((float)this.speed, (float)e, (float)(AccelerationCrafter.this.accelerationSpeed * e)) : Mathf.approachDelta((float)this.speed, (float)e, (float)AccelerationCrafter.this.decelerationSpeed);
            } else {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)AccelerationCrafter.this.warmupSpeed);
                this.speed = Mathf.approachDelta((float)this.speed, (float)0.0f, (float)AccelerationCrafter.this.decelerationSpeed);
            }
            if (this.progress >= 1.0f) {
                this.craft();
                AccelerationCrafter.this.onCraft.get((Object)this);
            }
            this.dumpOutputs();
        }

        public float getDisplaySpeed() {
            return this.hasItems() ? this.getSpeed() : 0.0f;
        }

        public float getSpeed() {
            return AccelerationCrafter.this.interp.apply(this.speed);
        }

        public float getProgressIncrease(float baseTime) {
            return 1.0f / baseTime * this.delta();
        }

        public boolean hasItems() {
            ConsumeItems cItems = (ConsumeItems)AccelerationCrafter.this.findConsumer(c -> c instanceof ConsumeItems);
            return cItems == null || cItems.efficiency((Building)this) == 1.0f;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.speed);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.speed = read.f();
        }
    }
}

