/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.LiquidStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;

public class ConsumeLiquidDynamic
extends Consume {
    public final Func<Building, LiquidStack> liquids;

    public <T extends Building> ConsumeLiquidDynamic(Func<T, LiquidStack> liquids) {
        this.liquids = liquids;
    }

    public void apply(Block block) {
        block.hasLiquids = true;
    }

    public void build(Building tile, Table table) {
        LiquidStack[] current = new LiquidStack[]{(LiquidStack)this.liquids.get((Object)tile)};
        table.table(cont -> {
            table.update(() -> {
                if (current[0] != this.liquids.get((Object)tile)) {
                    this.rebuild(tile, (Table)cont);
                    current[0] = (LiquidStack)this.liquids.get((Object)tile);
                }
            });
            this.rebuild(tile, (Table)cont);
        });
    }

    private void rebuild(Building tile, Table table) {
        table.clear();
        LiquidStack stack = (LiquidStack)this.liquids.get((Object)tile);
        if (stack != null) {
            table.add((Element)new ReqImage(stack.liquid.uiIcon, () -> tile.liquids != null && tile.liquids.get(stack.liquid) >= stack.amount)).size(32.0f).top().left();
        }
    }

    public void trigger(Building entity) {
        LiquidStack stack = (LiquidStack)this.liquids.get((Object)entity);
        if (stack != null) {
            entity.liquids.remove(stack.liquid, stack.amount);
        }
    }

    public float efficiency(Building build) {
        LiquidStack l = (LiquidStack)this.liquids.get((Object)build);
        return l != null ? Math.min(build.liquids.get(l.liquid) / (l.amount * build.edelta()), 1.0f) : 1.0f;
    }
}

