/*
 * Decompiled with CFR 0.152.
 */
package progressed.world.blocks;

import arc.func.Cons;
import arc.func.Prov;
import arc.scene.Element;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Tex;
import mindustry.ui.Styles;

public class PMItemSelection {
    private static float scrollPos = 0.0f;

    public static <T extends UnlockableContent> Cell<ScrollPane> buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer) {
        return PMItemSelection.buildTable(table, items, holder, consumer, true, true);
    }

    public static <T extends UnlockableContent> Cell<ScrollPane> buildTable(Table table, Seq<T> items, Prov<T> holder, Cons<T> consumer, boolean closeSelect, boolean returnOriginal) {
        ButtonGroup group = new ButtonGroup();
        group.setMinCheckCount(0);
        Table cont = new Table();
        cont.defaults().size(40.0f).top();
        int i = 0;
        for (UnlockableContent item : items) {
            if (!item.unlockedNow()) continue;
            ImageButton button = (ImageButton)cont.button(Tex.whiteui, Styles.clearTogglei, 24.0f, () -> {
                if (closeSelect) {
                    Vars.control.input.config.hideConfig();
                }
            }).group(group).get();
            button.changed(() -> consumer.get(button.isChecked() ? item : (returnOriginal ? (UnlockableContent)holder.get() : null)));
            button.getStyle().imageUp = new TextureRegionDrawable(item.uiIcon);
            button.update(() -> button.setChecked(holder.get() == item));
            if (i++ % 4 != 3) continue;
            cont.row();
        }
        if (i % 4 != 0) {
            int remaining = 4 - i % 4;
            for (int j = 0; j < remaining; ++j) {
                cont.image(Styles.black6);
            }
        }
        ScrollPane pane = new ScrollPane((Element)cont, Styles.smallPane);
        pane.setScrollingDisabled(true, false);
        pane.setScrollYForce(scrollPos);
        pane.update(() -> {
            scrollPos = pane.getScrollY();
        });
        pane.setOverscroll(false, false);
        return table.add((Element)pane).maxHeight(Scl.scl((float)200.0f)).top().left();
    }
}

