/*
 * Decompiled with CFR 0.152.
 */
package progressed.util;

import arc.Core;
import arc.math.Interp;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.ui.dialogs.SettingsMenuDialog;
import mindustry.world.meta.StatUnit;

public class PMSettings {
    public static void init() {
        Vars.ui.settings.addCategory(Core.bundle.get("setting.pm-title"), "prog-mats-settings-icon", t -> {
            t.pref((SettingsMenuDialog.SettingsTable.Setting)new Separator("pm-graphics-settings"));
            t.sliderPref("pm-sword-opacity", 100, 20, 100, 5, s -> s + "%");
            t.sliderPref("pm-zone-opacity", 100, 0, 100, 5, s -> s + "%");
            t.sliderPref("pm-fov", 30, 10, 90, 5, s -> s + " " + StatUnit.degrees.localized());
            t.checkPref("pm-tesla-range", true);
            t.pref((SettingsMenuDialog.SettingsTable.Setting)new Separator("pm-other-settings"));
            t.checkPref("pm-farting", false, b -> Sounds.wind3.play(Interp.pow2In.apply((float)Core.settings.getInt("sfxvol") / 100.0f) * 5.0f));
        });
    }

    static class Separator
    extends SettingsMenuDialog.SettingsTable.Setting {
        float height;

        public Separator(String name) {
            super(name);
        }

        public Separator(float height) {
            this("");
            this.height = height;
        }

        public void add(SettingsMenuDialog.SettingsTable table) {
            if (this.name.isEmpty()) {
                table.image(Tex.clear).height(this.height).padTop(3.0f);
            } else {
                ((Table)table.table(t -> t.add((CharSequence)this.title).padTop(3.0f)).get()).background(Tex.underline);
            }
            table.row();
        }
    }
}

