/*
 * Decompiled with CFR 0.152.
 */
package progressed.util;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Bezier;
import arc.math.geom.Vec2;
import arc.math.geom.Vector;

public class PMMathf {
    private static final Vec2 bezOut = new Vec2();
    private static final Vec2 p1 = new Vec2();
    private static final Vec2 p2 = new Vec2();
    private static final Vec2 p3 = new Vec2();
    private static final Vec2 p4 = new Vec2();
    private static final Vec2 tmp = new Vec2();

    public static boolean isInSquare(float cx, float cy, float d, float x, float y) {
        return x > cx - d && x < cx + d && y > cy - d && y < cy + d;
    }

    public static float cornerDst(float r) {
        return PMMathf.cornerDst(r, r);
    }

    public static float cornerDst(float w, float h) {
        return (float)Math.sqrt(w * h * 2.0f);
    }

    public static float cbrt(float x) {
        return (float)Math.cbrt(x);
    }

    public static Vec2 quad(float a, float b, float c) {
        Vec2 sol = null;
        if ((double)Math.abs(a) < 1.0E-6) {
            if ((double)Math.abs(b) < 1.0E-6) {
                sol = (double)Math.abs(c) < 1.0E-6 ? tmp.set(0.0f, 0.0f) : null;
            } else {
                tmp.set(-c / b, -c / b);
            }
        } else {
            float disc = b * b - 4.0f * a * c;
            if (disc >= 0.0f) {
                disc = Mathf.sqrt((float)disc);
                a = 2.0f * a;
                sol = tmp.set((-b - disc) / a, (-b + disc) / a);
            }
        }
        return sol;
    }

    public static float quadPos(float a, float b, float c) {
        Vec2 ts = PMMathf.quad(a, b, c);
        if (ts != null) {
            float t0 = ts.x;
            float t1 = ts.y;
            float t = Math.min(t0, t1);
            if (t <= 0.0f) {
                t = Math.max(t0, t1);
            }
            if (t > 0.0f) {
                return t;
            }
        }
        return 0.0f;
    }

    public static float solve(float a, float b, float c) {
        if (a == 0.0f) {
            return -c / b;
        }
        Vec2 t = PMMathf.quad(a, b, c);
        return Math.max(t.x, t.y);
    }

    public static float[] quartic(float a, float b, float c, float d, float e) {
        float p1 = 2.0f * c * c * c - 9.0f * b * c * d + 27.0f * a * d * d + 27.0f * b * b * e - 72.0f * a * c * e;
        float p2 = c * c - 3.0f * b * d + 12.0f * a * e;
        float p3 = p1 + Mathf.sqrt((float)(-4.0f * p2 * p2 * p2 + p1 * p1));
        float p4 = PMMathf.cbrt(p3 / 2.0f);
        float p5 = p2 / (3.0f * a * p4) + p4 / (3.0f * a);
        float p6 = Mathf.sqrt((float)(b * b / (4.0f * a * a) - 2.0f * c / (3.0f * a) + p5));
        float p7 = b * b / (2.0f * a * a) - 4.0f * c / (3.0f * a) - p5;
        float p8 = (-(b * b * b) / (a * a * a) + 4.0f * b * c / (a * a) - 8.0f * d / a) / (4.0f * p6);
        return new float[]{-(b / (4.0f * a)) - p6 / 2.0f - Mathf.sqrt((float)(p7 - p8)) / 2.0f, -(b / (4.0f * a)) - p6 / 2.0f + Mathf.sqrt((float)(p7 - p8)) / 2.0f, -(b / (4.0f * a)) - p6 / 2.0f - Mathf.sqrt((float)(p7 + p8)) / 2.0f, -(b / (4.0f * a)) - p6 / 2.0f + Mathf.sqrt((float)(p7 + p8)) / 2.0f};
    }

    public static Vec2 randomCirclePoint(Vec2 v, float radius) {
        v.setToRandomDirection().setLength(radius * Mathf.sqrt((float)Mathf.random()));
        return v;
    }

    public static float circleStarPoint(float theta) {
        theta = Mathf.mod((float)theta, (float)90.0f);
        float b = -2.0f * Mathf.sqrt2 * Mathf.cos((float)((theta *= (float)Math.PI / 180) - 0.7853982f));
        return (-b - Mathf.sqrt((float)(b * b - 4.0f))) / 2.0f;
    }

    public static int angleMoveDirection(float from, float to) {
        if ((from = Mathf.mod((float)from, (float)360.0f)) > (to = Mathf.mod((float)to, (float)360.0f)) == Angles.backwardDistance((float)from, (float)to) > Angles.forwardDistance((float)from, (float)to)) {
            return -1;
        }
        return 1;
    }

    public static float lerpAngle(float from, float to, float progress) {
        return Angles.moveToward((float)from, (float)to, (float)(progress * Angles.angleDist((float)from, (float)to)));
    }

    public static Vec2 bezier(float t, float x1, float y1, float x2, float y2, Vec2 h1, Vec2 h2) {
        p1.set(x1, y1);
        p4.set(x2, y2);
        p2.set(p1).add(h1);
        p3.set(p4).add(h2);
        Bezier.cubic((Vector)bezOut, (float)t, (Vector)p1, (Vector)p2, (Vector)p3, (Vector)p4, (Vector)tmp);
        return bezOut;
    }

    public static Vec2 bezierDeriv(float t, float x1, float y1, float x2, float y2, Vec2 h1, Vec2 h2) {
        p1.set(x1, y1);
        p4.set(x2, y2);
        p2.set(p1).add(h1);
        p3.set(p4).add(h2);
        Bezier.cubicDerivative((Vector)bezOut, (float)t, (Vector)p1, (Vector)p2, (Vector)p3, (Vector)p4, (Vector)tmp);
        return bezOut;
    }
}

