/*
 * Decompiled with CFR 0.152.
 */
package progressed.util;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Time;
import mindustry.gen.Hitboxc;
import progressed.graphics.draw3d.Fill3D;
import progressed.util.PMMathf;

public class Math3D {
    private static final Vec2 vresult = new Vec2();

    public static Vec3 rotate(Vec3 vec3, float length, float yaw, float yawOffset, float pitch) {
        return vec3.set(Angles.trnsx((float)yawOffset, (float)length), Angles.trnsy((float)yawOffset, (float)length), 0.0f).rotate(Vec3.Y, pitch).rotate(Vec3.Z, -yaw);
    }

    public static Vec2 intercept(float srcx, float srcy, float dstx, float dsty, float dstvx, float dstvy, float ba, float bv) {
        float dx = dstx - srcx;
        float dy = dsty - srcy;
        float uv = (dstvx /= Time.delta) * dstvx + (dstvy /= Time.delta) * dstvy;
        float ud = dx * dstvx + dy * dstvy;
        float a = -(ba * ba) / 4.0f;
        float b = -ba * bv;
        float c = uv - bv * bv;
        float d = 2.0f * ud;
        float e = dx * dx + dy * dy;
        float[] ts = PMMathf.quartic(a, b, c, d, e);
        Vec2 sol = vresult.set(dstx, dsty);
        float min = Float.MAX_VALUE;
        for (float t : ts) {
            if (!(t >= 0.0f) || !(t < min)) continue;
            min = t;
        }
        if (min < Float.MAX_VALUE) {
            sol.set(dstx + dstvx * min, dsty + dstvy * min);
        }
        return sol;
    }

    public static Vec2 intercept(Position src, Position dst, float ba, float bv) {
        Hitboxc h;
        float ddx = 0.0f;
        float ddy = 0.0f;
        if (dst instanceof Hitboxc) {
            h = (Hitboxc)dst;
            ddx += h.deltaX();
            ddy += h.deltaY();
        }
        if (src instanceof Hitboxc) {
            h = (Hitboxc)src;
            ddx -= h.deltaX();
            ddy -= h.deltaY();
        }
        if (ddx == 0.0f && ddy == 0.0f) {
            return vresult.set(dst);
        }
        return Math3D.intercept(src.getX(), src.getY(), dst.getX(), dst.getY(), ddx, ddy, ba, bv);
    }

    public static Vec2 inaccuracy(float inaccuracy) {
        PMMathf.randomCirclePoint(Fill3D.vec, inaccuracy);
        return Fill3D.vec;
    }

    public static float homingPitch(float x1, float y1, float z1, float x2, float y2, float v2, float a, float g) {
        float dst = Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2);
        float p1 = 2.0f * g * z1;
        float p2 = 2.0f * a * dst;
        float p3 = -a * z1 - g * dst;
        float p4 = (p3 * p3 - p1 * p2) / v2;
        float A = p2 - p1;
        float B = p3;
        float C = p4 - p1;
        float D = (float)Mathf.sign((float)B) * Mathf.sqrt((float)(0.25f * A * A + B * B));
        float E = (float)Math.atan(0.5f * A / B) / 2.0f;
        return (float)(-Math.asin((C - 0.5f * A) / D)) / 2.0f - E;
    }

    public static float dst(float x, float y, float z) {
        return Mathf.sqrt((float)(x * x + y * y + z * z));
    }

    public static float dst(float x1, float y1, float z1, float x2, float y2, float z2) {
        float xd = x2 - x1;
        float yd = y2 - y1;
        float zd = z2 - z1;
        return Mathf.sqrt((float)(xd * xd + yd * yd + zd * zd));
    }
}

