/*
 * Decompiled with CFR 0.152.
 */
package progressed.ui;

import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.SnapshotSeq;

public class ShiftedStack
extends WidgetGroup {
    private float prefWidth;
    private float prefHeight;
    private float minWidth;
    private float minHeight;
    private boolean sizeInvalid = true;
    protected float stackX;
    protected float stackY;

    public ShiftedStack() {
        this.setTransform(false);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.touchable = Touchable.childrenOnly;
    }

    public ShiftedStack(Element ... actors) {
        this();
        for (Element actor : actors) {
            this.addChild(actor);
        }
    }

    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = 0.0f;
        this.prefHeight = 0.0f;
        this.minWidth = 0.0f;
        this.minHeight = 0.0f;
        SnapshotSeq children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            Element child = (Element)children.get(i);
            if (child != null) {
                this.prefWidth = Math.max(this.prefWidth, child.getPrefWidth());
                this.prefHeight = Math.max(this.prefHeight, child.getPrefHeight());
                this.minWidth = Math.max(this.minWidth, child.getMinWidth());
                this.minHeight = Math.max(this.minHeight, child.getMinHeight());
                continue;
            }
            this.prefWidth = Math.max(this.prefWidth, child.getWidth());
            this.prefHeight = Math.max(this.prefHeight, child.getHeight());
            this.minWidth = Math.max(this.minWidth, child.getWidth());
            this.minHeight = Math.max(this.minHeight, child.getHeight());
        }
    }

    public void add(Element actor) {
        this.addChild(actor);
    }

    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        SnapshotSeq children = this.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            Element child = (Element)children.get(i);
            float x = i == 0 ? 0.0f : Scl.scl((float)this.stackX) + (this.getWidth() - child.getWidth()) / 2.0f;
            float y = i == 0 ? 0.0f : Scl.scl((float)this.stackY) + (this.getHeight() - child.getHeight()) / 2.0f;
            child.setPosition(x, y);
            if (child == null) continue;
            child.validate();
        }
    }

    public void setStackPos(float x, float y) {
        this.stackX = x;
        this.stackY = y;
    }

    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    public float getMinWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minWidth;
    }

    public float getMinHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.minHeight;
    }
}

