/*
 * Decompiled with CFR 0.152.
 */
package progressed.ui;

import arc.graphics.Color;
import arc.scene.Element;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.type.Liquid;
import mindustry.ui.Styles;
import mindustry.world.meta.StatUnit;

public class NamelessLiquidDisplay
extends Table {
    public final Liquid liquid;
    public final float amount;
    public final boolean perSecond;

    public NamelessLiquidDisplay(final Liquid liquid, final float amount, boolean perSecond) {
        this.liquid = liquid;
        this.amount = amount;
        this.perSecond = perSecond;
        this.add((Element)new Stack(){
            {
                this.add((Element)new Image(liquid.uiIcon).setScaling(Scaling.fit));
                if (amount != 0.0f) {
                    Table t = new Table().left().bottom();
                    t.add((CharSequence)Strings.autoFixed((float)amount, (int)2)).style((Style)Styles.outlineLabel);
                    this.add((Element)t);
                }
            }
        }).size(32.0f).padRight((float)(3 + (amount != 0.0f && Strings.autoFixed((float)amount, (int)2).length() > 2 ? 8 : 0)));
        if (perSecond) {
            this.add(StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).color(Color.lightGray).style((Style)Styles.outlineLabel);
        }
    }
}

