/*
 * Decompiled with CFR 0.152.
 */
package progressed.type.weapons;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.Weapon;
import progressed.graphics.PMDrawf;

public class RocketWeapon
extends Weapon {
    public RocketWeapon(String name) {
        super(name);
        this.mountType = RocketMount::new;
        this.rotate = true;
        this.shootY = 0.0f;
        this.shootX = 0.0f;
        this.velocityRnd = 0.0f;
        this.inaccuracy = 0.0f;
    }

    public void update(Unit unit, WeaponMount mount) {
        super.update(unit, mount);
        RocketMount rMount = (RocketMount)mount;
        if (this.loadf(mount) < 0.99f) {
            rMount.total += Time.delta * unit.reloadMultiplier;
        }
        rMount.warmup = Mathf.lerpDelta((float)rMount.warmup, (float)Mathf.num(((double)(mount.reload / this.reload) > 0.001 ? 1 : 0) != 0), (float)0.15f);
    }

    public void drawOutline(Unit unit, WeaponMount mount) {
        RocketMount rMount = (RocketMount)mount;
        float rotation = unit.rotation - 90.0f;
        float weaponRotation = rotation + (this.rotate ? mount.rotation : 0.0f);
        float wx = unit.x + Angles.trnsx((float)rotation, (float)this.x, (float)this.y) + Angles.trnsx((float)weaponRotation, (float)0.0f, (float)(-mount.recoil));
        float wy = unit.y + Angles.trnsy((float)rotation, (float)this.x, (float)this.y) + Angles.trnsy((float)weaponRotation, (float)0.0f, (float)(-mount.recoil));
        if (rMount.warmup > 0.01f || this.loadf(mount) > 0.01f) {
            if (this.outlineRegion.found() && !this.top) {
                Draw.draw((float)Draw.z(), () -> PMDrawf.vertConstruct(wx, wy, this.outlineRegion, weaponRotation, this.loadf(mount), rMount.warmup, rMount.total));
            }
        } else if (this.outlineRegion.found()) {
            Draw.rect((TextureRegion)this.outlineRegion, (float)wx, (float)wy, (float)((float)this.outlineRegion.width * Draw.scl * (float)(-Mathf.sign((boolean)this.flipSprite))), (float)((float)this.region.height * Draw.scl), (float)weaponRotation);
        }
    }

    public void draw(Unit unit, WeaponMount mount) {
        RocketMount rMount = (RocketMount)mount;
        float z = Draw.z();
        Draw.z((float)(z + this.layerOffset));
        float rotation = unit.rotation - 90.0f;
        float weaponRotation = rotation + (this.rotate ? mount.rotation : 0.0f);
        float wx = unit.x + Angles.trnsx((float)rotation, (float)this.x, (float)this.y);
        float wy = unit.y + Angles.trnsy((float)rotation, (float)this.x, (float)this.y);
        if (this.shadow > 0.0f) {
            Drawf.shadow((float)wx, (float)wy, (float)this.shadow, (float)(1.0f - this.loadf(mount)));
        }
        if (rMount.warmup > 0.01f || this.loadf(mount) > 0.01f) {
            Draw.draw((float)Draw.z(), () -> {
                if (this.outlineRegion.found() && this.top) {
                    PMDrawf.vertConstruct(wx, wy, this.outlineRegion, weaponRotation, this.loadf(mount), rMount.warmup, rMount.total);
                }
                PMDrawf.vertConstruct(wx, wy, this.region, weaponRotation, this.loadf(mount), rMount.warmup, rMount.total);
            });
        } else {
            if (this.outlineRegion.found() && this.top) {
                Draw.rect((TextureRegion)this.outlineRegion, (float)wx, (float)wy, (float)((float)this.outlineRegion.width * Draw.scl * (float)(-Mathf.sign((boolean)this.flipSprite))), (float)((float)this.region.height * Draw.scl), (float)weaponRotation);
            }
            Draw.rect((TextureRegion)this.region, (float)wx, (float)wy, (float)((float)this.region.width * Draw.scl * (float)(-Mathf.sign((boolean)this.flipSprite))), (float)((float)this.region.height * Draw.scl), (float)weaponRotation);
        }
        Draw.z((float)z);
    }

    public float loadf(WeaponMount mount) {
        return 1.0f - mount.reload / this.reload;
    }

    public static class RocketMount
    extends WeaponMount {
        float total;
        float warmup;

        public RocketMount(Weapon weapon) {
            super(weapon);
        }
    }
}

