/*
 * Decompiled with CFR 0.152.
 */
package progressed.type.weapons;

import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.ai.types.MissileAI;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.units.UnitController;
import mindustry.entities.units.WeaponMount;
import mindustry.gen.Entityc;
import mindustry.gen.Unit;
import mindustry.type.Weapon;

public class MissileOwnerWeapon
extends Weapon {
    protected void bullet(Unit unit, WeaponMount mount, float xOffset, float yOffset, float angleOffset, Mover mover) {
        Unit unit2;
        if (!unit.isAdded()) {
            return;
        }
        mount.charging = false;
        float xSpread = Mathf.range((float)this.xRand);
        float weaponRotation = unit.rotation - 90.0f + (this.rotate ? mount.rotation : this.baseRotation);
        float mountX = unit.x + Angles.trnsx((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        float mountY = unit.y + Angles.trnsy((float)(unit.rotation - 90.0f), (float)this.x, (float)this.y);
        float bulletX = mountX + Angles.trnsx((float)weaponRotation, (float)(this.shootX + xOffset + xSpread), (float)(this.shootY + yOffset));
        float bulletY = mountY + Angles.trnsy((float)weaponRotation, (float)(this.shootX + xOffset + xSpread), (float)(this.shootY + yOffset));
        float shootAngle = this.bulletRotation(unit, mount, bulletX, bulletY) + angleOffset;
        float lifeScl = this.bullet.scaleLife ? Mathf.clamp((float)(Mathf.dst((float)bulletX, (float)bulletY, (float)mount.aimX, (float)mount.aimY) / this.bullet.range)) : 1.0f;
        float angle = angleOffset + shootAngle + Mathf.range((float)(this.inaccuracy + this.bullet.inaccuracy));
        UnitController unitController = unit.controller();
        if (unitController instanceof MissileAI) {
            MissileAI ai = (MissileAI)unitController;
            unit2 = ai.shooter;
        } else {
            unit2 = unit;
        }
        Unit owner = unit2;
        mount.bullet = this.bullet.create((Entityc)owner, unit.team, bulletX, bulletY, angle, -1.0f, 1.0f - this.velocityRnd + Mathf.random((float)this.velocityRnd), lifeScl, null, mover, mount.aimX, mount.aimY);
        this.handleBullet(unit, mount, mount.bullet);
        if (owner != unit && this.bullet.killShooter && !unit.dead()) {
            unit.kill();
        }
        if (!this.continuous) {
            this.shootSound.at(bulletX, bulletY, Mathf.random((float)this.soundPitchMin, (float)this.soundPitchMax));
        }
        this.ejectEffect.at(mountX, mountY, angle * (float)Mathf.sign((float)this.x));
        this.bullet.shootEffect.at(bulletX, bulletY, angle, this.bullet.hitColor, (Object)unit);
        this.bullet.smokeEffect.at(bulletX, bulletY, angle, this.bullet.hitColor, (Object)unit);
        unit.vel.add(Tmp.v1.trns(shootAngle + 180.0f, this.bullet.recoil));
        Effect.shake((float)this.shake, (float)this.shake, (float)bulletX, (float)bulletY);
        mount.recoil = 1.0f;
        mount.heat = 1.0f;
    }
}

