/*
 * Decompiled with CFR 0.152.
 */
package progressed.type.unit;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.world.meta.Stat;
import progressed.ai.EmptyAI;
import progressed.content.effects.OtherFx;
import progressed.gen.entities.SignalFlareUnitc;
import progressed.util.PMUtls;
import progressed.world.meta.PMStatValues;

public class SignalFlareUnitType
extends UnitType {
    public Effect flareEffect = OtherFx.flare;
    public float flareX;
    public float flareY;
    public float flareEffectChance = 0.5f;
    public float flareEffectSize = 1.0f;
    public float growSpeed = 0.05f;
    public float shadowSize = -1.0f;
    public float attraction;

    public SignalFlareUnitType(String name, float lifetime) {
        super(name);
        this.lifetime = lifetime;
        this.aiController = EmptyAI::new;
        this.hidden = true;
        this.drag = 1.0f;
        this.accel = 0.0f;
        this.speed = 0.0f;
        this.isEnemy = false;
        this.canDrown = false;
        this.flying = false;
        this.fallSpeed = 0.033333335f;
        this.hitSize = 1.0f;
        this.deathExplosionEffect = null;
    }

    public SignalFlareUnitType(String name) {
        this(name, 300.0f);
    }

    public void init() {
        super.init();
        if (this.shadowSize < 0.0f) {
            this.shadowSize = this.hitSize * 2.0f;
        }
        if (this.deathExplosionEffect == null) {
            this.deathExplosionEffect = OtherFx.flareFallEffect(this);
        }
    }

    public void drawShadow(Unit unit) {
    }

    public void drawSoftShadow(float x, float y, float rotation, float alpha) {
        Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.4f * alpha));
        float rad = 1.6f;
        float size = this.shadowSize * this.region.scl();
        Draw.rect((TextureRegion)this.softShadowRegion, (float)x, (float)y, (float)(size * rad * Draw.xscl), (float)(size * rad * Draw.yscl), (float)(rotation - 90.0f));
        Draw.color();
    }

    public void drawOutline(Unit unit) {
        Draw.reset();
        if (Core.atlas.isFound(this.outlineRegion)) {
            SignalFlareUnitc flare = (SignalFlareUnitc)unit;
            Draw.rect((TextureRegion)this.outlineRegion, (float)unit.x, (float)unit.y, (float)((float)this.outlineRegion.width / 4.0f), (float)((float)this.outlineRegion.height / 4.0f * flare.height()), (float)(unit.rotation - 90.0f));
            Draw.reset();
        }
    }

    public void drawBody(Unit unit) {
        this.applyColor(unit);
        SignalFlareUnitc flare = (SignalFlareUnitc)unit;
        Draw.rect((TextureRegion)this.region, (float)unit.x, (float)unit.y, (float)((float)this.region.width / 4.0f), (float)((float)this.region.height / 4.0f * flare.height()), (float)(unit.rotation - 90.0f));
        Draw.reset();
    }

    public void drawCell(Unit unit) {
        this.applyColor(unit);
        SignalFlareUnitc flare = (SignalFlareUnitc)unit;
        Draw.color((Color)this.cellColor(unit));
        Draw.rect((TextureRegion)this.cellRegion, (float)unit.x, (float)unit.y, (float)((float)this.cellRegion.width / 4.0f), (float)((float)this.cellRegion.height / 4.0f * flare.height()), (float)(unit.rotation - 90.0f));
        Draw.reset();
    }

    public Color cellColor(Unit unit) {
        float f = ((SignalFlareUnitc)unit).fout();
        float min = 0.5f;
        return super.cellColor(unit).mul(min + (1.0f - min) * f);
    }

    public Unit create(Team team) {
        Unit unit = super.create(team);
        unit.health = this.health;
        unit.maxHealth = this.attraction;
        unit.rotation = 90.0f;
        ((SignalFlareUnitc)unit).lifetime(this.lifetime);
        return unit;
    }

    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.flying);
        this.stats.remove(Stat.speed);
        this.stats.remove(Stat.canBoost);
        this.stats.remove(Stat.itemCapacity);
        this.stats.remove(Stat.range);
        this.stats.remove(Stat.health);
        this.stats.add(Stat.health, PMStatValues.signalFlareHealth(this.health, this.attraction, this.lifetime));
    }

    public void display(Unit unit, Table table) {
        table.table(t -> {
            t.left();
            t.add((Element)new Image(this.fullIcon)).size(32.0f).scaling(Scaling.fit);
            t.labelWrap(this.localizedName).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
        table.row();
        table.table(bars -> {
            bars.defaults().growX().height(20.0f).pad(4.0f);
            bars.add((Element)new Bar("stat.health", Pal.health, () -> ((Unit)unit).healthf()).blink(Color.white));
            bars.row();
            SignalFlareUnitc flare = (SignalFlareUnitc)unit;
            bars.add((Element)new Bar(() -> Core.bundle.format("bar.pm-lifetime", new Object[]{PMUtls.stringsFixed(flare.fout() * 100.0f)}), () -> Pal.accent, () -> ((SignalFlareUnitc)flare).fout()));
            bars.row();
        }).growX();
    }
}

