/*
 * Decompiled with CFR 0.152.
 */
package progressed.type.unit;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.type.unit.ErekirUnitType;
import mindustry.ui.Bar;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import progressed.ai.SentryAI;
import progressed.gen.entities.SentryUnit;
import progressed.util.PMUtls;
import progressed.world.meta.PMStat;

public class SentryUnitType
extends ErekirUnitType {
    public float startElevation = 0.5f;
    public float riseSpeed = -1.0f;
    public float anchorDrag = 0.15f;
    public float pullScale = 0.01f;
    public float anchorPullScale = 0.003f;
    public boolean anchorOver = true;
    public TextureRegion anchorRegion;
    public TextureRegion anchorOutlineRegion;
    public TextureRegion anchorCellRegion;
    public TextureRegion tetherRegion;
    public TextureRegion tetherEndRegion;

    public SentryUnitType(String name) {
        super(name);
        this.aiController = SentryAI::new;
        this.accel = 0.0f;
        this.speed = 0.0f;
        this.drag = 0.1f;
        this.flying = true;
        this.isEnemy = false;
        this.useUnitCap = false;
        this.hittable = false;
        this.vulnerableWithPayloads = false;
        this.targetable = false;
        this.itemCapacity = 10;
        this.health = 200.0f;
        this.engineSize = -1.0f;
    }

    public void init() {
        super.init();
        if (this.riseSpeed < 0.0f) {
            this.riseSpeed = (1.0f - this.startElevation) * 0.125f;
        }
    }

    public void load() {
        super.load();
        this.anchorRegion = Core.atlas.find(this.name + "-anchor");
        this.anchorOutlineRegion = Core.atlas.find(this.name + "-anchor-outline");
        this.anchorCellRegion = Core.atlas.find(this.name + "-anchor-cell");
        this.tetherRegion = Core.atlas.find(this.name + "-tether", "prog-mats-sentry-tether");
        this.tetherEndRegion = Core.atlas.find(this.name + "-tether-end", "prog-mats-sentry-tether-end");
    }

    public void getRegionsToOutline(Seq<TextureRegion> out) {
        super.getRegionsToOutline(out);
        out.add((Object)this.anchorRegion);
    }

    public void drawOutline(Unit unit) {
        super.drawOutline(unit);
        SentryUnit sentry = (SentryUnit)unit;
        float z = Draw.z();
        Draw.z((float)(z + (this.anchorOver ? 0.5f : -0.5f)));
        if (this.anchorOver) {
            Draw.color((Color)unit.team.color);
            Drawf.laser((TextureRegion)this.tetherRegion, (TextureRegion)this.tetherEndRegion, (float)sentry.anchorX, (float)sentry.anchorY, (float)unit.x, (float)unit.y);
            Draw.color();
        }
        Drawf.spinSprite((TextureRegion)this.anchorOutlineRegion, (float)sentry.anchorX, (float)sentry.anchorY, (float)sentry.anchorRot);
        Draw.z((float)z);
    }

    public void drawBody(Unit unit) {
        super.drawBody(unit);
        SentryUnit sentry = (SentryUnit)unit;
        float z = Draw.z();
        Draw.z((float)(z + (this.anchorOver ? 0.5f : -0.5f)));
        Drawf.spinSprite((TextureRegion)this.anchorRegion, (float)sentry.anchorX, (float)sentry.anchorY, (float)sentry.anchorRot);
        if (!this.anchorOver) {
            Draw.color((Color)unit.team.color);
            Drawf.laser((TextureRegion)this.tetherRegion, (TextureRegion)this.tetherEndRegion, (float)sentry.anchorX, (float)sentry.anchorY, (float)unit.x, (float)unit.y);
            Draw.color();
        }
        Draw.z((float)z);
    }

    public void drawCell(Unit unit) {
        super.drawCell(unit);
        SentryUnit sentry = (SentryUnit)unit;
        float z = Draw.z();
        Draw.z((float)(z + (this.anchorOver ? 0.5f : -0.5f)));
        this.applyColor(unit);
        Draw.color((Color)this.cellColor(unit));
        Drawf.spinSprite((TextureRegion)this.anchorCellRegion, (float)sentry.anchorX, (float)sentry.anchorY, (float)sentry.anchorRot);
        Draw.reset();
        Draw.z((float)z);
    }

    public Color cellColor(Unit unit) {
        float f = ((SentryUnit)unit).fout();
        float min = 0.5f;
        return super.cellColor(unit).mul(min + (1.0f - min) * f);
    }

    public void update(Unit unit) {
        if (unit.elevation < 1.0f && !unit.dead && unit.health > 0.0f) {
            unit.elevation = Mathf.clamp((float)(unit.elevation + this.riseSpeed * Time.delta));
        }
        if (unit.health == Float.POSITIVE_INFINITY) {
            ((SentryUnit)unit).time = 0.0f;
        }
        super.update(unit);
    }

    public Unit create(Team team) {
        Unit unit = super.create(team);
        unit.elevation = this.startElevation;
        unit.health = unit.maxHealth;
        return unit;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(PMStat.sentryLifetime, (float)((int)(this.lifetime / 60.0f)), StatUnit.seconds);
        this.stats.remove(Stat.speed);
        this.stats.remove(Stat.itemCapacity);
    }

    public void display(Unit unit, Table table) {
        table.table(t -> {
            t.left();
            t.add((Element)new Image(this.fullIcon)).size(32.0f).scaling(Scaling.fit);
            t.labelWrap(this.localizedName).left().width(190.0f).padLeft(5.0f);
        }).growX().left();
        table.row();
        table.table(bars -> {
            bars.defaults().growX().height(20.0f).pad(4.0f);
            bars.add((Element)new Bar("stat.health", Pal.health, () -> ((Unit)unit).healthf()).blink(Color.white));
            bars.row();
            SentryUnit sentry = (SentryUnit)unit;
            bars.add((Element)new Bar(() -> Core.bundle.format("bar.pm-lifetime", new Object[]{PMUtls.stringsFixed(sentry.fout() * 100.0f)}), () -> Pal.accent, () -> ((SentryUnit)sentry).fout()));
            bars.row();
            for (Ability ability : unit.abilities) {
                ability.displayBars(unit, bars);
            }
        }).growX();
        if (unit.controller() instanceof LogicAI) {
            table.row();
            table.add((CharSequence)(Blocks.microProcessor.emoji() + " " + Core.bundle.get("units.processorcontrol"))).growX().wrap().left();
            table.row();
            table.label(() -> "\ue87c " + (long)unit.flag + "").color(Color.lightGray).growX().wrap().left();
        }
        table.row();
    }

    public static class AnchorEngine
    extends UnitType.UnitEngine {
        public AnchorEngine(float x, float y, float radius, float rotation) {
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.rotation = rotation;
        }

        public AnchorEngine() {
        }

        public void draw(Unit unit) {
            float scale;
            SentryUnit sentry = (SentryUnit)unit;
            SentryUnitType type = (SentryUnitType)unit.type;
            float f = scale = type.useEngineElevation ? unit.elevation : 1.0f;
            if (scale <= 1.0E-4f) {
                return;
            }
            float rot = sentry.anchorRot - 90.0f;
            Color color = type.engineColor == null ? unit.team.color : type.engineColor;
            Tmp.v1.set(this.x, this.y).rotate(rot);
            float ex = Tmp.v1.x;
            float ey = Tmp.v1.y;
            float rad = (this.radius + Mathf.absin((float)Time.time, (float)2.0f, (float)(this.radius / 4.0f))) * scale;
            float z = Draw.z();
            Draw.z((float)(z + (type.anchorOver ? 0.5f : -0.5f)));
            Draw.color((Color)color);
            Fill.circle((float)(sentry.anchorX + ex), (float)(sentry.anchorY + ey), (float)rad);
            Draw.color((Color)type.engineColorInner);
            Fill.circle((float)(sentry.anchorX + ex - Angles.trnsx((float)(rot + this.rotation), (float)(rad / 4.0f))), (float)(sentry.anchorY + ey - Angles.trnsy((float)(rot + this.rotation), (float)(rad / 4.0f))), (float)(rad / 2.0f));
            Draw.z((float)z);
        }
    }
}

