/*
 * Decompiled with CFR 0.152.
 */
package progressed.type.unit;

import arc.graphics.Color;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.abilities.MoveEffectAbility;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WaveEffect;
import mindustry.game.Team;
import mindustry.gen.Sounds;
import mindustry.gen.TimedKillUnit;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.unit.MissileUnitType;
import progressed.ai.DelayMissileAI;
import progressed.content.effects.MissileFx;

public class RocketUnitType
extends MissileUnitType {
    public static final Effect rocketShoot = new MultiEffect(new Effect[]{Fx.massiveExplosion, Fx.scatheExplosion, Fx.scatheLight, new WaveEffect(){
        {
            this.lifetime = 10.0f;
            this.strokeFrom = 4.0f;
            this.sizeTo = 130.0f;
        }
    }});
    public float targetDelay = 0.0f;

    public RocketUnitType(String name, boolean addSmokeTrail) {
        super(name);
        this.speed = 8.0f;
        this.maxRange = 6.0f;
        this.lifetime = 186.0f;
        this.controller = u -> new DelayMissileAI();
        this.engineLayer = 110.0f;
        this.engineSize = 3.1f;
        this.engineOffset = 10.0f;
        this.rotateSpeed = 0.5f;
        this.trailLength = 18;
        this.missileAccelTime = 120.0f;
        this.lowAltitude = true;
        this.outlineColor = Pal.darkerMetal;
        this.loopSound = Sounds.missileTrail;
        this.loopSoundVolume = 0.6f;
        this.deathSound = Sounds.largeExplosion;
        this.fogRadius = 6.0f;
        this.health = 210.0f;
        if (addSmokeTrail) {
            this.abilities.add((Object)new MoveEffectAbility(){
                {
                    this.effect = MissileFx.rocketTrailSmoke;
                    this.rotateEffect = true;
                    this.y = -9.0f;
                    this.color = Color.grays((float)0.6f).lerp(Pal.redLight, 0.5f).a(0.4f);
                    this.interval = 4.0f;
                }
            });
        }
    }

    public boolean targetable(Unit unit, Team targeter) {
        return super.targetable(unit, targeter) && ((TimedKillUnit)unit).time >= this.targetDelay;
    }

    public boolean hittable(Unit unit) {
        return super.hittable(unit) && ((TimedKillUnit)unit).time >= this.targetDelay;
    }
}

