/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.trails;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Time;

public class DriftTrail {
    public int length;
    private final Seq<DriftTrailData> points;
    private float lastX = -1.0f;
    private float lastY = -1.0f;
    private float lastAngle = -1.0f;
    private float lastW = 0.0f;
    private float counter = 0.0f;

    public DriftTrail(int length) {
        this.length = length;
        this.points = new Seq(length);
    }

    public DriftTrail copy() {
        DriftTrail out = new DriftTrail(this.length);
        out.points.addAll(this.points);
        out.lastX = this.lastX;
        out.lastY = this.lastY;
        out.lastAngle = this.lastAngle;
        return out;
    }

    public void clear() {
        this.points.clear();
    }

    public int size() {
        return this.points.size;
    }

    public void drawCap(Color color, float width) {
        if (this.points.size > 0) {
            Draw.color((Color)color);
            DriftTrailData d = (DriftTrailData)this.points.peek();
            float x1 = d.x;
            float y1 = d.y;
            float w1 = d.w;
            float w = w1 * width / (float)this.points.size * (float)(this.points.size - 1) * 2.0f;
            if (w1 <= 0.001f) {
                return;
            }
            Draw.rect((String)"hcircle", (float)x1, (float)y1, (float)w, (float)w, (float)(-57.295776f * this.lastAngle + 180.0f));
            Draw.reset();
        }
    }

    public void draw(Color color, float width) {
        Draw.color((Color)color);
        float lastAngle = this.lastAngle;
        float size = width / (float)this.points.size;
        for (int i = 0; i < this.points.size - 1; ++i) {
            float z1;
            float w2;
            float y2;
            float x2;
            DriftTrailData d1 = (DriftTrailData)this.points.get(i);
            DriftTrailData d2 = (DriftTrailData)this.points.get(i + 1);
            float x1 = d1.x;
            float y1 = d1.y;
            float w1 = d1.w;
            if (i < this.points.size) {
                x2 = d2.x;
                y2 = d2.y;
                w2 = d2.w;
            } else {
                x2 = this.lastX;
                y2 = this.lastY;
                w2 = this.lastW;
            }
            float z2 = -Angles.angleRad((float)x1, (float)y1, (float)x2, (float)y2);
            float f = z1 = i == 0 ? z2 : lastAngle;
            if (w1 <= 0.001f || w2 <= 0.001f) continue;
            float cx = Mathf.sin((float)z1) * (float)i * size * w1;
            float cy = Mathf.cos((float)z1) * (float)i * size * w1;
            float nx = Mathf.sin((float)z2) * (float)(i + 1) * size * w2;
            float ny = Mathf.cos((float)z2) * (float)(i + 1) * size * w2;
            Fill.quad((float)(x1 - cx), (float)(y1 - cy), (float)(x1 + cx), (float)(y1 + cy), (float)(x2 + nx), (float)(y2 + ny), (float)(x2 - nx), (float)(y2 - ny));
            lastAngle = z2;
        }
        Draw.reset();
    }

    public void shorten() {
        float f;
        this.counter += Time.delta;
        if (f >= 0.99f) {
            if (this.points.size >= 1) {
                this.points.remove(0);
            }
            this.counter = 0.0f;
        }
    }

    public void drift() {
        this.points.each(DriftTrailData::drift);
        if (this.points.size > 2) {
            this.lastAngle = -Angles.angleRad((float)((DriftTrailData)this.points.peek()).x, (float)((DriftTrailData)this.points.peek()).y, (float)((DriftTrailData)this.points.get((int)(this.points.size - 2))).x, (float)((DriftTrailData)this.points.get((int)(this.points.size - 2))).y);
        }
    }

    public void update(float x, float y, Vec2 v) {
        this.update(x, y, 1.0f, v);
    }

    public void update(float x, float y, float width, Vec2 v) {
        float f;
        this.drift();
        this.counter += Time.delta;
        if (f >= 0.99f) {
            if (this.points.size > this.length) {
                this.points.remove(0);
            }
            this.points.add((Object)new DriftTrailData(x, y, width, v));
            this.counter = 0.0f;
        }
        this.lastAngle = -Angles.angleRad((float)x, (float)y, (float)this.lastX, (float)this.lastY);
        this.lastX = x;
        this.lastY = y;
        this.lastW = width;
    }

    public static class DriftTrailData {
        public float x;
        public float y;
        public float w;
        public float dx;
        public float dy;

        public DriftTrailData(float x, float y, float w, Vec2 v) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.dx = v.x;
            this.dy = v.y;
        }

        public void drift() {
            this.x += this.dx * Time.delta;
            this.y += this.dy * Time.delta;
        }
    }
}

