/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.renders;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Tmp;
import blackhole.graphics.BHLayer;
import mindustry.Vars;
import progressed.graphics.PMShaders;

public class SlashRenderer {
    private static int maxCount = 4;
    private static SlashShader slashShader;
    private static final Seq<SlashData> slashes;
    private static int slashIndex;
    private static FrameBuffer buffer;

    private static void createShader() {
        if (maxCount >= 1021) {
            return;
        }
        if (slashShader != null) {
            maxCount = Math.min(1021, maxCount * 2);
            slashShader.dispose();
        }
        Shader.prependFragmentCode = "#define MAX_COUNT " + maxCount + "\n";
        slashShader = new SlashShader();
        Shader.prependFragmentCode = "";
    }

    public static void init() {
        SlashRenderer.createShader();
        buffer = new FrameBuffer();
    }

    public static void addSlash(float x, float y, float a, float off, float length, float width, float color) {
        if (off <= 0.001f) {
            return;
        }
        if (SlashRenderer.slashes.size <= slashIndex) {
            slashes.add((Object)new SlashData());
        }
        SlashData slash = ((SlashData[])SlashRenderer.slashes.items)[slashIndex];
        slash.set(x, y, a, off, length, width, color);
        ++slashIndex;
    }

    public static void draw() {
        Draw.draw((float)(BHLayer.begin - 0.1f), () -> {
            buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
            buffer.begin();
        });
        Draw.draw((float)(BHLayer.end + 1.0f), () -> {
            buffer.end();
            while (SlashRenderer.slashes.size > maxCount) {
                SlashRenderer.createShader();
            }
            float[] slashArray = new float[slashIndex * 4];
            for (int i = 0; i < slashIndex; ++i) {
                SlashData slash = (SlashData)slashes.get(i);
                slashArray[i * 4] = slash.x;
                slashArray[i * 4 + 1] = slash.y;
                slashArray[i * 4 + 2] = Mathf.mod((float)(1.5707964f - slash.angle), (float)((float)Math.PI * 2));
                slashArray[i * 4 + 3] = slash.offset;
            }
            SlashRenderer.slashShader.slashes = slashArray;
            buffer.blit((Shader)slashShader);
            if (Vars.renderer.bloom != null) {
                Vars.renderer.bloom.capture();
                SlashRenderer.drawSlashes();
                Vars.renderer.bloom.render();
            } else {
                SlashRenderer.drawSlashes();
            }
            slashIndex = 0;
        });
    }

    private static void drawSlashes() {
        for (int i = 0; i < slashIndex; ++i) {
            SlashData slash = ((SlashData[])SlashRenderer.slashes.items)[i];
            float ang = slash.angle * 57.295776f;
            Tmp.v1.trns(ang, slash.length);
            Tmp.v2.trns(ang + 90.0f, slash.width);
            Draw.color((float)slash.color);
            Fill.quad((float)(slash.x + Tmp.v1.x), (float)(slash.y + Tmp.v1.y), (float)(slash.x + Tmp.v2.x), (float)(slash.y + Tmp.v2.y), (float)(slash.x - Tmp.v1.x), (float)(slash.y - Tmp.v1.y), (float)(slash.x - Tmp.v2.x), (float)(slash.y - Tmp.v2.y));
        }
    }

    static {
        slashes = new Seq(SlashData.class);
        slashIndex = 0;
    }

    private static class SlashShader
    extends PMShaders.PMLoadShader {
        public float[] slashes;

        private SlashShader() {
            super("screenspace", "slash");
        }

        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformi("u_slashescount", this.slashes.length / 4);
            this.setUniform4fv("u_slashes", this.slashes, 0, this.slashes.length);
        }
    }

    private static class SlashData {
        public float x;
        public float y;
        public float angle;
        public float offset;
        public float length;
        public float width;
        public float color;

        private SlashData() {
        }

        public void set(float x, float y, float angle, float offset, float length, float width, float color) {
            this.x = x;
            this.y = y;
            this.angle = angle;
            this.offset = offset;
            this.length = length;
            this.width = width;
            this.color = color;
        }
    }
}

