/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.draw3d;

import arc.Core;
import arc.Events;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import mindustry.Vars;
import mindustry.game.EventType;
import progressed.ProgMats;
import progressed.util.Math3D;

public class Perspective {
    private static final Vec2 offsetPos = new Vec2();
    private static final Vec3 scalingPos = new Vec3();
    private static final float groundTolerance = 0.001f;
    public static float viewportOffset = 80.0f;
    public static float minViewportZ = 20.0f;
    public static float fov = -1.0f;
    public static float fadeDst = 1024.0f;
    private static float lastScale;
    private static float cameraZ;
    private static final Vec2 viewportSize;

    public static boolean canDraw(float z) {
        return z < Perspective.viewportZ();
    }

    public static Vec2 drawPos(float x, float y, float z) {
        if (z <= 0.001f) {
            return offsetPos.set(x, y);
        }
        float vw = Perspective.viewportSize.x;
        float vh = Perspective.viewportSize.y;
        float cx = Core.camera.position.x;
        float cy = Core.camera.position.y;
        Vec3 scaled = Perspective.scaleToViewport(x, y, z);
        offsetPos.set(scaled.x / vw * Core.camera.width, scaled.y / vh * Core.camera.height).add(cx, cy);
        return offsetPos;
    }

    public static float scale(float x, float y, float z) {
        if (z <= 0.001f) {
            return 1.0f;
        }
        float cx = Core.camera.position.x;
        float cy = Core.camera.position.y;
        float cz = cameraZ;
        float zz = cz - z;
        float px = (x -= cx) / zz * cz;
        float py = (y -= cy) / zz * cz;
        float vx = x / zz * viewportOffset;
        float vy = y / zz * viewportOffset;
        float d1 = Math3D.dst(vx, vy, cz - viewportOffset, x, y, z);
        float d2 = Math3D.dst(vx, vy, cz - viewportOffset, px, py, 0.0f);
        return 1.0f + (1.0f / Perspective.viewportSize.x * Core.camera.width - 1.0f) * (1.0f - d1 / d2);
    }

    public static float alpha(float x, float y, float z) {
        float fade;
        if (z <= 0.001f) {
            return 1.0f;
        }
        float vz = Perspective.viewportZ();
        float dst = Perspective.dstToViewport(x, y, z);
        if (dst > (fade = Math.min(fadeDst, vz))) {
            return 1.0f;
        }
        if (z > vz) {
            return 0.0f;
        }
        return Interp.pow5In.apply(Mathf.clamp((float)(dst / fade)));
    }

    public static float cameraZ() {
        return cameraZ;
    }

    public static float viewportZ() {
        return Math.max(cameraZ - viewportOffset, 0.0f);
    }

    public static Vec3 scaleToViewport(float x, float y, float z) {
        if (z <= 0.001f) {
            return scalingPos.set(x, y, 0.0f);
        }
        float cx = Core.camera.position.x;
        float cy = Core.camera.position.y;
        float zz = cameraZ - z;
        return scalingPos.set((x -= cx) / zz * viewportOffset, (y -= cy) / zz * viewportOffset, Perspective.viewportZ());
    }

    public static float dstToViewport(float x, float y, float z) {
        Vec3 scaled = Perspective.scaleToViewport(x, y, z);
        return scaled.dst(x - Core.camera.position.x, y - Core.camera.position.y, z);
    }

    public static float maxZoom() {
        float minCZ = minViewportZ + viewportOffset;
        float minWidth = (float)((double)minCZ * Math.tan(fov / 2.0f * ((float)Math.PI / 180))) * 2.0f;
        float maxScale = (float)Math.max(Core.graphics.getHeight(), Core.graphics.getWidth()) / minWidth;
        return Math.min(24.0f, maxScale);
    }

    private static void updateViewportSize() {
        float v1 = (float)(Math.tan(fov / 2.0f * ((float)Math.PI / 180)) * (double)viewportOffset * 2.0);
        if (Core.camera.width >= Core.camera.height) {
            float v2 = v1 * (Core.camera.height / Core.camera.width);
            viewportSize.set(v1, v2);
        } else {
            float v2 = v1 * (Core.camera.width / Core.camera.height);
            viewportSize.set(v2, v1);
        }
    }

    private static float calcCameraZ() {
        float width = Math.max(Core.camera.width, Core.camera.height) / 2.0f;
        return (float)((double)width / Math.tan(fov / 2.0f * ((float)Math.PI / 180)));
    }

    static {
        viewportSize = new Vec2();
        if (!Vars.headless) {
            Events.run((Object)EventType.Trigger.preDraw, () -> {
                int newFov = Core.settings.getInt("pm-fov", 60);
                if (Vars.renderer.getDisplayScale() != lastScale || (float)newFov != fov) {
                    lastScale = Vars.renderer.getDisplayScale();
                    fov = newFov;
                    cameraZ = Perspective.calcCameraZ();
                    Perspective.updateViewportSize();
                }
            });
            Events.on(EventType.ResizeEvent.class, e -> Core.app.post(() -> {
                cameraZ = Perspective.calcCameraZ();
                Perspective.updateViewportSize();
                ProgMats.updateZoomRange();
            }));
        }
    }
}

