/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.draw3d;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import progressed.graphics.draw3d.Perspective;
import progressed.util.Math3D;

public class Lines3D {
    public static void line(float x1, float y1, float z1, float x2, float y2, float z2, int pointCount, boolean scale) {
        float[] points = Lines3D.linePoints(x1, y1, z1, x2, y2, z2, pointCount);
        float lastAngle = 0.0f;
        float stroke = Lines.getStroke() / 2.0f;
        Color color = Draw.getColor();
        for (int i = 0; i < points.length - 3; i += 3) {
            float px1 = points[i];
            float py1 = points[i + 1];
            float pz1 = points[i + 2];
            float px2 = points[i + 3];
            float py2 = points[i + 3 + 1];
            float pz2 = points[i + 3 + 2];
            Vec2 pos = Perspective.drawPos(px1, py1, pz1);
            float dx1 = pos.x;
            float dy1 = pos.y;
            pos = Perspective.drawPos(px2, py2, pz2);
            float dx2 = pos.x;
            float dy2 = pos.y;
            float a2 = -Angles.angleRad((float)dx1, (float)dy1, (float)dx2, (float)dy2);
            float a1 = i == 0 ? a2 : lastAngle;
            float w1 = scale ? Perspective.scale(px1, py1, pz1) : 1.0f;
            float w2 = scale ? Perspective.scale(px2, py2, pz2) : 1.0f;
            float cx = Mathf.sin((float)a1) * stroke * w1;
            float cy = Mathf.cos((float)a1) * stroke * w1;
            float nx = Mathf.sin((float)a2) * stroke * w2;
            float ny = Mathf.cos((float)a2) * stroke * w2;
            float c1 = Tmp.c1.set(color).mulA(Perspective.alpha(px1, py1, pz1)).toFloatBits();
            float c2 = Tmp.c1.set(color).mulA(Perspective.alpha(px2, py2, pz2)).toFloatBits();
            Fill.quad((float)(dx1 - cx), (float)(dy1 - cy), (float)c1, (float)(dx1 + cx), (float)(dy1 + cy), (float)c1, (float)(dx2 + nx), (float)(dy2 + ny), (float)c2, (float)(dx2 - nx), (float)(dy2 - ny), (float)c2);
            lastAngle = a2;
        }
    }

    public static void line(float x1, float y1, float z1, float x2, float y2, float z2, boolean scale) {
        Lines3D.line(x1, y1, z1, x2, y2, z2, Lines3D.linePointCount(x1, y1, z1, x2, y2, z2), scale);
    }

    public static void line(float x1, float y1, float z1, float x2, float y2, float z2) {
        Lines3D.line(x1, y1, z1, x2, y2, z2, true);
    }

    public static void lineAngleBase(float x, float y, float z, float length, float rotation, float rotationOffset, float tilt) {
        Math3D.rotate(Tmp.v31, length, rotation, rotationOffset, tilt);
        Lines3D.line(x, y, z, x + Tmp.v31.x, y + Tmp.v31.y, z + Tmp.v31.z);
    }

    public static int linePointCount(float x1, float y1, float z1, float x2, float y2, float z2) {
        return (int)(Math3D.dst(x1, y1, z1, x2, y2, z2) / 8.0f / 8.0f);
    }

    public static float[] linePoints(float x1, float y1, float z1, float x2, float y2, float z2, int pointCount) {
        float vz;
        if (z1 > z2) {
            float tx = x1;
            float ty = y1;
            float tz = z1;
            x1 = x2;
            y1 = y2;
            z1 = z2;
            x2 = tx;
            y2 = ty;
            z2 = tz;
        }
        if (z2 > (vz = Perspective.viewportZ())) {
            float scl = (vz - z1) / (z2 - z1);
            x2 = x1 + (x2 - x1) * scl;
            y2 = y1 + (y2 - y1) * scl;
            z2 = vz;
        }
        float[] points = new float[pointCount * 3];
        float px = (x2 - x1) / (float)(pointCount - 1);
        float py = (y2 - y1) / (float)(pointCount - 1);
        float pz = (z2 - z1) / (float)(pointCount - 1);
        for (int i = 0; i < pointCount; ++i) {
            points[i * 3] = x1 + px * (float)i;
            points[i * 3 + 1] = y1 + py * (float)i;
            points[i * 3 + 2] = z1 + pz * (float)i;
        }
        return points;
    }

    public static float[] linePoints(float x1, float y1, float z1, float x2, float y2, float z2) {
        return Lines3D.linePoints(x1, y1, z1, x2, y2, z2, Lines3D.linePointCount(x1, y1, z1, x2, y2, z2));
    }
}

