/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.draw3d;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Tmp;
import progressed.graphics.draw3d.Lines3D;
import progressed.graphics.draw3d.Perspective;

public class Fill3D {
    private static final Color tmpCol = new Color();
    public static final Vec2 vec = new Vec2();
    private static final Vec3 axis = new Vec3();
    private static final Vec3 rim = new Vec3();

    public static void quad(float x1, float y1, float z1, Color c1, float x2, float y2, float z2, Color c2, float x3, float y3, float z3, Color c3, float x4, float y4, float z4, Color c4) {
        Vec2 pos = Perspective.drawPos(x1, y1, z1);
        float dx1 = pos.x;
        float dy1 = pos.y;
        float a1 = Perspective.alpha(x1, y1, z1);
        pos = Perspective.drawPos(x2, y2, z2);
        float dx2 = pos.x;
        float dy2 = pos.y;
        float a2 = Perspective.alpha(x2, y2, z2);
        pos = Perspective.drawPos(x3, y3, z3);
        float dx3 = pos.x;
        float dy3 = pos.y;
        float a3 = Perspective.alpha(x3, y3, z3);
        pos = Perspective.drawPos(x4, y4, z4);
        float dx4 = pos.x;
        float dy4 = pos.y;
        float a4 = Perspective.alpha(x4, y4, z4);
        Fill.quad((float)dx1, (float)dy1, (float)tmpCol.set(c1).mulA(a1).toFloatBits(), (float)dx2, (float)dy2, (float)tmpCol.set(c2).mulA(a2).toFloatBits(), (float)dx3, (float)dy3, (float)tmpCol.set(c3).mulA(a3).toFloatBits(), (float)dx4, (float)dy4, (float)tmpCol.set(c4).mulA(a4).toFloatBits());
    }

    public static void quad(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        Color color = Draw.getColor();
        Fill3D.quad(x1, y1, z1, color, x2, y2, z2, color, x3, y3, z3, color, x4, y4, z4, color);
    }

    public static void tube(float x, float y, float rad, float z2, Color baseColor, Color topColor) {
        float scl = Perspective.scale(x, y, z2);
        if (scl < 0.0f) {
            return;
        }
        int vert = Lines.circleVertices((float)rad);
        float space = 360.0f / (float)vert;
        Vec2 pos = Perspective.drawPos(x, y, z2);
        float angle = Fill3D.tubeStartAngle(x, y, pos.x, pos.y, rad, rad * scl);
        for (int i = 0; i < vert; ++i) {
            float a = angle + space * (float)i;
            float cos = Mathf.cosDeg((float)a);
            float sin = Mathf.sinDeg((float)a);
            float cos2 = Mathf.cosDeg((float)(a + space));
            float sin2 = Mathf.sinDeg((float)(a + space));
            float x1 = x + rad * cos;
            float y1 = y + rad * sin;
            float x2 = x + rad * cos2;
            float y2 = y + rad * sin2;
            Fill3D.quad(x1, y1, 0.0f, baseColor, x2, y2, 0.0f, baseColor, x2, y2, z2, topColor, x1, y1, z2, topColor);
        }
    }

    public static void slantTube(float x1, float y1, float x2, float y2, float z2, float rad, Color baseColor, Color topColor) {
        float scl = Perspective.scale(x2, y2, z2);
        if (scl < 0.0f) {
            return;
        }
        float rotation = Angles.angle((float)x2, (float)y2, (float)x1, (float)y1);
        float tilt = 90.0f - Angles.angle((float)Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2), (float)z2);
        Vec2 pos = Perspective.drawPos(x2, y2, z2);
        float startAngle = Fill3D.tubeStartAngle(pos.x, pos.y, x1, y1, rad * scl, rad);
        int verts = Lines.circleVertices((float)(rad * scl));
        float[] castVerts = Fill3D.castVertices(x1, y1, rotation, startAngle, tilt, rad, verts);
        float[] diskVerts = Fill3D.diskVertices(x2, y2, z2, rotation, startAngle, tilt, rad, verts);
        int segments = Lines3D.linePointCount(x1, y1, 0.0f, x2, y2, z2);
        for (int i = 0; i < verts; ++i) {
            float[] v1 = Lines3D.linePoints(castVerts[i * 2], castVerts[i * 2 + 1], 0.0f, diskVerts[i * 3], diskVerts[i * 3 + 1], diskVerts[i * 3 + 2], segments);
            int i2 = i == verts - 1 ? 0 : i + 1;
            float[] v2 = Lines3D.linePoints(castVerts[i2 * 2], castVerts[i2 * 2 + 1], 0.0f, diskVerts[i2 * 3], diskVerts[i2 * 3 + 1], diskVerts[i2 * 3 + 2], segments);
            for (int j = 0; j < segments - 3; ++j) {
                int jj = j * 3;
                Color c1 = Tmp.c1.set(baseColor).lerp(topColor, (float)jj / (float)segments);
                Color c2 = Tmp.c2.set(baseColor).lerp(topColor, (float)(jj + 3) / (float)segments);
                Fill3D.quad(v1[jj], v1[jj + 1], v1[jj + 2], c1, v2[jj], v2[jj + 1], v2[jj + 2], c1, v2[jj + 3], v2[jj + 3 + 1], v2[jj + 3 + 2], c2, v1[jj + 3], v1[jj + 3 + 1], v1[jj + 3 + 2], c2);
            }
        }
    }

    public static float[] diskVertices(float x, float y, float z, float rotation, float startAngle, float tilt, float rad, int verts) {
        float[] diskVerts = new float[(verts + 1) * 3];
        float space = 360.0f / (float)verts;
        axis.set(Vec3.Z).rotate(Vec3.Y, tilt).rotate(Vec3.Z, -rotation);
        rim.set(rad, 0.0f, 0.0f).rotate(Vec3.Y, tilt).rotate(Vec3.Z, -rotation);
        rim.rotate(axis, rotation - startAngle);
        for (int i = 0; i <= verts; ++i) {
            diskVerts[i * 3] = x + Fill3D.rim.x;
            diskVerts[i * 3 + 1] = y + Fill3D.rim.y;
            diskVerts[i * 3 + 2] = z + Fill3D.rim.z;
            rim.rotate(axis, space);
        }
        return diskVerts;
    }

    public static float[] castVertices(float x, float y, float rotation, float startAngle, float tilt, float rad, int verts) {
        float[] castVerts = new float[verts * 2];
        float space = 360.0f / ((float)verts - 1.0f);
        float scl = 1.0f + Mathf.sinDeg((float)tilt);
        for (int i = 0; i < verts; ++i) {
            float angle = startAngle + space * (float)i - rotation;
            vec.trns(rotation, Mathf.cosDeg((float)angle) * rad * scl, Mathf.sinDeg((float)angle) * rad);
            castVerts[i * 2] = x + Fill3D.vec.x;
            castVerts[i * 2 + 1] = y + Fill3D.vec.y;
        }
        return castVerts;
    }

    public static float tubeStartAngle(float x1, float y1, float x2, float y2, float rad1, float rad2) {
        if (x1 == x2 && y1 == y2) {
            return 0.0f;
        }
        float d = Mathf.dst((float)(x2 - x1), (float)(y2 - y1));
        float f = Mathf.sqrt((float)(d * d - Mathf.sqr((float)(rad2 - rad1))));
        float a = rad1 > rad2 ? Mathf.atan2((float)(rad1 - rad2), (float)f) : (rad1 < rad2 ? (float)Math.PI - Mathf.atan2((float)(rad2 - rad1), (float)f) : 1.5707964f);
        Tmp.v1.set(x2 - x1, y2 - y1).scl(1.0f / d);
        Tmp.v2.set(Tmp.v1).rotateRad((float)Math.PI - a).scl(-rad2).add(x2, y2);
        return Angles.angle((float)x2, (float)y2, (float)Tmp.v2.x, (float)Tmp.v2.y);
    }
}

