/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.scene.ui.layout.Scl;
import arc.util.Time;
import mindustry.Vars;

public class PMShaders {
    public static MaterializeShader materialize;
    public static VerticalBuildShader vertBuild;
    public static BlockBuildCenterShader blockBuildCenter;
    public static TractorConeShader tractorCone;
    public static AlphaShader alphaShader;
    public static DimShader dimShader;
    public static SmallSpaceShader smallSpaceShader;
    public static PassThroughShader passThrough;

    public static void init() {
        materialize = new MaterializeShader();
        vertBuild = new VerticalBuildShader();
        blockBuildCenter = new BlockBuildCenterShader();
        tractorCone = new TractorConeShader();
        alphaShader = new AlphaShader();
        dimShader = new DimShader();
        smallSpaceShader = new SmallSpaceShader("smallspace");
        passThrough = new PassThroughShader();
    }

    public static class MaterializeShader
    extends PMLoadShader {
        public float progress;
        public float offset;
        public float time;
        public int shadow;
        public Color color = new Color();
        public TextureRegion region;

        MaterializeShader() {
            super("materialize");
        }

        public void apply() {
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_offset", this.offset);
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_width", this.region.width);
            this.setUniformf("u_shadow", this.shadow);
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_texsize", this.region.texture.width, this.region.texture.height);
        }
    }

    public static class VerticalBuildShader
    extends PMLoadShader {
        public float progress;
        public float time;
        public Color color = new Color();
        public TextureRegion region;

        public VerticalBuildShader() {
            super("vertbuild");
        }

        public void apply() {
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_texsize", this.region.texture.width, this.region.texture.height);
        }
    }

    public static class BlockBuildCenterShader
    extends PMLoadShader {
        public float progress;
        public TextureRegion region;
        public float time;

        BlockBuildCenterShader() {
            super("blockbuildcenter");
        }

        public void apply() {
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_texsize", this.region.texture.width, this.region.texture.height);
        }
    }

    public static class TractorConeShader
    extends PMLoadShader {
        public float cx;
        public float cy;
        public float time;
        public float spacing;
        public float thickness;

        TractorConeShader() {
            super("screenspace", "tractorcone");
        }

        public void apply() {
            this.setUniformf("u_dp", Scl.scl((float)1.0f));
            this.setUniformf("u_time", this.time / Scl.scl((float)1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_spacing", this.spacing / Scl.scl((float)1.0f));
            this.setUniformf("u_thickness", this.thickness / Scl.scl((float)1.0f));
            this.setUniformf("u_cx", this.cx / Scl.scl((float)1.0f));
            this.setUniformf("u_cy", this.cy / Scl.scl((float)1.0f));
        }

        public void setCenter(float cx, float cy) {
            this.cx = cx;
            this.cy = cy;
        }
    }

    public static class AlphaShader
    extends PMLoadShader {
        public float alpha = 1.0f;

        AlphaShader() {
            super("screenspace", "postalpha");
        }

        public void apply() {
            this.setUniformf("u_alpha", this.alpha);
        }
    }

    public static class DimShader
    extends PMLoadShader {
        public float alpha;

        DimShader() {
            super("screenspace", "dim");
        }

        public void apply() {
            this.setUniformf("u_alpha", this.alpha);
        }
    }

    public static class SmallSpaceShader
    extends PMLoadShader {
        Texture texture;

        public SmallSpaceShader(String frag) {
            super("screenspace", frag);
        }

        public void apply() {
            if (this.texture == null) {
                this.texture = new Texture(Vars.tree.get("shaders/prog-mats-small-space.png"));
                this.texture.setFilter(Texture.TextureFilter.linear);
                this.texture.setWrap(Texture.TextureWrap.repeat);
            }
            this.setUniformf("u_campos", Core.camera.position.x, Core.camera.position.y);
            this.setUniformf("u_ccampos", Core.camera.position);
            this.setUniformf("u_resolution", Core.graphics.getWidth(), Core.graphics.getHeight());
            this.setUniformf("u_time", Time.time);
            this.texture.bind(1);
            ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
            this.setUniformi("u_stars", 1);
        }
    }

    public static class PassThroughShader
    extends PMLoadShader {
        public PassThroughShader() {
            super("screenspace", "passThrough");
        }
    }

    public static class PMLoadShader
    extends Shader {
        public PMLoadShader(String vert, String frag) {
            super(Core.files.internal("shaders/" + vert + ".vert"), Vars.tree.get("shaders/" + frag + ".frag"));
        }

        public PMLoadShader(String frag) {
            this("default", frag);
        }
    }
}

