/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.Image;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.ui.Fonts;
import progressed.graphics.PMShaders;

public class PMDrawf {
    private static final Vec2 vec1 = new Vec2();
    private static final Vec2 vec2 = new Vec2();
    private static final Vec2 vec3 = new Vec2();
    private static final Vec2 vec4 = new Vec2();

    public static void light(float x, float y, TextureRegion region, float rotation, Color color, float opacity, boolean flip) {
        float res = color.toFloatBits();
        Vars.renderer.lights.add(() -> {
            Draw.color((float)res);
            Draw.alpha((float)opacity);
            Draw.rect((TextureRegion)region, (float)x, (float)y, (float)((float)region.width / 4.0f * (float)Mathf.sign((boolean)flip)), (float)((float)region.height / 4.0f), (float)rotation);
        });
    }

    public static void plus(float x, float y, float diameter, float angle) {
        PMDrawf.plus(x, y, diameter / 3.0f, diameter, angle);
    }

    public static void plus(float x, float y, float stroke, float diameter, float angle) {
        for (int i = 0; i < 2; ++i) {
            Fill.rect((float)x, (float)y, (float)stroke, (float)diameter, (float)(angle + (float)i * 90.0f));
        }
    }

    public static void cross(float x, float y, float width, float length, float angle) {
        for (int i = 0; i < 4; ++i) {
            Drawf.tri((float)x, (float)y, (float)width, (float)length, (float)((float)i * 90.0f + angle));
        }
    }

    public static void cross(float x, float y, float size, float angle) {
        PMDrawf.cross(x, y, size, size, angle);
    }

    public static void shadow(TextureRegion texture, float x, float y, float rotation, float alpha) {
        Draw.color((Color)Tmp.c1.set(Pal.shadow).mulA(alpha));
        Draw.rect((TextureRegion)texture, (float)x, (float)y, (float)rotation);
        Draw.color();
    }

    public static void vecLine(float x, float y, Vec2 v1, Vec2 v2, boolean cap) {
        Lines.line((float)(v1.x + x), (float)(v1.y + y), (float)(v2.x + x), (float)(v2.y + y), (boolean)cap);
    }

    public static void lineAngleCenter(float x, float y, float angle, float length, boolean cap) {
        vec1.trns(angle, length);
        Lines.line((float)(x - PMDrawf.vec1.x / 2.0f), (float)(y - PMDrawf.vec1.y / 2.0f), (float)(x + PMDrawf.vec1.x / 2.0f), (float)(y + PMDrawf.vec1.y / 2.0f), (boolean)cap);
    }

    public static void pill(float x, float y, float angle, float length, float width) {
        Lines.stroke((float)width);
        PMDrawf.lineAngleCenter(x, y, angle, length - width, false);
        for (int i = 0; i < 2; ++i) {
            vec1.trns(angle + 180.0f * (float)i, length / 2.0f - width / 2.0f);
            Fill.circle((float)(x + PMDrawf.vec1.x), (float)(y + PMDrawf.vec1.y), (float)(width / 2.0f));
        }
    }

    public static void baseTri(float x, float y, float b, float h, float rot) {
        vec1.trns(rot, h).add(x, y);
        vec2.trns(rot - 90.0f, b / 2.0f).add(x, y);
        vec3.trns(rot + 90.0f, b / 2.0f).add(x, y);
        Fill.tri((float)PMDrawf.vec1.x, (float)PMDrawf.vec1.y, (float)PMDrawf.vec2.x, (float)PMDrawf.vec2.y, (float)PMDrawf.vec3.x, (float)PMDrawf.vec3.y);
    }

    public static void targetLine(float x1, float y1, float x2, float y2, float r1, float r2, Color color) {
        float ang = Angles.angle((float)x1, (float)y1, (float)x2, (float)y2);
        float calc = 1.0f + (1.0f - Mathf.sinDeg((float)(Mathf.mod((float)ang, (float)90.0f) * 2.0f))) * (Mathf.sqrt2 - 1.0f);
        Tmp.v1.trns(ang, r1 / Mathf.sqrt2 * calc).add(x1, y1);
        Tmp.v2.trns(ang + 180.0f, r2 / Mathf.sqrt2 * calc).add(x2, y2);
        Lines.stroke((float)3.0f, (Color)Pal.gray);
        Lines.square((float)x1, (float)y1, (float)r1, (float)45.0f);
        Lines.square((float)x2, (float)y2, (float)r2, (float)45.0f);
        Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
        Lines.stroke((float)1.0f, (Color)color);
        Lines.square((float)x1, (float)y1, (float)r1, (float)45.0f);
        Lines.square((float)x2, (float)y2, (float)r2, (float)45.0f);
        Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
    }

    public static void target(float x, float y, float angle, float radius, Color ringColor, Color spikeColor, float alpha) {
        Draw.color((Color)Pal.gray, (float)alpha);
        Lines.stroke((float)3.0f);
        Lines.poly((float)x, (float)y, (int)4, (float)(7.0f * radius), (float)angle);
        Lines.spikes((float)x, (float)y, (float)(3.0f * radius), (float)(6.0f * radius), (int)4, (float)angle);
        Draw.color((Color)ringColor, (float)alpha);
        Lines.stroke((float)1.0f);
        Lines.poly((float)x, (float)y, (int)4, (float)(7.0f * radius), (float)angle);
        Draw.color((Color)spikeColor);
        Lines.spikes((float)x, (float)y, (float)(3.0f * radius), (float)(6.0f * radius), (int)4, (float)angle);
        Draw.color();
    }

    public static void target(float x, float y, float angle, float radius, Color color, float alpha) {
        PMDrawf.target(x, y, angle, radius, color, color, alpha);
    }

    public static void progressRing(float x, float y, float rad1, float rad2, float progress) {
        if (Math.abs(rad1 - rad2) > 0.01f) {
            int sides = (int)((float)Lines.circleVertices((float)Math.max(rad1, rad2)) * progress);
            float space = 360.0f * progress / (float)sides;
            for (int i = 0; i < sides; ++i) {
                float a = 90.0f - space * (float)i;
                float cos = Mathf.cosDeg((float)a);
                float sin = Mathf.sinDeg((float)a);
                float cos2 = Mathf.cosDeg((float)(a - space));
                float sin2 = Mathf.sinDeg((float)(a - space));
                Fill.quad((float)(x + rad1 * cos), (float)(y + rad1 * sin), (float)(x + rad1 * cos2), (float)(y + rad1 * sin2), (float)(x + rad2 * cos2), (float)(y + rad2 * sin2), (float)(x + rad2 * cos), (float)(y + rad2 * sin));
            }
        }
    }

    public static void ring(float x, float y, float rad1, float rad2) {
        if (Math.abs(rad1 - rad2) > 0.01f) {
            int sides = Lines.circleVertices((float)Math.max(rad1, rad2));
            float space = 360.0f / (float)sides;
            for (int i = 0; i < sides; ++i) {
                float a = space * (float)i;
                float cos = Mathf.cosDeg((float)a);
                float sin = Mathf.sinDeg((float)a);
                float cos2 = Mathf.cosDeg((float)(a + space));
                float sin2 = Mathf.sinDeg((float)(a + space));
                Fill.quad((float)(x + rad1 * cos), (float)(y + rad1 * sin), (float)(x + rad1 * cos2), (float)(y + rad1 * sin2), (float)(x + rad2 * cos2), (float)(y + rad2 * sin2), (float)(x + rad2 * cos), (float)(y + rad2 * sin));
            }
        }
    }

    public static void laser(TextureRegion line, TextureRegion start, TextureRegion end, float x, float y, float x2, float y2, float scale) {
        float scl = 8.0f * scale * Draw.scl;
        float rot = Mathf.angle((float)(x2 - x), (float)(y2 - y));
        float vx = Mathf.cosDeg((float)rot) * scl;
        float vy = Mathf.sinDeg((float)rot) * scl;
        Draw.rect((TextureRegion)start, (float)x, (float)y, (float)((float)start.width * scale * start.scl()), (float)((float)start.height * scale * start.scl()), (float)(rot + 180.0f));
        Draw.rect((TextureRegion)end, (float)x2, (float)y2, (float)((float)end.width * scale * end.scl()), (float)((float)end.height * scale * end.scl()), (float)rot);
        Lines.stroke((float)(12.0f * scale));
        Lines.line((TextureRegion)line, (float)(x + vx), (float)(y + vy), (float)(x2 - vx), (float)(y2 - vy), (boolean)false);
        Lines.stroke((float)1.0f);
    }

    public static void blockBuild(float x, float y, TextureRegion region, float rotation, float progress) {
        PMDrawf.blockBuild(x, y, region, Pal.accent, rotation, progress);
    }

    public static void blockBuild(float x, float y, TextureRegion region, Color color, float rotation, float progress) {
        Shaders.blockbuild.region = region;
        Shaders.blockbuild.progress = progress;
        Draw.color((Color)color);
        Draw.shader((Shader)Shaders.blockbuild);
        Draw.rect((TextureRegion)region, (float)x, (float)y, (float)rotation);
        Draw.shader();
        Draw.color();
    }

    public static void blockBuildCenter(float x, float y, TextureRegion region, float rotation, float progress) {
        PMDrawf.blockBuildCenter(x, y, region, Pal.accent, rotation, progress);
    }

    public static void blockBuildCenter(float x, float y, TextureRegion region, Color color, float rotation, float progress) {
        PMShaders.blockBuildCenter.region = region;
        PMShaders.blockBuildCenter.progress = progress;
        Draw.color((Color)color);
        Draw.shader((Shader)PMShaders.blockBuildCenter);
        Draw.rect((TextureRegion)region, (float)x, (float)y, (float)rotation);
        Draw.shader();
        Draw.color();
    }

    public static void vertConstruct(float x, float y, TextureRegion region, float rotation, float progress, float alpha, float time) {
        PMDrawf.vertConstruct(x, y, region, Pal.accent, rotation, progress, alpha, time);
    }

    public static void vertConstruct(float x, float y, TextureRegion region, Color color, float rotation, float progress, float alpha, float time) {
        PMShaders.vertBuild.region = region;
        PMShaders.vertBuild.progress = progress;
        PMShaders.vertBuild.color.set(color);
        PMShaders.vertBuild.color.a = alpha;
        PMShaders.vertBuild.time = -time / 20.0f;
        Draw.shader((Shader)PMShaders.vertBuild);
        Draw.rect((TextureRegion)region, (float)x, (float)y, (float)rotation);
        Draw.shader();
        Draw.reset();
    }

    public static void materialize(float x, float y, TextureRegion region, Color color, float rotation, float offset, float progress) {
        PMDrawf.materialize(x, y, region, color, rotation, offset, progress, Time.time, false);
    }

    public static void materialize(float x, float y, TextureRegion region, Color color, float rotation, float offset, float progress, boolean shadow) {
        PMDrawf.materialize(x, y, region, color, rotation, offset, progress, Time.time, shadow);
    }

    public static void materialize(float x, float y, TextureRegion region, Color color, float rotation, float offset, float progress, float time) {
        PMDrawf.materialize(x, y, region, color, rotation, offset, progress, time, false);
    }

    public static void materialize(float x, float y, TextureRegion region, Color color, float rotation, float offset, float progress, float time, boolean shadow) {
        PMShaders.materialize.region = region;
        PMShaders.materialize.progress = Mathf.clamp((float)progress);
        PMShaders.materialize.color.set(color);
        PMShaders.materialize.time = time;
        PMShaders.materialize.offset = offset;
        PMShaders.materialize.shadow = Mathf.num((boolean)shadow);
        Draw.shader((Shader)PMShaders.materialize);
        Draw.rect((TextureRegion)region, (float)x, (float)y, (float)rotation);
        Draw.shader();
        Draw.reset();
    }

    private static void drawSpinSprite(TextureRegion[] regions, float x, float y, float w, float h, float r) {
        float ar = Mathf.mod((float)r, (float)360.0f);
        Draw.alpha((float)1.0f);
        if (ar > 45.0f && ar <= 225.0f) {
            Draw.rect((TextureRegion)regions[0], (float)x, (float)y, (float)w, (float)(h * -1.0f), (float)r);
        } else {
            Draw.rect((TextureRegion)regions[0], (float)x, (float)y, (float)w, (float)h, (float)r);
        }
        if (ar >= 180.0f && ar < 270.0f) {
            float a = Interp.slope.apply(Mathf.curve((float)ar, (float)180.0f, (float)270.0f));
            Draw.alpha((float)a);
            Draw.rect((TextureRegion)regions[1], (float)x, (float)y, (float)w, (float)h, (float)r);
        } else if (ar < 90.0f && ar >= 0.0f) {
            float a = Interp.slope.apply(Mathf.curve((float)ar, (float)0.0f, (float)90.0f));
            Draw.alpha((float)a);
            Draw.rect((TextureRegion)regions[2], (float)x, (float)y, (float)w, (float)h, (float)r);
        }
        Draw.alpha((float)1.0f);
    }

    public static void spinSprite(TextureRegion[] regions, float x, float y, float w, float h, float r, float alpha) {
        float xScl = Draw.xscl;
        float yScl = Draw.yscl;
        if (alpha < 0.99f) {
            FrameBuffer buffer = Vars.renderer.effectBuffer;
            float z = Draw.z();
            Draw.draw((float)z, () -> {
                buffer.begin(Color.clear);
                PMDrawf.drawSpinSprite(regions, x, y, w * xScl, h * yScl, r);
                buffer.end();
                PMShaders.alphaShader.alpha = alpha;
                buffer.blit((Shader)PMShaders.alphaShader);
            });
        } else {
            PMDrawf.drawSpinSprite(regions, x, y, w * xScl, h * yScl, r);
        }
    }

    public static void spinSprite(TextureRegion[] regions, float x, float y, float w, float h, float r) {
        PMDrawf.spinSprite(regions, x, y, w, h, r, 1.0f);
    }

    public static void spinSprite(TextureRegion[] regions, float x, float y, float r, float alpha) {
        PMDrawf.spinSprite(regions, x, y, (float)regions[0].width / 4.0f, (float)regions[0].height / 4.0f, r, alpha);
    }

    public static void spinSprite(TextureRegion[] regions, float x, float y, float r) {
        PMDrawf.spinSprite(regions, x, y, (float)regions[0].width / 4.0f, (float)regions[0].height / 4.0f, r);
    }

    public static void ellipse(float x, float y, float rad, float wScl, float hScl, float rot) {
        float sides = Lines.circleVertices((float)rad);
        float space = 360.0f / sides;
        float r1 = rad - Lines.getStroke() / 2.0f;
        float r2 = rad + Lines.getStroke() / 2.0f;
        int i = 0;
        while ((float)i < sides) {
            float a = space * (float)i;
            vec1.trns(rot, r1 * wScl * Mathf.cosDeg((float)a), r1 * hScl * Mathf.sinDeg((float)a));
            vec2.trns(rot, r1 * wScl * Mathf.cosDeg((float)(a + space)), r1 * hScl * Mathf.sinDeg((float)(a + space)));
            vec3.trns(rot, r2 * wScl * Mathf.cosDeg((float)(a + space)), r2 * hScl * Mathf.sinDeg((float)(a + space)));
            vec4.trns(rot, r2 * wScl * Mathf.cosDeg((float)a), r2 * hScl * Mathf.sinDeg((float)a));
            Fill.quad((float)(x + PMDrawf.vec1.x), (float)(y + PMDrawf.vec1.y), (float)(x + PMDrawf.vec2.x), (float)(y + PMDrawf.vec2.y), (float)(x + PMDrawf.vec3.x), (float)(y + PMDrawf.vec3.y), (float)(x + PMDrawf.vec4.x), (float)(y + PMDrawf.vec4.y));
            ++i;
        }
    }

    public static void flash(Color fromColor, Color toColor, float seconds, Interp fade) {
        if (!Vars.headless) {
            Image flash = new Image();
            flash.touchable = Touchable.disabled;
            flash.setColor(fromColor);
            flash.setFillParent(true);
            flash.actions(new Action[]{Actions.color((Color)toColor, (float)seconds)});
            flash.actions(new Action[]{Actions.fadeOut((float)seconds, (Interp)fade), Actions.remove()});
            flash.update(() -> {
                if (!Vars.state.isGame()) {
                    flash.remove();
                }
            });
            Core.scene.add((Element)flash);
        }
    }

    public static void spinningCircle(int seed, float time, float x, float y, float radius, int spikes, float spikeDuration, float durationRnd, float spikeWidth, float spikeHeight, float pointOffset) {
        PMDrawf.spinningCircle(seed, time, time, x, y, radius, spikes, spikeDuration, durationRnd, spikeWidth, spikeHeight, pointOffset);
    }

    public static void spinningCircle(int seed, float angle, float time, float x, float y, float radius, int spikes, float spikeDuration, float durationRnd, float spikeWidth, float spikeHeight, float pointOffset) {
        Fill.circle((float)x, (float)y, (float)radius);
        for (int i = 0; i < spikes; ++i) {
            float d = spikeDuration + Mathf.randomSeedRange((long)(seed + i + spikes), (float)durationRnd);
            float timeOffset = Mathf.randomSeed((long)((long)(seed + i) * 314L), (float)0.0f, (float)d);
            int timeSeed = Mathf.floor((float)((time + timeOffset) / d));
            float a = angle + Mathf.randomSeed((long)((long)Math.max(timeSeed, 1) + (long)(i + seed) * 245L), (float)360.0f);
            float fin = (time + timeOffset) % d / d;
            float fslope = (0.5f - Math.abs(fin - 0.5f)) * 2.0f;
            vec1.trns(a + spikeWidth / 2.0f, radius).add(x, y);
            vec2.trns(a - spikeWidth / 2.0f, radius).add(x, y);
            vec3.trns(a + pointOffset, radius + spikeHeight * fslope).add(x, y);
            Fill.tri((float)PMDrawf.vec1.x, (float)PMDrawf.vec1.y, (float)PMDrawf.vec2.x, (float)PMDrawf.vec2.y, (float)PMDrawf.vec3.x, (float)PMDrawf.vec3.y);
        }
    }

    public static void arcLine(float x, float y, float radius, float fraction, float rotation) {
        Lines.arc((float)x, (float)y, (float)radius, (float)fraction, (float)rotation, (int)50);
    }

    public static void arcLine(float x, float y, float radius, float fraction, float rotation, int sides) {
        int max = Mathf.ceil((float)((float)sides * fraction));
        Lines.beginLine();
        for (int i = 0; i <= max; ++i) {
            vec1.trns((float)i / (float)max * fraction * 360.0f + rotation, radius);
            float x1 = PMDrawf.vec1.x;
            float y1 = PMDrawf.vec1.y;
            vec1.trns((float)(i + 1) / (float)max * fraction * 360.0f + rotation, radius);
            Lines.linePoint((float)(x + x1), (float)(y + y1));
        }
        Lines.endLine();
    }

    public static void arcFill(float x, float y, float radius, float fraction, float rotation) {
        PMDrawf.arcFill(x, y, radius, fraction, rotation, 50);
    }

    public static void arcFill(float x, float y, float radius, float fraction, float rotation, int sides) {
        int max = Mathf.ceil((float)((float)sides * fraction));
        Fill.polyBegin();
        Fill.polyPoint((float)x, (float)y);
        for (int i = 0; i <= max; ++i) {
            float a = fraction * 360.0f * ((float)i / (float)max) + rotation;
            float x1 = Angles.trnsx((float)a, (float)radius);
            float y1 = Angles.trnsy((float)a, (float)radius);
            Fill.polyPoint((float)(x + x1), (float)(y + y1));
        }
        Fill.polyPoint((float)x, (float)y);
        Fill.polyEnd();
    }

    public static float text(float x, float y, Color color, CharSequence text) {
        return PMDrawf.text(x, y, true, -1.0f, color, text);
    }

    public static float text(float x, float y, boolean underline, float maxWidth, Color color, CharSequence text) {
        Font font = Fonts.outline;
        GlyphLayout layout = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        if (maxWidth <= 0.0f) {
            font.getData().setScale(0.33333334f);
            layout.setText(font, text);
        } else {
            font.getData().setScale(1.0f);
            layout.setText(font, text);
            font.getData().setScale(Math.min(0.33333334f, maxWidth / layout.width));
            layout.setText(font, text);
        }
        font.setColor(color);
        font.draw(text, x, y + (underline ? layout.height + 1.0f : layout.height / 2.0f), 1);
        if (underline) {
            Lines.stroke((float)2.0f, (Color)Color.darkGray);
            Lines.line((float)(x - layout.width / 2.0f - 2.0f), (float)(y -= 1.0f), (float)(x + layout.width / 2.0f + 1.5f), (float)y);
            Lines.stroke((float)1.0f, (Color)color);
            Lines.line((float)(x - layout.width / 2.0f - 2.0f), (float)y, (float)(x + layout.width / 2.0f + 1.5f), (float)y);
        }
        float width = layout.width;
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free((Object)layout);
        return width;
    }

    public static void tractorCone(float cx, float cy, float time, float spacing, float thickness, Runnable draw) {
        FrameBuffer buffer = Vars.renderer.effectBuffer;
        float z = Draw.z();
        Draw.draw((float)z, () -> {
            buffer.begin(Color.clear);
            draw.run();
            buffer.end();
            PMShaders.tractorCone.setCenter(cx, cy);
            PMShaders.tractorCone.time = time;
            PMShaders.tractorCone.spacing = spacing;
            PMShaders.tractorCone.thickness = thickness;
            buffer.blit((Shader)PMShaders.tractorCone);
        });
    }
}

