/*
 * Decompiled with CFR 0.152.
 */
package progressed.gen.entities;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.geom.Position;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.EntityGroup;
import mindustry.gen.Building;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Posc;
import mindustry.gen.Rotc;
import mindustry.gen.Timedc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.environment.Floor;
import progressed.gen.entities.BuildChildc;
import progressed.gen.entities.EntityRegistry;
import progressed.gen.entities.TurretParentEffectStatec;

public class TurretParentEffectState
implements Pool.Poolable,
Drawc,
Entityc,
Posc,
Rotc,
Timedc,
BuildChildc,
TurretParentEffectStatec {
    private transient boolean added;
    public Color color = new Color(Color.white);
    public Object data;
    public Effect effect;
    public transient int id = EntityGroup.nextId();
    public float lifetime;
    public float offsetPos;
    public float offsetRot;
    public float offsetX;
    public float offsetY;
    @Nullable
    public Posc parent;
    public boolean rotWithParent;
    public float rotation;
    public float time;
    public float x;
    public float y;

    protected TurretParentEffectState() {
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    @Override
    public Color color() {
        return this.color;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isLocal() {
        Unitc u;
        TurretParentEffectState turretParentEffectState;
        return this == Vars.player || (turretParentEffectState = this) instanceof Unitc && (u = (Unitc)turretParentEffectState).controller() == Vars.player;
    }

    public boolean isRemote() {
        Unitc u;
        TurretParentEffectState turretParentEffectState = this;
        return turretParentEffectState instanceof Unitc && (u = (Unitc)turretParentEffectState).isPlayer() && !this.isLocal();
    }

    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean rotWithParent() {
        return this.rotWithParent;
    }

    public boolean serialize() {
        return false;
    }

    @Override
    public float clipSize() {
        return this.effect.clip;
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float lifetime() {
        return this.lifetime;
    }

    @Override
    public float offsetPos() {
        return this.offsetPos;
    }

    @Override
    public float offsetRot() {
        return this.offsetRot;
    }

    @Override
    public float offsetX() {
        return this.offsetX;
    }

    @Override
    public float offsetY() {
        return this.offsetY;
    }

    public float rotation() {
        return this.rotation;
    }

    public float time() {
        return this.time;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public int classId() {
        return EntityRegistry.getID(TurretParentEffectState.class);
    }

    public int id() {
        return this.id;
    }

    public int tileX() {
        return World.toTile((float)this.x);
    }

    public int tileY() {
        return World.toTile((float)this.y);
    }

    @Override
    public Object data() {
        return this.data;
    }

    public String toString() {
        return "TurretParentEffectState#" + this.id;
    }

    @Override
    public Effect effect() {
        return this.effect;
    }

    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    public Posc parent() {
        return this.parent;
    }

    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public void add() {
        if (this.added) {
            return;
        }
        Groups.draw.add((Entityc)this);
        Groups.all.add((Entityc)this);
        if (this.parent != null) {
            this.offsetX = this.x - this.parent.getX();
            this.offsetY = this.y - this.parent.getY();
            if (this.rotWithParent) {
                Posc posc = this.parent;
                if (posc instanceof Rotc) {
                    Rotc r = (Rotc)posc;
                    this.offsetPos = -r.rotation();
                    this.offsetRot = this.rotation - r.rotation();
                } else {
                    posc = this.parent;
                    if (posc instanceof BaseTurret.BaseTurretBuild) {
                        BaseTurret.BaseTurretBuild build = (BaseTurret.BaseTurretBuild)posc;
                        this.offsetPos = -build.rotation;
                        this.offsetRot = this.rotation - build.rotation;
                    }
                }
            }
        }
        this.added = true;
    }

    public void afterRead() {
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    @Override
    public void color(Color color) {
        this.color = color;
    }

    @Override
    public void data(Object data) {
        this.data = data;
    }

    public void draw() {
        this.lifetime = this.effect.render(this.id, this.color, this.time, this.lifetime, this.rotation, this.x, this.y, this.data);
    }

    @Override
    public void effect(Effect effect) {
        this.effect = effect;
    }

    public void id(int id) {
        this.id = id;
    }

    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public void offsetPos(float offsetPos) {
        this.offsetPos = offsetPos;
    }

    @Override
    public void offsetRot(float offsetRot) {
        this.offsetRot = offsetRot;
    }

    @Override
    public void offsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    @Override
    public void offsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    @Override
    public void parent(Posc parent) {
        this.parent = parent;
    }

    public void read(Reads read) {
        this.afterRead();
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.draw.remove((Entityc)this);
        Groups.all.remove((Entityc)this);
        this.added = false;
        Groups.queueFree((Pool.Poolable)this);
    }

    public void reset() {
        this.added = false;
        this.color = new Color(Color.white);
        this.data = null;
        this.effect = null;
        this.id = EntityGroup.nextId();
        this.lifetime = 0.0f;
        this.offsetPos = 0.0f;
        this.offsetRot = 0.0f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.parent = null;
        this.rotWithParent = false;
        this.rotation = 0.0f;
        this.time = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    @Override
    public void rotWithParent(boolean rotWithParent) {
        this.rotWithParent = rotWithParent;
    }

    public void rotation(float rotation) {
        this.rotation = rotation;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void time(float time) {
        this.time = time;
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    /*
     * Unable to fully structure code
     */
    public void update() {
        block5: {
            if (this.parent == null) break block5;
            if (!this.rotWithParent) ** GOTO lbl-1000
            var3_1 = this.parent;
            if (var3_1 instanceof Rotc) {
                r = (Rotc)var3_1;
                this.x = this.parent.getX() + Angles.trnsx((float)(r.rotation() + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                this.y = this.parent.getY() + Angles.trnsy((float)(r.rotation() + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                this.rotation = r.rotation() + this.offsetRot;
            } else {
                var3_1 = this.parent;
                if (var3_1 instanceof BaseTurret.BaseTurretBuild) {
                    build = (BaseTurret.BaseTurretBuild)var3_1;
                    this.x = this.parent.getX() + Angles.trnsx((float)(build.rotation + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                    this.y = this.parent.getY() + Angles.trnsy((float)(build.rotation + this.offsetPos), (float)this.offsetX, (float)this.offsetY);
                    this.rotation = build.rotation + this.offsetRot;
                } else lbl-1000:
                // 2 sources

                {
                    this.x = this.parent.getX() + this.offsetX;
                    this.y = this.parent.getY() + this.offsetY;
                }
            }
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    public void write(Writes write) {
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public static TurretParentEffectState create() {
        return (TurretParentEffectState)Pools.obtain(TurretParentEffectState.class, TurretParentEffectState::new);
    }
}

