/*
 * Decompiled with CFR 0.152.
 */
package progressed.gen.entities;

import arc.func.Func;
import arc.func.Prov;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.util.Structs;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import progressed.gen.entities.NoCoreDepositBuildingTetherLegsUnit;
import progressed.gen.entities.SentryUnit;
import progressed.gen.entities.SignalFlareUnit;
import progressed.gen.entities.SwordUnit;
import progressed.gen.entities.TurretParentEffectState;

public final class EntityRegistry {
    private static final ObjectIntMap<Class<? extends Entityc>> ids = new ObjectIntMap();
    private static final ObjectMap<String, Prov<? extends Entityc>> map = new ObjectMap();

    private EntityRegistry() {
        throw new AssertionError();
    }

    public static <T extends Entityc> Prov<T> get(Class<T> type) {
        return EntityRegistry.get(type.getCanonicalName());
    }

    public static <T extends Entityc> Prov<T> get(String name) {
        return (Prov)map.get((Object)name);
    }

    public static <T extends Entityc> void register(String name, Class<T> type, Prov<? extends T> prov) {
        map.put((Object)name, prov);
        ids.put(type, EntityMapping.register((String)name, prov));
    }

    public static <T, E extends Entityc> T content(String name, Class<E> type, Func<String, ? extends T> create) {
        if (type.getName().startsWith("mindustry.gen.")) {
            Prov prov = (Prov)Structs.find((Object[])EntityMapping.idMap, p -> p != null && p.get().getClass().equals(type));
            EntityMapping.nameMap.put((Object)("prog-mats-" + name), (Object)prov);
        } else {
            EntityMapping.nameMap.put((Object)("prog-mats-" + name), EntityRegistry.get(type));
        }
        return (T)create.get((Object)name);
    }

    public static int getID(Class<? extends Entityc> type) {
        return ids.get(type, -1);
    }

    public static void register() {
        EntityRegistry.register("progressed.gen.entities.NoCoreDepositBuildingTetherLegsUnit", NoCoreDepositBuildingTetherLegsUnit.class, NoCoreDepositBuildingTetherLegsUnit::create);
        EntityRegistry.register("progressed.gen.entities.SentryUnit", SentryUnit.class, SentryUnit::create);
        EntityRegistry.register("progressed.gen.entities.SignalFlareUnit", SignalFlareUnit.class, SignalFlareUnit::create);
        EntityRegistry.register("progressed.gen.entities.SwordUnit", SwordUnit.class, SwordUnit::create);
        EntityRegistry.register("progressed.gen.entities.TurretParentEffectState", TurretParentEffectState.class, TurretParentEffectState::create);
    }
}

