/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.part;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;
import mindustry.graphics.Pal;

public class LaunchPart
extends DrawPart {
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public float layer = 110.0f;
    public float start;
    public float length;
    public float spacing;
    public int arrows = 2;

    public void draw(DrawPart.PartParams params) {
        float prog = this.progress.getClamp(params);
        float w = this.spacing + this.spacing * (1.0f - prog);
        Lines.stroke((float)(prog * 1.2f), (Color)Pal.accent);
        float z = Draw.z();
        Draw.z((float)this.layer);
        for (int sign : Mathf.signs) {
            Tmp.v1.trns(params.rotation, this.start, w * (float)sign);
            Lines.lineAngle((float)(params.x + Tmp.v1.x), (float)(params.y + Tmp.v1.y), (float)params.rotation, (float)this.length);
        }
        Draw.scl((float)(prog * 1.1f));
        for (int i = 0; i < this.arrows; ++i) {
            Tmp.v1.trns(params.rotation, this.start + this.length / (float)(this.arrows + 1) * (float)(i + 1));
            Draw.rect((String)"bridge-arrow", (float)(params.x + Tmp.v1.x), (float)(params.y + Tmp.v1.y), (float)params.rotation);
        }
        Draw.reset();
        Draw.z((float)z);
    }

    public void load(String name) {
    }
}

