/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.part;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.entities.part.DrawPart;

public class AimLaserPart
extends DrawPart {
    public DrawPart.PartProgress progress = DrawPart.PartProgress.warmup;
    public DrawPart.PartProgress alpha = DrawPart.PartProgress.constant((float)1.0f);
    public Blending blending = Blending.normal;
    public float layer = -1.0f;
    public float layerOffset;
    public float x;
    public float y;
    public float width = 1.0f;
    public float length = 32.0f;
    public Color colorFrom = Color.red;
    public Color colorTo;

    public void draw(DrawPart.PartParams params) {
        float z = Draw.z();
        if (this.layer > 0.0f) {
            Draw.z((float)this.layer);
        }
        Draw.z((float)(Draw.z() + this.layerOffset));
        Draw.blend((Blending)this.blending);
        float a = this.alpha.getClamp(params);
        float c1 = Tmp.c1.set(this.colorFrom).mulA(a).toFloatBits();
        float c2 = Tmp.c2.set(this.colorTo).mulA(a).toFloatBits();
        float rot = params.rotation - 90.0f;
        Tmp.v1.trns(rot, this.x, this.y);
        float rx = params.x + Tmp.v1.x;
        float ry = params.y + Tmp.v1.y;
        float cos = Mathf.cosDeg((float)rot) * this.width / 2.0f;
        float sin = Mathf.sinDeg((float)rot) * this.width / 2.0f;
        Tmp.v1.trns(params.rotation, this.length * this.progress.getClamp(params)).add(rx, ry);
        Fill.quad((float)(rx + cos), (float)(ry + sin), (float)c1, (float)(rx - cos), (float)(ry - sin), (float)c1, (float)(Tmp.v1.x - cos), (float)(Tmp.v1.y - sin), (float)c2, (float)(Tmp.v1.x + cos), (float)(Tmp.v1.y + sin), (float)c2);
        Draw.blend();
        Draw.z((float)z);
    }

    public void load(String name) {
        if (this.colorTo == null) {
            this.colorTo = this.colorFrom.cpy().a(0.0f);
        }
    }
}

