/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.unit;

import arc.graphics.g2d.Draw;
import arc.math.geom.Position;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import progressed.gen.entities.SentryUnit;

public class SentryBulletType
extends BulletType {
    public SentryBulletType(UnitType unit) {
        super(10.0f, 0.0f);
        this.despawnUnit = unit;
        this.despawnUnitRadius = 0.0f;
        this.lifetime = 35.0f;
        this.collides = false;
        this.collidesTiles = false;
        this.collidesAir = false;
        this.collidesGround = false;
        this.scaleLife = true;
        this.hitEffect = this.despawnEffect = Fx.none;
        this.ammoMultiplier = 1.0f;
        this.layer = 50.01f;
    }

    public void init(Bullet b) {
        super.init(b);
        b.data = this.despawnUnit.create(b.team);
    }

    public void draw(Bullet b) {
        Unit u = (Unit)b.data;
        u.set((Position)b);
        u.rotation(b.rotation());
        float z = Draw.z();
        Draw.z((float)Math.min(80.0f, z - 1.0f));
        u.type.drawShadow(u);
        Draw.z((float)z);
        u.draw();
    }

    public void createUnits(Bullet b, float x, float y) {
        Unit u = (Unit)b.data;
        u.set((Position)b);
        u.rotation(b.rotation());
        u.vel.add(b.vel());
        if (u instanceof SentryUnit) {
            SentryUnit s = (SentryUnit)u;
            s.anchorVel.add(b.vel());
        }
        u.add();
    }
}

