/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.pseudo3d;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Time;
import arc.util.Tmp;
import blackhole.utils.BlackHoleUtils;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Unit;
import mindustry.gen.Velc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import progressed.content.effects.Pseudo3DFx;
import progressed.content.effects.TrailFadeFx;
import progressed.graphics.PMDrawf;
import progressed.graphics.draw3d.Draw3D;
import progressed.graphics.draw3d.Perspective;
import progressed.graphics.trails.ZTrail;
import progressed.util.Math3D;
import progressed.util.PMMathf;

public abstract class ArcBulletType
extends BulletType {
    private static final Vec2 homingTarget = new Vec2();
    private static float cdist = 0.0f;
    private static Unit result;
    public boolean zAbsorbable = true;
    public boolean isInheritive;
    public Color absorbEffectColor = Pal.missileYellowBack;
    public Effect absorbEffect = Pseudo3DFx.absorbedSmall;
    public float gravity = 1.0f;
    public float lifetimeScl = 1.0f;
    public float arcFragCone = 1.0f;
    public float intervalDropCone = 0.0f;
    public float angleDriftDrag = 0.02f;
    public boolean bloomTrail = true;
    public boolean drawZone = false;
    public boolean drawTarget = true;
    public boolean drawProgress = true;
    public float zoneLayer = 100.0f;
    public float targetRadius = 12.0f;
    public float zoneRadius = 24.0f;
    public float progressRadius = -1.0f;
    public float spikesWidth1 = -1.0f;
    public float spikesLength1 = -1.0f;
    public float spikesWidth2 = -1.0f;
    public float spikesLength2 = -1.0f;
    public float spokeWidth = 2.0f;
    public float spokeLength = 8.0f;
    public float spikeSpin = 0.5f;
    public float zoneLifeOffset = 0.0f;
    public float growTime = 10.0f;
    public float shrinkTime = 0.0f;
    public Color zoneColor = Color.red;
    public Color targetColor = Color.red;

    public ArcBulletType(float speed, float damage) {
        super(speed, damage);
        this.reflectable = false;
        this.absorbable = false;
        this.hittable = false;
        this.collides = false;
        this.despawnHit = true;
        this.scaleLife = true;
        this.trailLength = 8;
        this.layer = 145.0f;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.lightOpacity = 0.0f;
    }

    public ArcBulletType(float speed) {
        this(speed, 0.0f);
    }

    public void initDrawSize(float range) {
        ArcBulletType a;
        float size = (range + this.rangeChange + this.zoneRadius) * 2.0f;
        this.drawSize = Math.max(size, this.drawSize);
        BulletType bulletType = this.fragBullet;
        if (bulletType instanceof ArcBulletType) {
            a = (ArcBulletType)bulletType;
            a.initDrawSize(range);
        }
        if ((bulletType = this.intervalBullet) instanceof ArcBulletType) {
            a = (ArcBulletType)bulletType;
            a.initDrawSize(range);
        }
    }

    public void init() {
        ArcBulletType a;
        BulletType bulletType;
        if (this.spikesLength2 < 0.0f) {
            this.spikesLength2 = this.zoneRadius / 2.0f;
        }
        if (this.spikesLength1 < 0.0f) {
            this.spikesLength1 = this.spikesLength2 / 2.0f;
        }
        if (this.spikesWidth1 < 0.0f) {
            this.spikesWidth1 = this.spikesLength1 / 2.0f;
        }
        if (this.spikesWidth2 < 0.0f) {
            this.spikesWidth2 = this.spikesWidth1;
        }
        if (this.progressRadius < 0.0f) {
            this.progressRadius = Math.max(this.drawZone ? this.zoneRadius + Math.max(this.spikesLength1, this.spikesLength2) / 2.0f : 0.0f, this.targetRadius + this.spokeLength / 2.0f) + 4.0f;
        }
        if ((bulletType = this.fragBullet) instanceof ArcBulletType) {
            a = (ArcBulletType)bulletType;
            a.isInheritive = true;
            a.zoneLifeOffset = a.zoneLifeOffset * a.lifetimeScl + this.lifetimeScl;
            this.shrinkTime = 0.0f;
        }
        if ((bulletType = this.intervalBullet) instanceof ArcBulletType) {
            a = (ArcBulletType)bulletType;
            a.isInheritive = true;
        }
        super.init();
    }

    public abstract ArcBulletData createData();

    public abstract ArcBulletData createData(float var1, float var2, float var3);

    public void init(Bullet b) {
        if (b.data instanceof ArcBulletData) {
            ArcBulletData a = (ArcBulletData)b.data;
            a.updateLifetime(b);
            this.arcBulletDataInit(b);
        } else {
            b.data = this.createData();
            b.remove();
        }
        super.init(b);
    }

    public void arcBulletDataInit(Bullet b) {
        if (this.isInheritive) {
            return;
        }
        ArcBulletData a = (ArcBulletData)b.data;
        a.updateAccel(b);
    }

    public void update(Bullet b) {
        Object object = b.data;
        if (!(object instanceof ArcBulletData)) {
            return;
        }
        ArcBulletData data = (ArcBulletData)object;
        data.update(b);
        super.update(b);
        if (b.time > b.lifetime * this.lifetimeScl || data.z <= 0.0f) {
            b.remove();
        }
    }

    public void despawned(Bullet b) {
        if (b.absorbed) {
            return;
        }
        if (this.despawnHit) {
            boolean hit = this.calcNearbyHit(b);
            if (!hit) {
                this.hit(b);
            }
        } else {
            this.createUnits(b, b.x, b.y);
        }
        if (!this.fragOnHit) {
            this.createFrags(b, b.x, b.y);
        }
        this.despawnEffect.at(b.x, b.y, b.rotation(), this.hitColor);
        this.despawnSound.at((Position)b);
        Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
    }

    public void removed(Bullet b) {
        if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
            TrailFadeFx.zTrailFade.at(b.x, b.y, this.trailWidth, this.trailColor, (Object)b.trail.copy());
        }
    }

    public boolean calcNearbyHit(Bullet b) {
        Building build;
        cdist = 0.0f;
        result = null;
        float range = 1.0f;
        Units.nearbyEnemies((Team)b.team, (float)(b.x - range), (float)(b.y - range), (float)(range * 2.0f), (float)(range * 2.0f), e -> {
            if (e.dead() || !e.checkTarget(this.collidesAir, this.collidesGround) || !e.hittable()) {
                return;
            }
            e.hitbox(Tmp.r1);
            if (!Tmp.r1.contains(b.x, b.y)) {
                return;
            }
            float dst = e.dst(b.x, b.y) - e.hitSize;
            if (result == null || dst < cdist) {
                result = e;
                cdist = dst;
            }
        });
        if (result != null) {
            b.collision((Hitboxc)result, b.x, b.y);
            return true;
        }
        if (this.collidesTiles && (build = Vars.world.buildWorld(b.x, b.y)) != null && build.team != b.team) {
            build.collision(b);
            this.hit(b);
            return true;
        }
        return false;
    }

    public void createFrags(Bullet b, float x, float y) {
        BulletType bulletType = this.fragBullet;
        if (bulletType instanceof ArcBulletType) {
            ArcBulletType aType = (ArcBulletType)bulletType;
            for (int i = 0; i < this.fragBullets; ++i) {
                float a = b.rotation() + Mathf.range((float)(this.fragRandomSpread / 2.0f)) + this.fragAngle + ((float)i - (float)this.fragBullets / 2.0f) * this.fragSpread;
                ((ArcBulletData)aType.create3DInherit((Bullet)b, (float)a, (float)this.arcFragCone).data).splitFrom = (ArcBulletType)b.type;
            }
        } else {
            super.createFrags(b, x, y);
        }
    }

    public void updateBulletInterval(Bullet b) {
        BulletType bulletType = this.intervalBullet;
        if (bulletType instanceof ArcBulletType) {
            ArcBulletType aType = (ArcBulletType)bulletType;
            if (b.time >= this.intervalDelay && b.timer.get(2, this.bulletInterval)) {
                float ang = b.rotation();
                for (int i = 0; i < this.intervalBullets; ++i) {
                    float a = ang + Mathf.range((float)this.intervalRandomSpread) + this.intervalAngle + ((float)i - ((float)this.intervalBullets - 1.0f) / 2.0f) * this.intervalSpread;
                    aType.create3DInherit(b, a, aType.intervalDropCone);
                }
            }
        } else {
            super.updateBulletInterval(b);
        }
    }

    public void updateHoming(Bullet b) {
        Object target;
        if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay && (target = this.heals() ? Units.closestTarget(null, (float)b.aimX, (float)b.aimY, (float)this.homingRange, e -> e.checkTarget(this.collidesAir, this.collidesGround) && e.team != b.team && !b.hasCollided(e.id), t -> this.collidesGround && (t.team != b.team || t.damaged()) && !b.hasCollided(t.id)) : (b.aimTile != null && b.aimTile.build != null && b.aimTile.build.team != b.team && this.collidesGround && !b.hasCollided(b.aimTile.build.id) ? b.aimTile.build : Units.closestTarget((Team)b.team, (float)b.aimX, (float)b.aimY, (float)this.homingRange, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id)))) != null) {
            homingTarget.set((Position)target);
            if (target instanceof Velc) {
                Velc v = (Velc)target;
                homingTarget.mulAdd(v.vel(), b.lifetime - b.time);
            }
            ((ArcBulletData)b.data).updateHoming(b, (Position)homingTarget);
        }
    }

    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new ZTrail(this.trailLength);
            }
            ZTrail trail = (ZTrail)b.trail;
            trail.length = this.trailLength;
            trail.update(b.x, b.y, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)), ((ArcBulletData)b.data).z);
        }
    }

    public void draw(Bullet b) {
        this.drawTargetZone(b);
        Draw.z((float)this.layer);
        this.drawTrail(b);
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            Draw3D.highBloom(this.bloomTrail, () -> {
                b.trail.draw(this.trailColor, this.trailWidth);
                b.trail.drawCap(this.trailColor, this.trailWidth);
            });
            Draw.z((float)z);
        }
    }

    public void drawTargetZone(Bullet b) {
        float a;
        boolean split;
        Draw.z((float)this.zoneLayer);
        Draw.color((Color)this.zoneColor);
        float realLife = b.lifetime * this.lifetimeScl;
        float grow = Mathf.curve((float)b.time, (float)0.0f, (float)this.growTime);
        float shrink = Mathf.curve((float)b.time, (float)(realLife - this.shrinkTime), (float)realLife);
        float scl = grow - shrink;
        ArcBulletType splitFrom = ((ArcBulletData)b.data).splitFrom;
        boolean bl = split = splitFrom != null;
        if (split) {
            grow = Interp.smooth.apply(grow);
        }
        float fout = 1.0f - shrink;
        float x = b.aimX;
        float y = b.aimY;
        float ang = Mathf.randomSeed((long)b.id, (float)360.0f) + b.time * this.spikeSpin;
        if (this.drawZone) {
            float zR = split ? Mathf.lerp((float)splitFrom.zoneRadius, (float)this.zoneRadius, (float)grow) * fout : this.zoneRadius * scl;
            PMDrawf.ring(x, y, zR, zR + 2.0f);
            float sW1 = split ? Mathf.lerp((float)splitFrom.spikesWidth1, (float)this.spikesWidth1, (float)grow) * fout : this.spikesWidth1 * scl;
            float sL1 = split ? Mathf.lerp((float)splitFrom.spikesLength1, (float)this.spikesLength1, (float)grow) * fout : this.spikesLength1 * scl;
            for (int i = 0; i < 4; ++i) {
                a = ang + (float)(90 * i);
                Drawf.tri((float)(x + Angles.trnsx((float)a, (float)zR)), (float)(y + Angles.trnsy((float)a, (float)zR)), (float)sW1, (float)sL1, (float)(a + 180.0f));
                Drawf.tri((float)(x + Angles.trnsx((float)a, (float)zR)), (float)(y + Angles.trnsy((float)a, (float)zR)), (float)sW1, (float)(sL1 / 2.0f), (float)a);
            }
            float sW2 = split ? Mathf.lerp((float)splitFrom.spikesWidth2, (float)this.spikesWidth2, (float)grow) * fout : this.spikesWidth2 * scl;
            float sL2 = split ? Mathf.lerp((float)splitFrom.spikesLength2, (float)this.spikesLength2, (float)grow) * fout : this.spikesLength2 * scl;
            for (int i = 0; i < 4; ++i) {
                float a2 = ang + 45.0f + (float)(90 * i);
                Drawf.tri((float)(x + Angles.trnsx((float)a2, (float)zR)), (float)(y + Angles.trnsy((float)a2, (float)zR)), (float)sW2, (float)sL2, (float)(a2 + 180.0f));
                Drawf.tri((float)(x + Angles.trnsx((float)a2, (float)zR)), (float)(y + Angles.trnsy((float)a2, (float)zR)), (float)sW2, (float)(sL2 / 2.0f), (float)a2);
            }
        }
        if (this.drawProgress) {
            float fin = b.fin() / this.lifetimeScl;
            float pR = split ? Mathf.lerp((float)splitFrom.progressRadius, (float)this.progressRadius, (float)grow) * fout : this.progressRadius * scl;
            PMDrawf.progressRing(x, y, pR, pR + 4.0f, fin);
        }
        if (this.drawTarget) {
            float tR = split ? Mathf.lerp((float)splitFrom.targetRadius, (float)this.targetRadius, (float)grow) * fout : this.targetRadius * scl;
            float sW = split ? Mathf.lerp((float)splitFrom.spokeWidth, (float)this.spokeWidth, (float)grow) * fout : this.spokeWidth * scl;
            float sL = split ? Mathf.lerp((float)splitFrom.spokeLength, (float)this.spokeLength, (float)grow) * fout : this.spokeLength * scl;
            PMDrawf.ring(x, y, tR, tR + 2.0f);
            Lines.stroke((float)sW);
            for (int i = 0; i < 4; ++i) {
                a = -ang + (float)(90 * i);
                Lines.lineAngleCenter((float)(x + Angles.trnsx((float)a, (float)tR)), (float)(y + Angles.trnsy((float)a, (float)tR)), (float)a, (float)sL, (boolean)false);
            }
        }
        Draw.color();
    }

    public void drawLight(Bullet b) {
        if (this.lightOpacity <= 0.0f || this.lightRadius <= 0.0f) {
            return;
        }
        ArcBulletData data = (ArcBulletData)b.data;
        Vec2 pos = Perspective.drawPos(b.x, b.y, data.z);
        Drawf.light((float)pos.x, (float)pos.y, (float)(this.lightRadius * Perspective.scale(b.x, b.y, data.z)), (Color)this.lightColor, (float)(this.lightOpacity * Perspective.alpha(b.x, b.y, data.z)));
    }

    public Bullet create3D(Entityc owner, Team team, float x, float y, float z, float angle, float tilt, float aimX, float aimY) {
        return this.create3D(owner, team, x, y, z, angle, tilt, this.gravity, aimX, aimY);
    }

    public Bullet create3D(Entityc owner, Team team, float x, float y, float z, float angle, float tilt, float gravity, float aimX, float aimY) {
        return this.create3D(owner, team, x, y, z, angle, tilt, gravity, 1.0f, aimX, aimY);
    }

    public Bullet create3D(Entityc owner, Team team, float x, float y, float z, float angle, float tilt, float gravity, float velocityScl, float aimX, float aimY) {
        Vec3 vel = Math3D.rotate(Tmp.v31, this.speed, angle, 0.0f, tilt);
        ArcBulletData data = this.createData(z, vel.z * velocityScl, gravity);
        Bullet bullet = this.beginBulletCreate(owner, team, x, y, aimX, aimY);
        bullet.rotation(angle);
        bullet.vel.set(vel.x, vel.y);
        bullet.set(x, y);
        bullet.lastX = x;
        bullet.lastY = y;
        bullet.data = data;
        bullet.hitSize = this.hitSize;
        if (bullet.trail != null) {
            bullet.trail.clear();
        }
        bullet.add();
        return bullet;
    }

    public Bullet create3DVel(Entityc owner, Team team, float x, float y, float z, float angle, float zVel, float accel, float aimX, float aimY) {
        return this.create3DVel(owner, team, x, y, z, angle, zVel, this.gravity, accel, 0.0f, aimX, aimY);
    }

    public Bullet create3DVel(Entityc owner, Team team, float x, float y, float z, float angle, float zVel, float accel, float vel, float aimX, float aimY) {
        return this.create3DVel(owner, team, x, y, z, angle, zVel, this.gravity, accel, vel, aimX, aimY);
    }

    public Bullet create3DVel(Entityc owner, Team team, float x, float y, float z, float angle, float zVel, float gravity, float accel, float vel, float aimX, float aimY) {
        ArcBulletData data = this.createData(z, zVel, gravity).setAccel(accel);
        Bullet bullet = this.beginBulletCreate(owner, team, x, y, aimX, aimY);
        bullet.initVel(angle, vel);
        bullet.set(x, y);
        bullet.lastX = x;
        bullet.lastY = y;
        bullet.data = data;
        bullet.hitSize = this.hitSize;
        if (bullet.trail != null) {
            bullet.trail.clear();
        }
        bullet.add();
        return bullet;
    }

    public Bullet create3DInherit(Bullet b, float angle, float inaccCone) {
        return this.create3DInherit(b, angle, inaccCone, this.gravity);
    }

    public Bullet create3DInherit(Bullet b, float angle, float inaccCone, float gravity) {
        Tmp.v1.trns(angle, inaccCone * Mathf.sqrt((float)Mathf.random()));
        ArcBulletData oldData = (ArcBulletData)b.data;
        ArcBulletData data = oldData.copy();
        data.gravity = gravity;
        if (!Mathf.zero((float)inaccCone)) {
            PMMathf.randomCirclePoint(Tmp.v1, inaccCone);
            data.driftYaw = Tmp.v1.x + oldData.driftYaw;
            data.driftPitch = Tmp.v1.y + oldData.driftPitch;
        }
        Bullet bullet = this.beginBulletCreate(b.owner, b.team, b.x, b.y, b.aimX, b.aimY);
        bullet.initVel(b.rotation(), b.vel.len());
        bullet.set(b.x, b.y);
        bullet.lastX = b.x;
        bullet.lastY = b.y;
        bullet.data = data;
        bullet.hitSize = this.hitSize;
        bullet.add();
        return bullet;
    }

    public Bullet beginBulletCreate(Entityc owner, Team team, float x, float y, float damage, float aimX, float aimY) {
        Bullet bullet = Bullet.create();
        bullet.type = this;
        bullet.owner = owner;
        bullet.team = team;
        bullet.time = 0.0f;
        bullet.originX = x;
        bullet.originY = y;
        bullet.aimX = aimX;
        bullet.aimY = aimY;
        if (aimX != -1.0f || aimY != -1.0f) {
            bullet.aimTile = Vars.world.tileWorld(aimX, aimY);
        }
        bullet.damage = (damage < 0.0f ? this.damage : damage) * bullet.damageMultiplier();
        return bullet;
    }

    public Bullet beginBulletCreate(Entityc owner, Team team, float x, float y, float aimX, float aimY) {
        return this.beginBulletCreate(owner, team, x, y, -1.0f, aimX, aimY);
    }

    public Bullet beginBulletCreate(Entityc owner, Team team, float x, float y) {
        return this.beginBulletCreate(owner, team, x, y, -1.0f, x, y);
    }

    static {
        BlackHoleUtils.immuneBulletTypes.add(ArcBulletType.class);
    }

    public static abstract class ArcBulletData
    implements Cloneable {
        public float lastZ;
        public float z;
        public float zVel;
        public float gravity;
        public float driftYaw;
        public float driftPitch;
        public ArcBulletType splitFrom;

        public ArcBulletData(float z, float zVel, float gravity) {
            this.z = z;
            this.zVel = zVel;
            this.gravity = gravity;
        }

        public ArcBulletData(float z, float zVel) {
            this(z, zVel, 1.0f);
        }

        public ArcBulletData() {
            this(0.0f, 0.0f);
        }

        public void updateLifetime(Bullet b) {
            b.lifetime(PMMathf.solve(-0.5f * this.gravity, this.zVel, this.z) + b.time);
        }

        public abstract void updateAccel(Bullet var1);

        public void updateAimPos(Bullet b) {
            float life = b.lifetime() - b.time();
            b.aimX = 0.5f * this.xAccel(b) * life * life + b.vel.x * life + b.x;
            b.aimY = 0.5f * this.yAccel(b) * life * life + b.vel.y * life + b.y;
        }

        public void update(Bullet b) {
            this.lastZ = this.z;
            this.z += this.zVel * Time.delta;
            this.zVel -= this.gravity * Time.delta;
            boolean needUpdate = false;
            if (!Mathf.zero((float)this.driftYaw)) {
                b.vel.rotate(this.driftYaw);
                this.driftYaw *= 1.0f - ((ArcBulletType)b.type).angleDriftDrag;
                needUpdate = true;
            }
            if (!Mathf.zero((float)this.driftPitch)) {
                Tmp.v1.set(b.vel.len(), this.zVel).rotate(this.driftPitch);
                this.zVel = Tmp.v1.y;
                this.driftPitch *= 1.0f - ((ArcBulletType)b.type).angleDriftDrag;
                this.updateLifetime(b);
                needUpdate = true;
            }
            if (needUpdate) {
                this.updateAimPos(b);
            }
        }

        public abstract void updateHoming(Bullet var1, Position var2);

        public abstract ArcBulletData setAccel(float var1);

        public abstract float xAccel(Bullet var1);

        public abstract float yAccel(Bullet var1);

        public ArcBulletData copy() {
            try {
                return (ArcBulletData)this.clone();
            }
            catch (CloneNotSupportedException whywhywhywhywhywhywhywhy) {
                throw new RuntimeException("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", whywhywhywhywhywhywhywhy);
            }
        }
    }
}

