/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.physical;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Teamc;

public class MagnetBulletType
extends BasicBulletType {
    public float force = 0.1f;
    public float scaledForce;
    public float attractRange;
    public float lifeExtention = 0.5f;

    public MagnetBulletType(float speed, float damage, String sprite) {
        super(speed, damage, sprite);
        this.shootEffect = Fx.shootBig;
        this.drag = 0.018f;
        this.shrinkY = 0.0f;
        this.shrinkX = 0.0f;
        this.height = 8.0f;
        this.width = 8.0f;
    }

    public MagnetBulletType(float speed, float damage) {
        this(speed, damage, "prog-mats-magnet");
    }

    public void update(Bullet b) {
        super.update(b);
        if (b.timer(1, 2.0f)) {
            Teamc target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.attractRange, e -> e.checkTarget(this.collidesAir, this.collidesGround), t -> this.collidesGround);
            if (target != null) {
                Tmp.v1.trns(b.angleTo((Position)target), this.force + (1.0f - b.dst((Position)target) / this.attractRange) * this.scaledForce);
                if (!Tmp.v1.isZero()) {
                    b.vel().add(Tmp.v1);
                    b.lifetime(b.lifetime + this.lifeExtention);
                }
                Tmp.v1.setZero();
            }
            b.data = target;
        }
    }

    public void draw(Bullet b) {
        Teamc t;
        float height = this.height * (1.0f - this.shrinkY + this.shrinkY * b.fout());
        float width = this.width * (1.0f - this.shrinkX + this.shrinkX * b.fout());
        float offset = this.spin != 0.0f ? Mathf.randomSeed((long)b.id, (float)360.0f) + b.time * this.spin : 0.0f;
        Object object = b.data;
        float a = -90.0f + (object instanceof Teamc && (t = (Teamc)object).isAdded() ? b.angleTo((Position)t) : b.rotation() + offset);
        Color mix = Tmp.c1.set(this.mixColorFrom).lerp(this.mixColorTo, b.fin());
        Draw.mixcol((Color)mix, (float)mix.a);
        Draw.color((Color)this.backColor);
        Draw.rect((TextureRegion)this.backRegion, (float)b.x, (float)b.y, (float)width, (float)height, (float)a);
        Draw.color((Color)this.frontColor);
        Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)width, (float)height, (float)a);
        Draw.reset();
    }
}

