/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.explosive;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Sounds;
import mindustry.gen.Velc;
import mindustry.graphics.Trail;
import progressed.content.effects.TrailFadeFx;

public class RocketBulletType
extends BasicBulletType {
    public float backSpeed = 1.0f;
    public float fallDrag = 0.05f;
    public float thrustDelay = 20.0f;
    public float thrusterSize = 4.0f;
    public float thrusterOffset = 8.0f;
    public float thrusterGrowth = 5.0f;
    public float trailDelay = -1.0f;
    public float trailOffset = 0.0f;
    public float acceleration = 0.03f;
    public float rotOffset = 0.0f;
    public float riseStart;
    public float riseEnd;
    public float targetLayer = -1.0f;
    public Units.Sortf unitSort = Position::dst2;

    public RocketBulletType(float speed, float damage, String sprite) {
        super(speed, damage, sprite);
        this.layer = 99.0f;
        this.keepVelocity = false;
        this.reflectable = false;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.despawnEffect = this.hitEffect = Fx.blastExplosion;
        this.hitSound = Sounds.largeExplosion;
        this.status = StatusEffects.blasted;
        this.scaledSplashDamage = true;
    }

    public void init() {
        super.init();
        if (this.homingDelay < 0.0f) {
            this.homingDelay = this.thrustDelay;
        }
        if (this.targetLayer < 0.0f) {
            this.targetLayer = this.layer;
        }
        if (this.trailDelay < 0.0f) {
            this.trailDelay = this.thrusterGrowth;
        }
    }

    public void load() {
        super.load();
        this.backRegion = Core.atlas.find(this.sprite + "-outline");
    }

    public void update(Bullet b) {
        Object object = b.data;
        if (object instanceof RocketData) {
            RocketData r = (RocketData)object;
            if (b.time < this.thrustDelay && this.thrustDelay > 0.0f) {
                b.vel.scl(Math.max(1.0f - this.fallDrag * Time.delta, 0.0f));
            } else {
                if (!r.thrust) {
                    b.vel.setAngle(r.angle);
                    b.vel.setLength(this.speed);
                    r.thrust = true;
                }
                b.vel.scl(Math.max(1.0f + this.acceleration * Time.delta, 0.0f));
                this.updateHoming(b);
                this.updateWeaving(b);
                float angle = r.thrust ? b.rotation() : r.angle;
                float x = b.x + Angles.trnsx((float)(angle + 180.0f), (float)this.trailOffset);
                float y = b.y + Angles.trnsy((float)(angle + 180.0f), (float)this.trailOffset);
                float scale = Mathf.curve((float)b.time, (float)this.thrustDelay, (float)(this.thrustDelay + this.thrusterGrowth));
                if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
                    this.trailEffect.at(x, y, this.trailRotation ? b.rotation() : this.trailParam * scale, b.team.color, (Object)new float[]{b.rotation(), scale, this.getLayer(b)});
                }
                if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
                    this.trailEffect.at(x, y, this.trailRotation ? b.rotation() : this.trailParam * scale, b.team.color, (Object)new float[]{b.rotation(), scale, this.getLayer(b)});
                }
                if (!Vars.headless && this.trailLength > 0 && b.time >= this.trailDelay) {
                    if (b.trail == null) {
                        b.trail = new Trail(this.trailLength);
                    }
                    b.trail.length = this.trailLength;
                    b.trail.update(x, y, this.trailInterp.apply(b.fin()) * scale);
                }
            }
        }
    }

    public void draw(Bullet b) {
        Object object = b.data;
        if (object instanceof RocketData) {
            RocketData r = (RocketData)object;
            float angle = r.thrust ? b.rotation() : r.angle;
            Draw.z((float)this.getLayer(b));
            float z = Draw.z();
            if (b.time >= this.thrustDelay || this.thrustDelay <= 0.0f) {
                float scale = Mathf.curve((float)b.time, (float)this.thrustDelay, (float)(this.thrustDelay + this.thrusterGrowth));
                float offset = this.thrusterOffset / 2.0f + this.thrusterOffset / 2.0f * scale;
                if (this.trailLength > 0 && b.trail != null) {
                    Draw.z((float)(z - 1.0E-4f));
                    b.trail.draw(b.team.color, this.trailWidth * scale);
                    Draw.z((float)z);
                }
                Draw.color((Color)b.team.color);
                Fill.circle((float)(b.x + Angles.trnsx((float)(angle + 180.0f), (float)offset)), (float)(b.y + Angles.trnsy((float)(angle + 180.0f), (float)offset)), (float)((this.thrusterSize + Mathf.absin((float)Time.time, (float)2.0f, (float)(this.thrusterSize / 4.0f))) * scale));
                Draw.color((Color)Color.white);
                Fill.circle((float)(b.x + Angles.trnsx((float)(angle + 180.0f), (float)(offset - this.thrusterSize / 2.0f))), (float)(b.y + Angles.trnsy((float)(angle + 180.0f), (float)(offset - this.thrusterSize / 2.0f))), (float)((this.thrusterSize + Mathf.absin((float)Time.time, (float)2.0f, (float)(this.thrusterSize / 4.0f))) / 2.0f * scale));
                Draw.color();
            }
            if (this.backRegion.found()) {
                Draw.z((float)(z - 0.01f));
                Draw.rect((TextureRegion)this.backRegion, (float)b.x, (float)b.y, (float)(angle - 90.0f + this.rotOffset));
            }
            Draw.z((float)z);
            Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)(angle - 90.0f + this.rotOffset));
            Draw.reset();
        }
    }

    public void removed(Bullet b) {
        if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
            TrailFadeFx.rocketTrailFade.at(b.x, b.y, this.trailWidth, b.team.color, (Object)new RocketTrailData(b.trail.copy(), this.getLayer(b)));
        }
    }

    public float getLayer(Bullet b) {
        float progress = Mathf.curve((float)b.time, (float)this.riseStart, (float)this.riseEnd);
        return Mathf.lerp((float)this.layer, (float)this.targetLayer, (float)progress);
    }

    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, Mover mover, float aimX, float aimY) {
        Bullet bullet = super.create(owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY);
        if (this.backSpeed != 0.0f) {
            bullet.initVel(angle, -this.backSpeed * velocityScl);
            bullet.set(x, y);
            bullet.lastX = x;
            bullet.lastY = y;
            if (this.keepVelocity && owner instanceof Velc) {
                Velc v = (Velc)owner;
                bullet.vel.add(v.vel());
            }
        }
        bullet.data = new RocketData(angle);
        return bullet;
    }

    public static class RocketData {
        float angle;
        boolean thrust;

        public RocketData(float angle) {
            this.angle = angle;
        }
    }

    public static class RocketTrailData {
        public Trail trail;
        public float layer;

        public RocketTrailData(Trail trail, float layer) {
            this.trail = trail;
            this.layer = layer;
        }
    }
}

